/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.exasol.model.ExaLikeSchema;
import com.intellij.database.dialects.exasol.model.ExaSchema;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.util.Version;
import java.sql.Timestamp;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\r/0123456789:;B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00040\nJ*\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00040\nJ\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020(0#2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020,J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020.0#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020,\u00a8\u0006<"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "()V", "processAllObjects", "", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "s", "Lcom/intellij/database/dialects/exasol/model/ExaLikeSchema;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ObjectInfo;", "processAllSysObjects", "Lcom/intellij/database/dialects/exasol/model/ExaSchema;", "processColumns", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ColumnInfo;", "processConnections", "selectAnyDict", "", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ConnectionInfo;", "processConstraints", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ConstraintColumnInfo;", "processFunctions", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$FunctionInfo;", "processIndices", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$IndexInfo;", "processRoles", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$RoleInfo;", "processScripts", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ScriptInfo;", "processUsers", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$UserInfo;", "processViews", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ViewInfo;", "retrieveAllSchemas", "", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$SchemaInfo;", "r", "Lcom/intellij/database/model/basic/BasicRoot;", "retrieveOpenedSchema", "", "retrievePrivileges", "retrieveVSchemaExtInfo", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$VSchemaExtInfo;", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "retrieveVSchemaProps", "Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$VSchemaProperty;", "ColumnInfo", "ConnectionInfo", "ConstraintColumnInfo", "FunctionInfo", "IndexInfo", "ObjectInfo", "RoleInfo", "SchemaInfo", "ScriptInfo", "UserInfo", "VSchemaExtInfo", "VSchemaProperty", "ViewInfo", "intellij.database.dialects.exasol"})
public final class ExaIntroQueries
extends BaseIntroQueries {
    public static final ExaIntroQueries INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String retrieveOpenedSchema(@NotNull DBTransaction transaction) {
        void $this$retrieveOne$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "select current_schema";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveOne = false;
        return (String)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOne$iv, String.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> retrievePrivileges(@NotNull DBTransaction transaction) {
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "select privilege from sys.exa_session_privs p(privilege) where privilege in ('SELECT ANY DICTIONARY')";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, String.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SchemaInfo> retrieveAllSchemas(@NotNull DBTransaction transaction, @NotNull BasicRoot r) {
        void query$iv;
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Version version = r.getServerVersion();
        if (version == null) {
            version = Version.ZERO;
        }
        Version ver = version;
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select schema_object_id id, schema_name name, schema_owner owner,\n       " + (ver.isOrGreater(new int[]{6}) ? "schema_is_virtual" : "false") + " is_virtual,\n    schema_comment comment from sys.exa_schemas\n  union all\nselect 0, 'SYS', null, false, null\n  union all\nselect 0, 'EXA_STATISTICS', null, false , null\n";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, SchemaInfo.class, (String)query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VSchemaExtInfo retrieveVSchemaExtInfo(@NotNull DBTransaction transaction, @NotNull ExaVirtualSchema s) {
        void query$iv;
        void $this$retrieveOneStruct$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select adapter_script, last_refresh, last_refresh_by\n    from sys.exa_virtual_schemas\n    where schema_object_id = ?\n";
        Object[] parameters$iv = new Long[]{s.getObjectId()};
        boolean $i$f$retrieveOneStruct = false;
        ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.structOf(VSchemaExtInfo.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)resultLayout, (String)"rowOf(structOf(R::class.java))");
        return (VSchemaExtInfo)BaseIntroQueries.access$retrieve((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOneStruct$iv, resultLayout, (String)query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VSchemaProperty> retrieveVSchemaProps(@NotNull DBTransaction transaction, @NotNull ExaVirtualSchema s) {
        void query$iv;
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select property_name prop_name, property_value prop_value\n    from sys.exa_all_virtual_schema_properties\n    where schema_object_id = ?\n";
        Object[] parameters$iv = new Long[]{s.getObjectId()};
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, VSchemaProperty.class, (String)query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processAllObjects(@NotNull DBTransaction transaction, @NotNull ExaLikeSchema s, @NotNull Function1<? super ObjectInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select object_name name, object_id id, object_comment comment, object_type type\n    from sys.exa_all_objects\n    where root_id = ?\n";
        Object[] parameters$iv = new Long[]{s.getObjectId()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ObjectInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processAllSysObjects(@NotNull DBTransaction transaction, @NotNull ExaSchema s, @NotNull Function1<? super ObjectInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select object_name name, -1 id, object_comment comment, object_type type\nfrom sys.exa_syscat\nwhere schema_name = ?\n";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ObjectInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull DBTransaction transaction, @NotNull ExaLikeSchema s, @NotNull Function1<? super ColumnInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select column_table table_name , column_object_type = 'TABLE' is_table,\n       column_name name, column_type type, column_ordinal_position pos,\n       column_is_nullable is_nullable, column_is_distribution_key is_dist_key,\n       column_default def, column_identity ident, column_comment comment\n  from sys.exa_all_columns\n  where column_schema = ?\n  order by table_name\n";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ColumnInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processConstraints(@NotNull DBTransaction transaction, @NotNull ExaSchema s, @NotNull Function1<? super ConstraintColumnInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select constraint_table table_name, constraint_type = 'PRIMARY KEY' is_pk,\n       constraint_name name, column_name, ordinal_position pos,\n       referenced_schema ref_schema, referenced_table ref_table, referenced_column ref_column\n  from sys.exa_all_constraint_columns\n  where constraint_schema = ? AND constraint_type <> 'NOT NULL'\n  order by table_name, constraint_name, ordinal_position\n";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ConstraintColumnInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processViews(@NotNull DBTransaction transaction, @NotNull ExaSchema s, @NotNull Function1<? super ViewInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select view_name name, view_text text\n  from sys.exa_all_views\n  where view_schema = ?\n";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ViewInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processFunctions(@NotNull DBTransaction transaction, @NotNull ExaSchema s, @NotNull Function1<? super FunctionInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select function_name name, function_text text\n  from sys.exa_all_functions\n  where function_schema = ?\n";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, FunctionInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processScripts(@NotNull DBTransaction transaction, @NotNull ExaSchema s, @NotNull Function1<? super ScriptInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        BasicModModel basicModModel = (BasicModModel)s.getModel();
        if (basicModModel == null || (basicModModel = basicModModel.getRoot()) == null || (basicModModel = basicModModel.getServerVersion()) == null) {
            basicModModel = Version.ZERO;
        }
        BasicModModel ver = basicModModel;
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select script_name name, script_type type, script_language lang,\n        " + (ver.isOrGreater(new int[]{6}) ? "script_input_type" : "null") + " input_type, script_result_type result_type, script_text text\n  from sys.exa_all_scripts\n  where script_schema = ?\n  ";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ScriptInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndices(@NotNull DBTransaction transaction, @NotNull ExaSchema s, @NotNull Function1<? super IndexInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select index_object_id id, index_table table_name, index_type = 'GLOBAL' is_global, remarks\n    from sys.exa_all_indices\n    where index_schema = ?\n    order by index_table\n";
        Object[] parameters$iv = new String[]{s.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, IndexInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processUsers(@NotNull DBTransaction transaction, @NotNull Function1<? super UserInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select user_name name, user_comment comment, created is null is_system\n  from sys.exa_all_users\n  ";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, UserInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoles(@NotNull DBTransaction transaction, @NotNull Function1<? super RoleInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select role_name name, role_comment comment, created is null is_system\n  from sys.exa_all_roles\n  ";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, RoleInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processConnections(@NotNull DBTransaction transaction, boolean selectAnyDict, @NotNull Function1<? super ConnectionInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = selectAnyDict ? "select connection_name name, connection_comment comment,\n        connection_string, user_name\n    from sys.exa_dba_connections\n" : "select connection_name name, connection_comment comment,\n        null connection_string, null user_name\n    from sys.exa_all_connections\n";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ConnectionInfo.class, (String)query$iv, parameters$iv, null, action);
    }

    private ExaIntroQueries() {
    }

    static {
        ExaIntroQueries exaIntroQueries;
        INSTANCE = exaIntroQueries = new ExaIntroQueries();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$SchemaInfo;", "", "()V", "comment", "", "id", "", "is_virtual", "", "name", "owner", "intellij.database.dialects.exasol"})
    public static final class SchemaInfo {
        @JvmField
        public long id;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String owner;
        @JvmField
        public boolean is_virtual;
        @JvmField
        @Nullable
        public String comment;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$VSchemaExtInfo;", "", "()V", "adapter_script", "", "last_refreshed", "Ljava/sql/Timestamp;", "last_refreshed_by", "intellij.database.dialects.exasol"})
    public static final class VSchemaExtInfo {
        @JvmField
        @Nullable
        public String adapter_script;
        @JvmField
        @Nullable
        public Timestamp last_refreshed;
        @JvmField
        @Nullable
        public String last_refreshed_by;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$VSchemaProperty;", "", "()V", "prop_name", "", "prop_value", "intellij.database.dialects.exasol"})
    public static final class VSchemaProperty {
        @JvmField
        @Nullable
        public String prop_name;
        @JvmField
        @Nullable
        public String prop_value;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ObjectInfo;", "", "()V", "comment", "", "id", "", "name", "type", "intellij.database.dialects.exasol"})
    public static final class ObjectInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        public long id;
        @JvmField
        @Nullable
        public String comment;
        @JvmField
        @Nullable
        public String type;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ColumnInfo;", "", "()V", "comment", "", "def", "ident", "", "Ljava/lang/Long;", "is_dist_key", "", "is_nullable", "Ljava/lang/Boolean;", "is_table", "name", "pos", "", "table_name", "type", "intellij.database.dialects.exasol"})
    public static final class ColumnInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        public boolean is_table = true;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String type = "";
        @JvmField
        public short pos;
        @JvmField
        @Nullable
        public Boolean is_nullable;
        @JvmField
        public boolean is_dist_key;
        @JvmField
        @Nullable
        public String def;
        @JvmField
        @Nullable
        public Long ident;
        @JvmField
        @Nullable
        public String comment;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ConstraintColumnInfo;", "", "()V", "column_name", "", "is_pk", "", "name", "pos", "", "Ljava/lang/Short;", "ref_column", "ref_schema", "ref_table", "table_name", "intellij.database.dialects.exasol"})
    public static final class ConstraintColumnInfo {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        public boolean is_pk;
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String column_name;
        @JvmField
        @Nullable
        public Short pos;
        @JvmField
        @Nullable
        public String ref_schema;
        @JvmField
        @Nullable
        public String ref_table;
        @JvmField
        @Nullable
        public String ref_column;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ViewInfo;", "", "()V", "name", "", "text", "intellij.database.dialects.exasol"})
    public static final class ViewInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String text;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$FunctionInfo;", "", "()V", "name", "", "text", "intellij.database.dialects.exasol"})
    public static final class FunctionInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String text;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ScriptInfo;", "", "()V", "input_type", "", "lang", "name", "result_type", "text", "type", "intellij.database.dialects.exasol"})
    public static final class ScriptInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String type;
        @JvmField
        @Nullable
        public String lang;
        @JvmField
        @Nullable
        public String input_type;
        @JvmField
        @Nullable
        public String result_type;
        @JvmField
        @Nullable
        public String text;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$IndexInfo;", "", "()V", "id", "", "is_global", "", "remarks", "", "table_name", "intellij.database.dialects.exasol"})
    public static final class IndexInfo {
        @JvmField
        public long id;
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        public boolean is_global;
        @JvmField
        @Nullable
        public String remarks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$UserInfo;", "", "()V", "comment", "", "is_system", "", "name", "intellij.database.dialects.exasol"})
    public static final class UserInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String comment;
        @JvmField
        public boolean is_system;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$RoleInfo;", "", "()V", "comment", "", "is_system", "", "name", "intellij.database.dialects.exasol"})
    public static final class RoleInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String comment;
        @JvmField
        public boolean is_system;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/exasol/introspector/ExaIntroQueries$ConnectionInfo;", "", "()V", "comment", "", "connection_string", "name", "user_name", "intellij.database.dialects.exasol"})
    public static final class ConnectionInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String comment;
        @JvmField
        @Nullable
        public String connection_string;
        @JvmField
        @Nullable
        public String user_name;
    }
}

