/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\u001a \u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a9\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0014\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005\u001a\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\"\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u001c\u0010\u001b\u001a\u00020\u001a2\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00100\u001c\u001a\u0017\u0010\u001d\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\r0\u0012H\u0002\u00a2\u0006\u0002\u0010\u001e\"E\u0010\u0000\u001a9\u00120\u0012.\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004 \u0006*\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"UNSORTED_COLUMNS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/database/model/basic/BasicLikeTable;", "", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "computeUnsorted", "srcTable", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "findSortedPrefix", "", "columns", "", "Lcom/intellij/database/model/ElementAlteration;", "lens", "", "end", "(Ljava/util/List;[Ljava/lang/Integer;I)I", "getPrevColumn", "col", "getUnsortedColumns", "getUnsortedHolder", "hasExistingColumnAfter", "", "nullizeSorted", "", "indexOfMax", "([Ljava/lang/Integer;)I", "intellij.database.dialects.base"})
public final class LikeColumnProducersKt {
    private static final Key<Map<BasicLikeTable, Set<BasicLikeColumn>>> UNSORTED_COLUMNS;

    @Nullable
    public static final BasicLikeColumn getPrevColumn(@NotNull BasicLikeColumn col) {
        Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
        short pos = col.getPosition();
        if (pos == (short)1) {
            return null;
        }
        BasicLikeTable basicLikeTable = col.getLikeTable();
        if (basicLikeTable == null || (basicLikeTable = basicLikeTable.getColumns()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable, (String)"col.likeTable?.columns ?: return null");
        BasicLikeTable columns = basicLikeTable;
        short maxPos = (short)0;
        BasicLikeColumn maxCol = null;
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur;
            BasicLikeColumn basicLikeColumn = cur = (BasicLikeColumn)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeColumn, (String)"cur");
            short curPos = basicLikeColumn.getPosition();
            if (curPos >= pos || curPos <= maxPos) continue;
            maxPos = curPos;
            maxCol = cur;
        }
        return maxCol;
    }

    public static final boolean hasExistingColumnAfter(@NotNull BasicLikeColumn col, @NotNull ScriptingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)col, (String)"col");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getByTarget().isEmpty()) {
            return false;
        }
        short pos = col.getPosition();
        BasicLikeTable basicLikeTable = col.getLikeTable();
        if (basicLikeTable == null || (basicLikeTable = basicLikeTable.getColumns()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeTable, (String)"col.likeTable?.columns ?: return false");
        BasicLikeTable columns = basicLikeTable;
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn cur;
            BasicLikeColumn basicLikeColumn = cur = (BasicLikeColumn)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicLikeColumn, (String)"cur");
            if (basicLikeColumn.getPosition() <= pos) continue;
            ElementDelta<?> elementDelta = context.getByTarget().get(cur);
            if ((elementDelta != null ? elementDelta.getSourceElement() : null) == null) continue;
            return true;
        }
        return false;
    }

    private static final Set<BasicLikeColumn> getUnsortedColumns(BasicLikeTable srcTable, ScriptingContext context) {
        Set<BasicLikeColumn> set;
        Map<BasicLikeTable, Set<BasicLikeColumn>> $this$getOrPut$iv = LikeColumnProducersKt.getUnsortedHolder(context);
        boolean $i$f$getOrPut = false;
        Set<BasicLikeColumn> value$iv = $this$getOrPut$iv.get(srcTable);
        if (value$iv == null) {
            boolean bl = false;
            Set<Object> set2 = LikeColumnProducersKt.computeUnsorted(srcTable, context);
            if (set2 == null) {
                Set set3 = Collections.emptySet();
                set2 = set3;
                Intrinsics.checkExpressionValueIsNotNull(set3, (String)"Collections.emptySet()");
            }
            Set<BasicLikeColumn> answer$iv = set2;
            $this$getOrPut$iv.put(srcTable, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        return set;
    }

    private static final Map<BasicLikeTable, Set<BasicLikeColumn>> getUnsortedHolder(ScriptingContext context) {
        Map map2 = (Map)UNSORTED_COLUMNS.get(context.getSharedData());
        if (map2 != null) {
            Map map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map it = map3;
            boolean bl3 = false;
            return it;
        }
        HashMap res2 = new HashMap();
        UNSORTED_COLUMNS.set(context.getSharedData(), res2);
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<BasicLikeColumn> computeUnsorted(BasicLikeTable srcTable, ScriptingContext context) {
        void $this$mapNotNullTo$iv;
        List list;
        boolean bl;
        boolean bl2 = false;
        List columns = new ArrayList();
        for (BasicLikeColumn srcCol : srcTable.getColumns()) {
            ElementDelta<?> elementDelta = context.getBySource().get(srcCol);
            if (!(elementDelta instanceof ElementAlteration)) {
                elementDelta = null;
            }
            if ((ElementAlteration)elementDelta == null) continue;
            bl = false;
            boolean bl3 = false;
            List it = list;
            boolean bl4 = false;
            if ((BasicLikeColumn)it.getTargetElement() == srcCol) continue;
            columns.add(it);
        }
        if (columns.isEmpty()) {
            return null;
        }
        Iterable $this$sortBy$iv = columns;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            list = $this$sortBy$iv;
            bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ElementAlteration it = (ElementAlteration)a;
                    boolean bl2 = false;
                    ElementAlteration elementAlteration = it;
                    if (elementAlteration == null) {
                        Intrinsics.throwNpe();
                    }
                    it = (ElementAlteration)b;
                    Comparable comparable = Short.valueOf(((BasicLikeColumn)elementAlteration.getSourceElement()).getPosition());
                    bl2 = false;
                    ElementAlteration elementAlteration2 = it;
                    if (elementAlteration2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Short s = ((BasicLikeColumn)elementAlteration2.getSourceElement()).getPosition();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)s);
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator);
        }
        if (!LikeColumnProducersKt.nullizeSorted(columns)) {
            return null;
        }
        $this$sortBy$iv = columns;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicLikeColumn basicLikeColumn;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl5 = false;
            ElementAlteration it = (ElementAlteration)element$iv;
            boolean bl6 = false;
            ElementAlteration elementAlteration = it;
            if ((elementAlteration != null ? (BasicLikeColumn)elementAlteration.getSourceElement() : null) == null) continue;
            basicLikeColumn = basicLikeColumn;
            boolean bl7 = false;
            boolean bl8 = false;
            BasicLikeColumn it$iv = basicLikeColumn;
            boolean bl9 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    public static final boolean nullizeSorted(@NotNull List<ElementAlteration<BasicLikeColumn>> columns) {
        Integer n;
        int n2;
        Integer[] integerArray;
        int n3;
        Intrinsics.checkParameterIsNotNull(columns, (String)"columns");
        int n4 = columns.size();
        Integer[] integerArray2 = new Integer[n4];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5;
            n3 = n5++;
            integerArray = integerArray2;
            n2 = 0;
            integerArray[n3] = n = Integer.valueOf(0);
        }
        Integer[] lens = integerArray2;
        int n7 = columns.size();
        Integer[] integerArray3 = new Integer[n7];
        int it = 0;
        while (it < n7) {
            n2 = it;
            n3 = it++;
            integerArray = integerArray3;
            boolean bl = false;
            integerArray[n3] = n = Integer.valueOf(-1);
        }
        Integer[] backRefs = integerArray3;
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n8 = index$iv++;
            boolean bl = false;
            if (n8 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n9 = n8;
            ElementAlteration elementAlteration = (ElementAlteration)item$iv;
            int i2 = n9;
            boolean bl2 = false;
            int maxi = LikeColumnProducersKt.findSortedPrefix(columns, lens, i2);
            backRefs[i2] = maxi;
            lens[i2] = maxi == -1 ? 1 : lens[maxi] + 1;
        }
        int idx = LikeColumnProducersKt.indexOfMax(lens);
        if (lens[idx].intValue() == columns.size()) {
            return false;
        }
        while (idx != -1) {
            columns.set(idx, null);
            idx = backRefs[idx];
        }
        return true;
    }

    private static final int findSortedPrefix(List<? extends ElementAlteration<? extends BasicLikeColumn>> columns, Integer[] lens, int end) {
        ElementAlteration<? extends BasicLikeColumn> elementAlteration = columns.get(end);
        if (elementAlteration == null) {
            Intrinsics.throwNpe();
        }
        short pos = ((BasicLikeColumn)elementAlteration.getTargetElement()).getPosition();
        int max = 0;
        int maxi = -1;
        int k = end - 1;
        while (k >= 0) {
            int kk = k--;
            ElementAlteration<? extends BasicLikeColumn> prev = columns.get(kk);
            int cur = lens[kk] + 1;
            if (cur <= max) continue;
            ElementAlteration<? extends BasicLikeColumn> elementAlteration2 = prev;
            if (elementAlteration2 == null) {
                Intrinsics.throwNpe();
            }
            if (pos <= ((BasicLikeColumn)elementAlteration2.getTargetElement()).getPosition()) continue;
            max = cur;
            maxi = kk;
            if (max != kk + 1) continue;
            return maxi;
        }
        return maxi;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfMax(@NotNull Integer[] $this$indexOfMax) {
        int maxi = 0;
        int max = ((Number)$this$indexOfMax[0]).intValue();
        Integer[] $this$forEachIndexed$iv = $this$indexOfMax;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Integer item$iv : $this$forEachIndexed$iv) {
            void v2;
            int n = index$iv++;
            int n2 = ((Number)item$iv).intValue();
            int i2 = n;
            boolean bl = false;
            if (max >= v2) continue;
            max = v2;
            maxi = i2;
        }
        return maxi;
    }

    static {
        Key key2 = Key.create((String)"UNSORTED_COLUMNS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<MutableMap<Ba\u2026mn>>>(\"UNSORTED_COLUMNS\")");
        UNSORTED_COLUMNS = key2;
    }

    public static final /* synthetic */ Set access$getUnsortedColumns(BasicLikeTable srcTable, ScriptingContext context) {
        return LikeColumnProducersKt.getUnsortedColumns(srcTable, context);
    }
}

