/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator;

import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.OperationType;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementCreation;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ElementRemotion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.ObjectPath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B@\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012!\b\u0002\u0010\t\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0000\"\n\b\u0001\u0010\u0014\u0018\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u0002H\u0014H\u0086\b\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u000e\u0010\u001c\u001a\u00020\u001d*\u0006\u0012\u0002\b\u00030\u001eR*\u0010\t\u001a\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/base/generator/ElementProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/BaseProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "type", "Lcom/intellij/database/dialects/base/generator/OperationType;", "element", "delegate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/base/generator/OperationType;Lcom/intellij/database/model/basic/BasicElement;Lkotlin/jvm/functions/Function1;)V", "getDelegate", "()Lkotlin/jvm/functions/Function1;", "getElement", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "cast", "U", "e", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/dialects/base/generator/ElementProducer;", "getPreliminaryOrder", "", "produce", "shortText", "toString", "isSupported", "", "Lcom/intellij/database/model/ElementDelta;", "intellij.database.dialects.base"})
public class ElementProducer<T extends BasicElement>
extends BaseProducer {
    @NotNull
    private final T element;
    @Nullable
    private final Function1<ElementProducer<T>, Unit> delegate;

    @NotNull
    public final /* synthetic */ <U extends BasicElement> ElementProducer<U> cast(@NotNull U e) {
        int $i$f$cast = 0;
        Intrinsics.checkParameterIsNotNull(e, (String)"e");
        boolean bl = Intrinsics.areEqual(e, this.getElement());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ElementProducer elementProducer = this;
        if (elementProducer == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.base.generator.ElementProducer<U>");
        }
        return elementProducer;
    }

    @Override
    public void produce() {
        block0: {
            Function1<ElementProducer<T>, Unit> function1 = this.delegate;
            if (function1 == null) break block0;
            Function1<ElementProducer<T>, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<ElementProducer<T>, Unit> it = function12;
            boolean bl3 = false;
            it.invoke((Object)this);
        }
    }

    @Override
    @NotNull
    public String getPreliminaryOrder() {
        return this.getContext().getHelper().getObjectPreliminaryOrder((BasicElement)this.element);
    }

    @Override
    @NotNull
    public String shortText() {
        return this.getType().getDebugName() + ' ' + this.element.getKind().code();
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.shortText()).append(' ');
        ObjectPath objectPath = BasicPaths.of(this.element);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectPath, (String)"BasicPaths.of(element)");
        return stringBuilder.append(objectPath.getDisplayName()).toString();
    }

    public final boolean isSupported(@NotNull ElementDelta<?> $this$isSupported) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($this$isSupported, (String)"$this$isSupported");
        ElementDelta<?> elementDelta = $this$isSupported;
        if (elementDelta instanceof ElementRemotion) {
            bl = (Boolean)this.getContext().getHelper().createDropProducer(this.getContext(), ((ElementRemotion)$this$isSupported).getSourceElement()).canDropAlone().get(this.getTask().getVersion());
        } else if (elementDelta instanceof ElementCreation) {
            bl = (Boolean)this.getContext().getHelper().createProducer(this.getContext(), ((ElementCreation)$this$isSupported).getTargetElement()).canCreateAlone().get(this.getTask().getVersion());
        } else if (elementDelta instanceof ElementAlteration) {
            bl = this.getContext().getHelper().createAlterProducer(this.getContext(), (ElementAlteration)$this$isSupported).canProduce();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final T getElement() {
        return this.element;
    }

    @Nullable
    public final Function1<ElementProducer<T>, Unit> getDelegate() {
        return this.delegate;
    }

    public ElementProducer(@NotNull ScriptingContext context, @NotNull OperationType type, @NotNull T element, @Nullable Function1<? super ElementProducer<T>, Unit> delegate) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(element, (String)"element");
        super(context, type);
        this.element = element;
        this.delegate = delegate;
    }

    public /* synthetic */ ElementProducer(ScriptingContext scriptingContext, OperationType operationType, BasicElement basicElement, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = null;
        }
        this(scriptingContext, operationType, basicElement, function1);
    }
}

