/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDatabaseErrorHandler
implements DatabaseErrorHandler {
    protected final Logger LOG = Logger.getInstance(this.getClass());

    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        if (original == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        String causeMsg = JdbcUtil.getMessage((Throwable)cause);
        String origMsg = JdbcUtil.getMessage((Throwable)original);
        if (original != cause && original instanceof SQLException && !origMsg.equals(causeMsg)) {
            BaseDatabaseErrorHandler.appendGenericMessage(original, sb);
        }
        if (cause instanceof UnsupportedOperationException) {
            sb.append(causeMsg);
        } else if (cause instanceof SQLException) {
            SQLException next;
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)causeMsg) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)cause)).append(causeMsg);
            }
            if ((next = (SQLException)ObjectUtils.doIfCast((Object)cause, SQLException.class, ex -> ex.getNextException())) != null && next != cause) {
                sb.append("\n").append(this.getErrorMessage(dataSource, next, ExceptionUtil.getRootCause((Throwable)next), fixes));
            }
        } else if (cause instanceof ClassNotFoundException) {
            this.handleClassNotFound(sb, dataSource, cause.getMessage(), fixes);
        } else if (cause instanceof ExecutionException && cause.getMessage() != null) {
            DatabaseDriver driver = dataSource == null ? null : dataSource.getDatabaseDriver();
            Matcher matcher = Pattern.compile("java\\.lang\\.(ClassNotFoundException|InstantiationException):\\s+((?:\\w+\\.)*\\w+)").matcher(cause.getMessage());
            if (matcher.find()) {
                boolean notFound = "ClassNotFoundException".equals(matcher.group(1));
                if (notFound) {
                    this.handleClassNotFound(sb, dataSource, matcher.group(2), fixes);
                } else {
                    sb.append(DatabaseBundle.message((String)"message.driver.class.not.instantiable", (Object[])new Object[]{matcher.group(2)}));
                    this.addChangeClassFix(driver, fixes);
                }
            } else {
                matcher = Pattern.compile(Pattern.quote("Missing native authentication library: ") + "(.*)").matcher(cause.getMessage());
                if (matcher.find()) {
                    sb.append("Missing native authentication library: ").append(matcher.group(1)).append("\nEnsure that supplied driver is up to date or jar with native library is added");
                    this.addEditDriverFix(driver, fixes);
                }
            }
        } else if (cause instanceof RemoteException) {
            sb.append(cause.toString());
        } else if (cause instanceof EOFException && original instanceof RemoteException) {
            sb.append(dataSource).append(": process exited");
        } else if (cause instanceof IOException) {
            sb.append(cause.toString());
        } else if (cause instanceof SuppressUserStackTrace) {
            sb.append(causeMsg);
        } else if (cause instanceof ExecutionException) {
            sb.append(causeMsg);
            this.LOG.warn(cause);
        } else if (cause instanceof JdbcEngine.UnsafeUpdateRolledBackException) {
            sb.append(cause.getMessage());
        } else if (cause instanceof OutOfMemoryError) {
            sb.append(DatabaseBundle.message((String)"error.message.remote.oomerror", (Object[])new Object[]{dataSource == null ? null : dataSource.getName()}));
        } else if (original instanceof NoClassDefFoundError) {
            sb.append(DatabaseBundle.message((String)"missing.driver.class", (Object[])new Object[]{original.getMessage()}));
            this.LOG.warn(cause);
        } else {
            sb.append(causeMsg);
            this.LOG.warn(original);
        }
        String string = sb.toString();
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void addEditDriverFix(DatabaseDriver driver, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        BaseDatabaseErrorHandler.addSettingsFix(fixes, "Edit driver", driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)c -> {}));
    }

    protected void handleClassNotFound(StringBuilder sb, final @Nullable LocalDataSource dataSource, String message, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        DatabaseDriver driver;
        sb.append(DatabaseBundle.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{message}));
        DatabaseDriver databaseDriver = driver = dataSource == null ? null : dataSource.getDatabaseDriver();
        if (driver == null || DbImplUtil.hasDriverFiles((LocalDataSource)dataSource)) {
            this.addChangeClassFix(driver, fixes);
            return;
        }
        DatabaseDriver.ArtifactRef artifact = driver.getArtifact();
        if (artifact == null || !artifact.isUsed()) {
            sb.append(" ").append(DatabaseBundle.message((String)"DataSourceConfigurable.no.driver.files", (Object[])new Object[0]));
            this.addEditDriverFix(driver, fixes);
            return;
        }
        final boolean downloaded = artifact.isRolling() && DatabaseDriverValidator.isDriverFilesUpToDate((String)artifact.getName(), (String)"latest", (boolean)artifact.isRolling(), (Collection)driver.getClasspathElements());
        sb.append(" ").append(DatabaseBundle.message((String)(downloaded ? "DataSourceConfigurable.drivers.not.configured" : "DataSourceConfigurable.drivers.not.downloaded"), (Object[])new Object[0]));
        if (fixes != null) {
            fixes.consume((Object)new DatabaseErrorHandler.Fix(){

                public String getName() {
                    return DatabaseBundle.message((String)(downloaded ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver"), (Object[])new Object[0]);
                }

                public void apply(@Nullable DatabaseConfigEditor editor) {
                    final NamedProgressive task = DatabaseDriverValidator.createDownloaderTask((LocalDataSource)dataSource, (DatabaseConfigEditor)editor);
                    new Task.Modal(ProjectUtil.guessCurrentProject(null), task.getName(), true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            task.run(indicator);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/base/BaseDatabaseErrorHandler$1$1", "run"));
                        }
                    }.queue();
                }
            });
        }
    }

    protected void addChangeClassFix(DatabaseDriver driver, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        BaseDatabaseErrorHandler.addSettingsFix(fixes, "Change driver class", driver, (Consumer<? super DatabaseDriverConfigurable>)((Consumer)DatabaseDriverConfigurable::focusDriverClassSelector));
    }

    @Nullable
    public Boolean mayRequestPassword(@NotNull SQLException e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean isPasswordExpired(@NotNull SQLException e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(4);
        }
        return false;
    }

    protected static void appendGenericMessage(@NotNull Throwable e, @NotNull StringBuilder sb) {
        String message;
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(5);
        }
        if (sb == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(6);
        }
        if (StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = JdbcUtil.getMessage((Throwable)e))) == -1) {
            sb.append(JdbcUtil.getMessagePrefix((Throwable)e)).append(message).append("\n");
        }
    }

    @NotNull
    protected static String getGenericMessage(@NotNull Throwable t) {
        if (t == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        BaseDatabaseErrorHandler.appendGenericMessage(t, sb);
        String string = sb.toString();
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message, @NotNull String queryText, @Nullable StringFinder finder) {
        Matcher matcher;
        if (pattern == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(9);
        }
        if (message == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(10);
        }
        if (queryText == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(11);
        }
        if ((matcher = Pattern.compile(pattern).matcher(message)).find()) {
            return BaseDatabaseErrorHandler.getOffsetFromMessageImpl(queryText, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null, finder);
        }
        return -1;
    }

    protected static int getOffsetFromMessageImpl(@NotNull String queryText, @Nullable String near, @Nullable String strLine, @Nullable String strColumn, @Nullable StringFinder finder) {
        int offset;
        int column2;
        if (queryText == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(12);
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column2 = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column2 < 0 ? -1 : column2 - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column2 < 0 ? 0 : column2 - 1)));
        if (line > -1 && column2 > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText, near, offset);
        return refined == -1 ? offset : refined;
    }

    protected static StringFinder byTokenFinder(@NotNull Language language, @NotNull Project project, int cropping) {
        if (language == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(13);
        }
        if (project == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(14);
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)language);
            if (parser == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    public static void addSettingsFix(@Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes, @Nls @NotNull String name2, @Nullable LocalDataSource ds, @NotNull Consumer<? super DataSourceConfigurable> consumer) {
        if (name2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(16);
        }
        if (fixes != null && ds != null) {
            fixes.consume((Object)BaseDatabaseErrorHandler.settingsFix(name2, ds, consumer));
        }
    }

    public static void addSettingsFix(@Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes, @Nls @NotNull String name2, @Nullable DatabaseDriver dr, @NotNull Consumer<? super DatabaseDriverConfigurable> consumer) {
        if (name2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(17);
        }
        if (consumer == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(18);
        }
        if (fixes != null && dr != null) {
            fixes.consume((Object)BaseDatabaseErrorHandler.settingsFix(name2, dr, consumer));
        }
    }

    public static DatabaseErrorHandler.Fix settingsFix(final @NotNull String name2, final @NotNull LocalDataSource ds, final @NotNull Consumer<? super DataSourceConfigurable> consumer) {
        if (name2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(19);
        }
        if (ds == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(21);
        }
        return new DatabaseErrorHandler.Fix(){

            public String getName() {
                return name2;
            }

            public boolean isSilent() {
                return false;
            }

            public void apply(@Nullable DatabaseConfigEditor editor) {
                if (editor == null) {
                    return;
                }
                DataSourceUiUtil.navigate((DatabaseConfigEditor)editor, (LocalDataSource)ds, (Consumer)consumer);
            }
        };
    }

    public static DatabaseErrorHandler.Fix settingsFix(final @NotNull String name2, final @NotNull DatabaseDriver dr, final @NotNull Consumer<? super DatabaseDriverConfigurable> consumer) {
        if (name2 == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(22);
        }
        if (dr == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(23);
        }
        if (consumer == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(24);
        }
        return new DatabaseErrorHandler.Fix(){

            public String getName() {
                return name2;
            }

            public boolean isSilent() {
                return false;
            }

            public void apply(@Nullable DatabaseConfigEditor editor) {
                if (editor == null) {
                    return;
                }
                DataSourceUiUtil.navigate((DatabaseConfigEditor)editor, (DatabaseDriver)dr, (Consumer)consumer);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/BaseDatabaseErrorHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/BaseDatabaseErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordExpired";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendGenericMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGenericMessage";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromMessageImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "byTokenFinder";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsFix";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "settingsFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }
}

