/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.RemoteMappingsListener;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentServersEditor;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentConfigurable
implements SearchableConfigurable,
Configurable.Composite,
Configurable.NoMargin,
Configurable.NoScroll,
Disposable {
    private static final Logger LOG = Logger.getInstance(DeploymentConfigurable.class);
    @NotNull
    private final Project myProject;
    private DeploymentServersEditor myEditor;
    private Configurable[] myChildren;

    public DeploymentConfigurable(@Nullable Project project) {
        this.myProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
    }

    private void createEditor() {
        this.myEditor = new DeploymentServersEditor(DeploymentConfigurableTabProvider.EP_NAME.getExtensionList(), (UserDataHolder)new UserDataHolderBase(), this.myProject);
    }

    @Nls
    public String getDisplayName() {
        return WDBundle.message("deployment.configurable.name", new Object[0]);
    }

    public static void show(@Nullable WebServerConfig server, boolean newServer, @Nullable Project project, int tabIndex) {
        DeploymentConfigurable configurable = new DeploymentConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            String nameToSelect;
            if (newServer) {
                SshUiData data = server == null ? null : server.getOrCreateSshUiData(project);
                SettingsDeployable settingsDeployable = SettingsDeployable.create(server, false, data);
                configurable.myEditor.onItemCreated(settingsDeployable, null);
                configurable.myEditor.getToolbar().dispatchEvent(new KeyEvent(configurable.myEditor.getToolbar(), 401, System.currentTimeMillis(), 0, 32, ' '));
            }
            Object object = server == null ? (project == null ? null : PublishConfig.getInstance(project).getDefaultServerOrGroupName()) : (nameToSelect = server.getName());
            if (nameToSelect != null) {
                configurable.myEditor.selectNamedItem(nameToSelect, true);
                Object selectedObject = configurable.myEditor.getSelectedObject();
                if (tabIndex != -1 && selectedObject instanceof SettingsDeployable) {
                    DeploymentConfigurableForm f = configurable.myEditor.getServerConfigurable((SettingsDeployable)selectedObject);
                    LOG.assertTrue(f != null);
                    f.setSelectedTabIndex(tabIndex);
                }
            }
        });
    }

    @NotNull
    public String getId() {
        return "web.server";
    }

    public String getHelpTopic() {
        return "reference.settings.deployment";
    }

    public JComponent createComponent() {
        if (this.myEditor == null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

                @Override
                public void deploymentConfigChanged() {
                    DeploymentConfigurable.this.reset();
                }
            });
            this.createEditor();
        }
        return this.myEditor.createComponent();
    }

    public boolean isModified() {
        return this.myEditor.isModified();
    }

    public void reset() {
        this.myEditor.reset();
    }

    public void apply() throws ConfigurationException {
        this.myEditor.apply();
        ((RemoteMappingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RemoteMappingsListener.REMOTE_MAPPINGS_CHANGED)).mappingsChanged();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public Configurable @NotNull [] getConfigurables() {
        if (this.myChildren == null) {
            this.myChildren = new Configurable[]{new PublishOptionsConfigurable(this.myProject)};
        }
        if (this.myChildren == null) {
            DeploymentConfigurable.$$$reportNull$$$0(0);
        }
        return this.myChildren;
    }

    public static <E> Map<String, E> filterExistingServers(Map<String, E> elements, List<? extends SettingsGroupedDeployable> currentGroups) {
        HashMap<String, E> result = new HashMap<String, E>();
        for (SettingsGroupedDeployable settingsGroupedDeployable : currentGroups) {
            for (SettingsDeployable server : settingsGroupedDeployable.getDeployables()) {
                String id = server.getId();
                E e = elements.get(id);
                if (e == null) continue;
                result.put(id, e);
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurable", "getConfigurables"));
    }
}

