/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.GroupedServersComparer;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.AddServerDialog;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerCombo
extends ComboboxWithBrowseButton {
    private final boolean myRemoteServersOnly;
    private final int myEditServerTab;
    private final boolean myKeepNoneItem;
    private final boolean myShowGroups;
    @Nullable
    private Project myProject;
    @Nullable
    private Condition<? super WebServerConfig> myWebServerFilter = null;
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private static final Item ITEM_NONE = new Item("");

    public WebServerCombo(boolean remoteServersOnly, int editServerTab, boolean keepNoneItem) {
        this(remoteServersOnly, editServerTab, keepNoneItem, false);
    }

    public WebServerCombo(boolean remoteServersOnly, int editServerTab, boolean keepNoneItem, boolean showGroups) {
        super((JComboBox)new ComboBox());
        this.myRemoteServersOnly = remoteServersOnly;
        this.myEditServerTab = editServerTab;
        this.myKeepNoneItem = keepNoneItem;
        this.myShowGroups = showGroups;
        final ComboBox<Item> comboBox = this.getComboBox();
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Item>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Item> list, Item item, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.clear();
                if (item == null || item == ITEM_NONE) {
                    this.append(WDBundle.message("empty.server", new Object[0]));
                    this.setToolTipText(null);
                } else {
                    item.render(this, WebServerCombo.this.myProject, selected);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/plugins/webDeployment/ui/WebServerCombo$1", "customizeCellRenderer"));
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerCombo.this.updateTooltip();
            }
        });
        comboBox.addPopupMenuListener(new PopupMenuListener(){
            private Pair<WebServerGroupingWrap, WebServerConfig> mySelectedElement;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.mySelectedElement = WebServerCombo.this.getSelectedElement();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Pair<WebServerGroupingWrap, WebServerConfig> selectedElement = WebServerCombo.this.getSelectedElement();
                if (!Comparing.equal(this.mySelectedElement, selectedElement)) {
                    WebServerCombo.this.fireChanged();
                }
                this.mySelectedElement = null;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.mySelectedElement = null;
            }
        });
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebServerCombo.this.getSomeValidItem() == null) {
                    AddServerDialog d = new AddServerDialog((Component)((Object)WebServerCombo.this), WebServerCombo.this.myRemoteServersOnly, WebServerCombo.this.myProject);
                    if (d.showAndGet()) {
                        WebServerConfig newServer = d.getResult();
                        DeploymentConfigurable.show(newServer, true, WebServerCombo.this.myProject, 0);
                        WebServerConfig newSelection = GroupedServersConfigManager.getInstance(WebServerCombo.this.myProject).findServer(newServer.getId());
                        if (newSelection != null) {
                            WebServerCombo.this.selectServer(newSelection);
                        }
                        WebServerCombo.this.fireChanged();
                    }
                } else {
                    Item newSelection;
                    WebServerConfig currentSelection = (WebServerConfig)WebServerCombo.this.getSelectedElement().getSecond();
                    DeploymentConfigurable.show(currentSelection, false, WebServerCombo.this.myProject, WebServerCombo.this.myEditServerTab);
                    if (currentSelection == null && (newSelection = WebServerCombo.this.getSomeValidItem()) != null) {
                        comboBox.setSelectedItem((Object)newSelection);
                    }
                    WebServerCombo.this.fireChanged();
                }
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                WebServerCombo.this.resetToServerOrGroup(WebServerCombo.this.getSelected());
            }
        });
    }

    private void fireChanged() {
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    private void updateTooltip() {
        Item selectedItem = this.getSelectedItem();
        if (selectedItem != null && !selectedItem.isValid()) {
            this.getComboBox().setToolTipText(selectedItem.getErrorMessage());
        } else {
            this.getComboBox().setToolTipText(null);
        }
    }

    public void setWebServerFilter(@Nullable Condition<? super WebServerConfig> webServerFilter) {
        this.myWebServerFilter = webServerFilter;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    public void selectServer(WebServerConfig select) {
        if (this.getSelectedElement().second == select) {
            return;
        }
        for (int i = 0; i < this.getComboBox().getModel().getSize(); ++i) {
            Item item = (Item)this.getComboBox().getModel().getElementAt(i);
            if (item.server != select) continue;
            this.getComboBox().setSelectedItem((Object)item);
        }
    }

    public void resetToServerOrGroup(@Nullable ServerOrGroup selection) {
        if (this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.myKeepNoneItem) {
            items.add(ITEM_NONE);
        }
        Item select = null;
        ArrayList<WebServerGroupingWrap> wraps = new ArrayList<WebServerGroupingWrap>(GroupedServersConfigManager.getInstance(this.myProject).getGroupedServers());
        PublishConfig publishConfig = this.myProject == null ? null : PublishConfig.getInstance(this.myProject);
        GroupedServersComparer.sortWraps(wraps, publishConfig);
        Ref itemToAdd = new Ref();
        for (WebServerGroupingWrap wrap : wraps) {
            if (wrap.isSingleServer()) {
                WebServerConfig server = wrap.getAsSingleServer();
                select = this.addServerItem(selection, items, select, server, false, (Ref<Item>)itemToAdd);
                continue;
            }
            SmartList servers = new SmartList(wrap.getServers());
            if (this.myShowGroups) {
                Item item = new Item(wrap);
                if (selection != null && selection.hasGroup() && Objects.equals(selection.getGroupName(), wrap.getName())) {
                    select = item;
                }
                if (servers.isEmpty() && this.myWebServerFilter == null) {
                    items.add(item);
                } else {
                    itemToAdd.set((Object)item);
                }
            }
            GroupedServersComparer.sortServers((List<WebServerConfig>)servers, publishConfig);
            for (WebServerConfig server : servers) {
                select = this.addServerItem(selection, items, select, server, this.myShowGroups, (Ref<Item>)itemToAdd);
            }
            itemToAdd.set(null);
        }
        if (selection == null && this.myKeepNoneItem) {
            select = ITEM_NONE;
        }
        if (select == null && selection != null && selection.getServerName() != null) {
            select = new Item(selection.getServerName());
            items.add(select);
        }
        this.getComboBox().setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)select));
        this.updateTooltip();
    }

    private Item addServerItem(@Nullable ServerOrGroup selection, List<Item> items, Item select, WebServerConfig server, boolean isFromGroup, Ref<Item> itemToAdd) {
        if (!(this.myRemoteServersOnly && !server.needsTransfer() || this.myWebServerFilter != null && !this.myWebServerFilter.value((Object)server))) {
            if (!itemToAdd.isNull()) {
                items.add((Item)itemToAdd.get());
                itemToAdd.set(null);
            }
            Item item = new Item(server, true, isFromGroup);
            items.add(item);
            if (selection != null && StringUtil.equals((CharSequence)server.getId(), (CharSequence)selection.getServerId())) {
                select = item;
            }
        }
        return select;
    }

    @Nullable
    private Item getSelectedItem() {
        return (Item)this.getComboBox().getSelectedItem();
    }

    @Nullable
    public WebServerConfig getSelectedServer() {
        return (WebServerConfig)this.getSelectedElement().second;
    }

    @NotNull
    public Pair<WebServerGroupingWrap, WebServerConfig> getSelectedElement() {
        Item selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                WebServerCombo.$$$reportNull$$$0(0);
            }
            return pair;
        }
        if (selectedItem.group != null) {
            Pair pair = Pair.create((Object)selectedItem.group, null);
            if (pair == null) {
                WebServerCombo.$$$reportNull$$$0(1);
            }
            return pair;
        }
        if (selectedItem.server != null) {
            Pair pair = Pair.create(null, (Object)selectedItem.server);
            if (pair == null) {
                WebServerCombo.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            WebServerCombo.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @NotNull
    public ServerOrGroup getSelected() {
        ServerOrGroup serverOrGroup = new ServerOrGroup();
        Item item = this.getSelectedItem();
        if (item != null) {
            if (item.server != null) {
                serverOrGroup.setServer(item.server.getId(), item.server.getName());
            } else if (item.group != null) {
                serverOrGroup.setGroup(item.group.getName());
            }
        }
        ServerOrGroup serverOrGroup2 = serverOrGroup;
        if (serverOrGroup2 == null) {
            WebServerCombo.$$$reportNull$$$0(4);
        }
        return serverOrGroup2;
    }

    @Nullable
    public String getSelectedErrorMessage() {
        Item selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getErrorMessage() : null;
    }

    @Nullable
    private Item getSomeValidItem() {
        Item someItem = null;
        String defaultName = this.myProject == null ? null : PublishConfig.getInstance(this.myProject).getDefaultServerOrGroupName();
        for (int i = 0; i < this.getComboBox().getModel().getSize(); ++i) {
            Item item = (Item)this.getComboBox().getModel().getElementAt(i);
            if (defaultName == null && item.server != null) {
                return item;
            }
            if (item.server != null && Comparing.equal((String)defaultName, (String)item.server.getName()) || item.group != null && Comparing.equal((String)defaultName, (String)item.group.getName())) {
                return item;
            }
            someItem = item;
        }
        return someItem;
    }

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public ComboBox<Item> getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerCombo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Item {
        @Nullable
        private final WebServerGroupingWrap group;
        @Nullable
        private final WebServerConfig server;
        @Nullable
        private final String serverName;
        @Nullable
        private final String errorMessage;
        private final boolean isFromGroup;

        private Item(@Nullable WebServerGroupingWrap group) {
            this.group = group;
            this.server = null;
            this.serverName = null;
            this.errorMessage = null;
            this.isFromGroup = false;
        }

        private Item(@NotNull WebServerConfig server, boolean validateUrl, boolean isFromGroup) {
            if (server == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.server = server;
            this.serverName = null;
            this.errorMessage = validateUrl ? server.validateFast() : server.getFileTransferConfig().validateFast();
            this.group = null;
            this.isFromGroup = isFromGroup;
        }

        private Item(@NotNull String serverName) {
            if (serverName == null) {
                Item.$$$reportNull$$$0(1);
            }
            this.server = null;
            this.serverName = serverName;
            this.errorMessage = WDBundle.message("server.not.exists", serverName);
            this.group = null;
            this.isFromGroup = false;
        }

        @Nullable
        protected String getErrorMessage() {
            return this.errorMessage;
        }

        private void render(ColoredListCellRenderer wrapper, @Nullable Project project, boolean selected) {
            PublishConfig config;
            PublishConfig publishConfig = config = project == null ? null : PublishConfig.getInstance(project);
            if (this.group != null) {
                if (config != null && config.getDefaultServerOrGroupName() != null && config.getDefaultServerOrGroupName().equals(this.group.getName())) {
                    wrapper.append(this.group.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    wrapper.append(this.group.getName());
                }
                wrapper.setIcon(AllIcons.Webreferences.Server);
                if (!selected && config != null) {
                    for (WebServerConfig groupServer : this.group.getServers()) {
                        if (!config.isConfigured(groupServer, true)) continue;
                        wrapper.setBackground(UiConstants.MAPPED_BACKGROUND);
                        break;
                    }
                }
            } else {
                if (config != null && config.getDefaultServerOrGroupName() != null && config.getDefaultServerOrGroupName().equals(this.getName())) {
                    wrapper.append(this.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else {
                    wrapper.append(this.getName());
                }
                if (this.server == null) {
                    wrapper.setIcon(UIUtil.getBalloonWarningIcon());
                    wrapper.setToolTipText(this.getErrorMessage());
                } else {
                    String msg = this.getErrorMessage();
                    Icon icon = this.server.getIcon();
                    if (msg != null) {
                        icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
                    }
                    wrapper.setIcon(icon);
                    wrapper.setToolTipText(msg);
                }
                if (!selected && config != null && config.isConfigured(this.server, true)) {
                    wrapper.setBackground(UiConstants.MAPPED_BACKGROUND);
                }
            }
            JBInsets insets = this.isFromGroup ? JBUI.insets((int)1, (int)(2 + AllIcons.Webreferences.Server.getIconWidth()), (int)1, (int)2) : JBInsets.create((int)1, (int)2);
            wrapper.setIpad((Insets)insets);
        }

        public String toString() {
            return this.getName();
        }

        public boolean isValid() {
            return this.getErrorMessage() == null;
        }

        @NotNull
        public String getName() {
            if (this.group != null) {
                String string = this.group.getName();
                if (string == null) {
                    Item.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = StringUtil.notNullize((String)(this.server != null ? this.server.getName() : this.serverName));
            if (string == null) {
                Item.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerCombo$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerCombo$Item";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

