/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.ui.PermissionsEditor;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class PermissionsEditorForm
implements PermissionsEditor {
    public static final int INVALID_PERMISSIONS = -2;
    private JButton myOwnerButton;
    private JButton myGroupButton;
    private JButton myOthersButton;
    private JButton myReadButton;
    private JButton myWriteButton;
    private JButton myExecButton;
    private JCheckBox myROwner;
    private JCheckBox myRGroup;
    private JCheckBox myROthers;
    private JCheckBox myWOwner;
    private JCheckBox myWGroup;
    private JCheckBox myWOthers;
    private JCheckBox myXOwner;
    private JCheckBox myXGroup;
    private JCheckBox myXOthers;
    private JTextField myOctalField;
    private JPanel myContentPane;
    private JLabel myMessageLabel;
    private final Map<JCheckBox, Integer> myBoxes;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public PermissionsEditorForm() {
        this.$$$setupUI$$$();
        this.myBoxes = new HashMap<JCheckBox, Integer>();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.addCheckbox(this.myROwner, 256);
        this.addCheckbox(this.myWOwner, 128);
        this.addCheckbox(this.myXOwner, 64);
        this.addCheckbox(this.myRGroup, 32);
        this.addCheckbox(this.myWGroup, 16);
        this.addCheckbox(this.myXGroup, 8);
        this.addCheckbox(this.myROthers, 4);
        this.addCheckbox(this.myWOthers, 2);
        this.addCheckbox(this.myXOthers, 1);
        this.addChangeListeners(this.myOwnerButton, this.myROwner, this.myWOwner, this.myXOwner);
        this.addChangeListeners(this.myGroupButton, this.myRGroup, this.myWGroup, this.myXGroup);
        this.addChangeListeners(this.myOthersButton, this.myROthers, this.myWOthers, this.myXOthers);
        this.addChangeListeners(this.myReadButton, this.myROwner, this.myRGroup, this.myROthers);
        this.addChangeListeners(this.myWriteButton, this.myWOwner, this.myWGroup, this.myWOthers);
        this.addChangeListeners(this.myExecButton, this.myXOwner, this.myXGroup, this.myXOthers);
        this.myOctalField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PermissionsEditorForm.this.updateCheckboxes(PermissionsEditorForm.this.getPermissions());
                ((ChangeListener)PermissionsEditorForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/ui/PermissionsEditorForm$1", "textChanged"));
            }
        });
    }

    public void setPermissions(int permissions) {
        if (permissions == -2) {
            this.myOctalField.setText(null);
            this.updateCheckboxes(0);
        } else {
            this.myOctalField.setText(Util.toOctalString(permissions));
            this.updateCheckboxes(permissions);
        }
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
    }

    public int getPermissions() {
        try {
            int i = Integer.parseInt(this.myOctalField.getText(), 8);
            if (i >= 0 && i <= 511) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -2;
    }

    private void updateCheckboxes(int permissions) {
        for (Map.Entry<JCheckBox, Integer> entry : this.myBoxes.entrySet()) {
            entry.getKey().setSelected((entry.getValue() & permissions) != 0);
        }
    }

    @Override
    public JPanel getContentPane() {
        return this.myContentPane;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myOctalField;
    }

    private void addChangeListeners(JButton from, final JCheckBox ... to) {
        from.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value = !to[0].isSelected();
                for (JCheckBox box : to) {
                    box.setSelected(value);
                }
                PermissionsEditorForm.this.updatePermissionsFromCheckboxes();
            }
        });
    }

    @Override
    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private void addCheckbox(JCheckBox checkbox, int value) {
        this.myBoxes.put(checkbox, value);
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsEditorForm.this.updatePermissionsFromCheckboxes();
            }
        });
    }

    private void updatePermissionsFromCheckboxes() {
        int permissions = 0;
        for (Map.Entry<JCheckBox, Integer> entry : this.myBoxes.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            permissions |= entry.getValue().intValue();
        }
        this.myOctalField.setText(Util.toOctalString(permissions));
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
    }

    @Override
    public void showMessage(String text) {
        this.myMessageLabel.setText(text);
        this.myMessageLabel.setIcon(text != null ? UIUtil.getBalloonWarningIcon() : null);
    }

    public boolean isValid() {
        return this.getPermissions() != -2;
    }

    public void hideMessageLabel() {
        this.myMessageLabel.setVisible(false);
    }

    public void removeMnemonics() {
        PermissionsEditorForm.removeMnemonic(this.myReadButton);
        PermissionsEditorForm.removeMnemonic(this.myWriteButton);
        PermissionsEditorForm.removeMnemonic(this.myExecButton);
        PermissionsEditorForm.removeMnemonic(this.myOwnerButton);
        PermissionsEditorForm.removeMnemonic(this.myGroupButton);
        PermissionsEditorForm.removeMnemonic(this.myOthersButton);
    }

    private static void removeMnemonic(JButton button) {
        button.setMnemonic(27);
        button.setDisplayedMnemonicIndex(-1);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOwnerButton = jButton6 = new JButton();
        this.$$$loadButtonText$$$(jButton6, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.owner"));
        jPanel.add((Component)jButton6, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myGroupButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.group"));
        jPanel.add((Component)jButton5, new GridConstraints(2, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myOthersButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.others"));
        jPanel.add((Component)jButton4, new GridConstraints(3, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myROwner = jCheckBox9 = new JCheckBox();
        jCheckBox9.setIconTextGap(4);
        jCheckBox9.setMargin(new Insets(2, 2, 2, 3));
        jCheckBox9.setText("");
        jPanel.add((Component)jCheckBox9, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myRGroup = jCheckBox8 = new JCheckBox();
        jCheckBox8.setIconTextGap(4);
        jCheckBox8.setMargin(new Insets(2, 2, 2, 3));
        jCheckBox8.setText("");
        jPanel.add((Component)jCheckBox8, new GridConstraints(2, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myROthers = jCheckBox7 = new JCheckBox();
        jCheckBox7.setIconTextGap(4);
        jCheckBox7.setMargin(new Insets(2, 2, 2, 3));
        jCheckBox7.setText("");
        jPanel.add((Component)jCheckBox7, new GridConstraints(3, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myWOwner = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("");
        jPanel.add((Component)jCheckBox6, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myWGroup = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("");
        jPanel.add((Component)jCheckBox5, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myWOthers = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("");
        jPanel.add((Component)jCheckBox4, new GridConstraints(3, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myXOwner = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("");
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myXGroup = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myXOthers = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myReadButton = jButton3 = new JButton();
        jButton3.setMargin(new Insets(3, 0, 3, 0));
        this.$$$loadButtonText$$$(jButton3, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.read"));
        jPanel.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 3, 0, 0, new Dimension(26, -1), null, null));
        this.myWriteButton = jButton2 = new JButton();
        jButton2.setHorizontalTextPosition(0);
        jButton2.setMargin(new Insets(3, 0, 3, 0));
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.write"));
        jPanel.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 3, 0, 0, new Dimension(26, -1), null, null));
        this.myExecButton = jButton = new JButton();
        jButton.setHorizontalTextPosition(0);
        jButton.setMargin(new Insets(3, 0, 3, 0));
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.execute"));
        jPanel.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 3, 0, 0, new Dimension(26, -1), null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", PermissionsEditorForm.class).getString("permissions.octal"));
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myOctalField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(2);
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 3, 0, 1, 0, 0, null, new Dimension(25, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("-----");
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 5, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

