/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jcraft.jsch.JSch;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.LoggingSftpChannel;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.SftpUserInfo;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.config.sockets.DeploymentSocketUtils;
import com.jetbrains.plugins.webDeployment.connections.IdentityRepositoryFactoryAdapter;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystemConfigBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;
import org.apache.commons.vfs2.provider.ram.RamFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="webServer")
public class WebServerConfig
implements Cloneable,
Mappable {
    private static final Logger LOG = Logger.getInstance(WebServerConfig.class);
    private static final Logger FTP_LOG = Logger.getInstance((String)"#com.jetbrains.plugins.webDeployment.ftp");
    private static final Logger FTPS_LOG = Logger.getInstance((String)"#com.jetbrains.plugins.webDeployment.ftps");
    @NonNls
    public static final String DEFAULT_URL = "http://";
    private String myId;
    private String myName;
    private String myUrl = "http://";
    private boolean isProjectLevel = false;
    @NotNull
    private FileTransferConfig myFileTransferConfig = new FileTransferConfig();

    private static int getFtpTimeoutMs() {
        return Integer.getInteger("com.jetbrains.plugins.webDeployment.ftp.timeout", 10000);
    }

    private static int getFtpDataTimeoutMs() {
        return Integer.getInteger("com.jetbrains.plugins.webDeployment.ftp.data_timeout", WebServerConfig.getFtpTimeoutMs());
    }

    private static int getSftpTimeoutMs() {
        return Integer.getInteger("com.jetbrains.plugins.webDeployment.sftp.timeout", 10000);
    }

    private static int getFtpsTimeoutMs() {
        return Integer.getInteger("com.jetbrains.plugins.webDeployment.ftps.timeout", 10000);
    }

    private static int getFtpsDataTimeoutMs() {
        return Integer.getInteger("com.jetbrains.plugins.webDeployment.ftps.data_timeout", 10000);
    }

    public WebServerConfig() {
        this(null);
    }

    public WebServerConfig(String id) {
        this.setId(id);
    }

    public void initializeNewCreatedServer(boolean globalServersOnly) {
        this.myFileTransferConfig.getAdvancedOptions().setPassiveMode(true);
        this.myFileTransferConfig.getAdvancedOptions().setDataChannelProtectionLevel(AdvancedOptionsConfig.DataChannelProtectionLevel.Private);
        this.myFileTransferConfig.getAdvancedOptions().setShareSslContext(true);
        this.setIsProjectLevel(!globalServersOnly);
    }

    @Override
    @Attribute(value="id")
    public String getId() {
        return this.myId;
    }

    public void setId(String id) {
        this.myId = id;
    }

    @Attribute(value="name")
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.getAccessType().getIcon();
        if (icon == null) {
            WebServerConfig.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @Attribute(value="url")
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(@NonNls String url) {
        this.myUrl = url;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.isProjectLevel = isProjectLevel;
    }

    @Property(surroundWithTag=false)
    @NotNull
    public FileTransferConfig getFileTransferConfig() {
        FileTransferConfig fileTransferConfig = this.myFileTransferConfig;
        if (fileTransferConfig == null) {
            WebServerConfig.$$$reportNull$$$0(1);
        }
        return fileTransferConfig;
    }

    public void setFileTransferConfig(@NotNull FileTransferConfig fileTransferConfig) {
        if (fileTransferConfig == null) {
            WebServerConfig.$$$reportNull$$$0(2);
        }
        this.myFileTransferConfig = fileTransferConfig;
    }

    @NotNull
    public WebServerConfig clone() {
        WebServerConfig webServerConfig;
        try {
            WebServerConfig clone = (WebServerConfig)super.clone();
            clone.setFileTransferConfig(this.myFileTransferConfig.clone());
            webServerConfig = clone;
        }
        catch (CloneNotSupportedException e) {
            if (null == null) {
                WebServerConfig.$$$reportNull$$$0(4);
            }
            return null;
        }
        if (webServerConfig == null) {
            WebServerConfig.$$$reportNull$$$0(3);
        }
        return webServerConfig;
    }

    @NotNull
    public WebServerConfig cloneWithNewIdAndCredentials() {
        WebServerConfig clone = this.clone();
        clone.setId(WebServerConfig.getNextId());
        WebDeploymentCredentialHelper.copyServerCredentials(this, clone);
        WebServerConfig webServerConfig = clone;
        if (webServerConfig == null) {
            WebServerConfig.$$$reportNull$$$0(5);
        }
        return webServerConfig;
    }

    public boolean isBasedOnServer(WebServerConfig server) {
        return this.getId() != null && this.getId().equals(server.getId());
    }

    public int getMaxConnections() {
        return this.getFileTransferConfig().getAdvancedOptions().getMaxConnections();
    }

    public AdvancedOptionsConfig.AccurateTimestamps getAccurateTimestamps() {
        return this.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps();
    }

    @Nullable
    public String validateSlow(long timeout) throws TimeoutException {
        String error = this.myFileTransferConfig.validateSlow(timeout, true);
        if (error != null) {
            return error;
        }
        return this.validateUrl();
    }

    @Nullable
    public String validateFast() {
        String error = this.validateFastInternal();
        return error == null ? this.validateUrl() : error;
    }

    @Nullable
    public String validateFastInternal() {
        return this.myFileTransferConfig.validateFast();
    }

    public String validateFastInternal(boolean checkRootFolder) {
        return this.myFileTransferConfig.validateFast(checkRootFolder);
    }

    public String validateInternalSlow(long infinite, boolean checkRootFolder) throws TimeoutException {
        return this.myFileTransferConfig.validateSlow(infinite, checkRootFolder);
    }

    @NotNull
    public FileSystemOptions getConnectionOptions(@NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin originOption, @Nullable EventDispatcher<ForceDisconnectListener> disconnectTrigger, @Nullable ProgressIndicator pi) {
        FileSystemOptions options;
        block17: {
            if (connectionOwner == null) {
                WebServerConfig.$$$reportNull$$$0(6);
            }
            if (title == null) {
                WebServerConfig.$$$reportNull$$$0(7);
            }
            FileTransferConfig ftc = this.getFileTransferConfig();
            options = new FileSystemOptions();
            if (!ftc.getAccessType().isProtocolBased()) {
                FileSystemOptions fileSystemOptions = options;
                if (fileSystemOptions == null) {
                    WebServerConfig.$$$reportNull$$$0(8);
                }
                return fileSystemOptions;
            }
            RamFileSystemConfigBuilder.getInstance().setMaxSize(options, (long)StringUtil.notNullize((String)connectionOwner.getHash()).hashCode());
            try {
                String controlEncoding = StringUtil.nullize((String)ftc.getAdvancedOptions().getControlEncoding(), (boolean)true);
                if (ftc.getAccessType() == AccessType.FTP) {
                    int ftpTimeoutMs = WebServerConfig.getFtpTimeoutMs();
                    FtpFileSystemConfigBuilder.getInstance().setSoTimeout(options, Integer.valueOf(ftpTimeoutMs));
                    FtpFileSystemConfigBuilder.getInstance().setConnectTimeout(options, Integer.valueOf(ftpTimeoutMs));
                    FtpFileSystemConfigBuilder.getInstance().setDataTimeout(options, Integer.valueOf(WebServerConfig.getFtpDataTimeoutMs()));
                    FtpFileSystemConfigBuilder.getInstance().setShowHiddenFiles(options, ftc.getAdvancedOptions().isShowHiddenFiles());
                    FtpFileSystemConfigBuilder.getInstance().setPassiveMode(options, ftc.getAdvancedOptions().isPassiveMode());
                    FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, originOption == FileTransferConfig.Origin.Unchanged);
                    if (originOption == FileTransferConfig.Origin.Default) {
                        FtpFileSystemConfigBuilder.getInstance().setHomeFolderOverride(options, ftc.getRootFolder());
                    }
                    FtpFileSystemConfigBuilder.getInstance().setEntryParserFactory(options, (org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory)new FTPFileEntryParserFactory(FTP_LOG));
                    FtpFileSystemConfigBuilder.getInstance().setProtocolCommandListener(options, WebServerConfig.createProtocolCommandListener(FTP_LOG));
                    FtpFileSystemConfigBuilder.getInstance().setCompatibleMode(options, ftc.getAdvancedOptions().isCompatibilityMode());
                    FtpFileSystemConfigBuilder.getInstance().setControlEncoding(options, controlEncoding);
                    DeploymentSocketUtils.patchFtpSocketsIfNeeded(options, ftc, disconnectTrigger);
                    FtpFileSystemConfigBuilder.getInstance().setForceListCommand(options, ftc.getAdvancedOptions().isForceListCommand());
                    int keepAliveTimeout = ftc.getAdvancedOptions().getKeepAliveTimeout();
                    if (keepAliveTimeout > 0) {
                        FtpFileSystemConfigBuilder.getInstance().setKeepAliveTimeout(options, Integer.valueOf(keepAliveTimeout));
                    }
                    FtpFileSystemConfigBuilder.getInstance().setKeepAliveCommand(options, ftc.getAdvancedOptions().getKeepAliveFtpCommand());
                    break block17;
                }
                if (ftc.getAccessType() == AccessType.SFTP) {
                    PlatformSftpFileSystemConfigBuilder.getInstance().setAuthType(options, ftc.getAuthType());
                    PlatformSftpFileSystemConfigBuilder.getInstance().setTimeout(options, WebServerConfig.getSftpTimeoutMs());
                    GroupedServersConfigManager.getInstance(null).getSftpAdvancedOptions().applyTo(options);
                    WebServerConfig.ensureExists(new File(SystemProperties.getUserHome(), ".ssh/known_hosts"));
                    PlatformSftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, originOption == FileTransferConfig.Origin.Unchanged);
                    if (originOption == FileTransferConfig.Origin.Default) {
                        PlatformSftpFileSystemConfigBuilder.getInstance().setHomeFolderOverride(options, ftc.getRootFolder());
                    }
                    if (LoggingSftpChannel.isEnabled()) {
                        PlatformSftpFileSystemConfigBuilder.getInstance().setSftpChannelDecorator(options, LoggingSftpChannel.class);
                    }
                    PlatformSftpFileSystemConfigBuilder.getInstance().setControlEncoding(options, controlEncoding);
                    DeploymentSocketUtils.patchSftpSockets(options, ftc, disconnectTrigger);
                    PlatformSftpFileSystemConfigBuilder.getInstance().setPreferredAuthentications(options, "publickey,keyboard-interactive,password");
                    int keepAliveTimeout = ftc.getAdvancedOptions().getKeepAliveTimeout();
                    if (keepAliveTimeout > 0) {
                        PlatformSftpFileSystemConfigBuilder.getInstance().setKeepAliveTimeout(options, keepAliveTimeout);
                        PlatformSftpFileSystemConfigBuilder.getInstance().setKeepAliveMaxCount(options, 1000);
                    }
                    JSch.setConfig((String)"MaxAuthTries", (String)"1");
                    break block17;
                }
                if (ftc.getAccessType() == AccessType.FTPS) {
                    FtpsFileSystemConfigBuilder.getInstance().setSoTimeout(options, Integer.valueOf(WebServerConfig.getFtpsTimeoutMs()));
                    FtpsFileSystemConfigBuilder.getInstance().setConnectTimeout(options, Integer.valueOf(WebServerConfig.getFtpsTimeoutMs()));
                    FtpsFileSystemConfigBuilder.getInstance().setDataTimeout(options, Integer.valueOf(WebServerConfig.getFtpsDataTimeoutMs()));
                    FtpsFileSystemConfigBuilder.getInstance().setShowHiddenFiles(options, ftc.getAdvancedOptions().isShowHiddenFiles());
                    FtpsFileSystemConfigBuilder.getInstance().setPassiveMode(options, ftc.getAdvancedOptions().isPassiveMode());
                    FtpsFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, originOption == FileTransferConfig.Origin.Unchanged);
                    if (originOption == FileTransferConfig.Origin.Default) {
                        FtpsFileSystemConfigBuilder.getInstance().setHomeFolderOverride(options, ftc.getRootFolder());
                    }
                    FtpsFileSystemConfigBuilder.getInstance().setFtpsMode(options, ftc.isFtpsExplicit() ? FtpsMode.EXPLICIT : FtpsMode.IMPLICIT);
                    FtpsFileSystemConfigBuilder.getInstance().setShareSslContext(options, ftc.getAdvancedOptions().isShareSslContext());
                    FtpsFileSystemConfigBuilder.getInstance().setEntryParserFactory(options, (org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory)new FTPFileEntryParserFactory(FTPS_LOG));
                    FtpFileSystemConfigBuilder.getInstance().setProtocolCommandListener(options, WebServerConfig.createProtocolCommandListener(FTPS_LOG));
                    FtpsFileSystemConfigBuilder.getInstance().setControlEncoding(options, controlEncoding);
                    AdvancedOptionsConfig.DataChannelProtectionLevel level = ftc.getAdvancedOptions().getDataChannelProtectionLevel();
                    FtpsFileSystemConfigBuilder.getInstance().setDataChannelProtectionLevel(options, level.getValue());
                    DeploymentSocketUtils.patchFtpsSocketsIfNeeded(options, ftc, disconnectTrigger);
                    FtpFileSystemConfigBuilder.getInstance().setForceListCommand(options, ftc.getAdvancedOptions().isForceListCommand());
                    int keepAliveTimeout = ftc.getAdvancedOptions().getKeepAliveTimeout();
                    if (keepAliveTimeout > 0) {
                        FtpFileSystemConfigBuilder.getInstance().setKeepAliveTimeout(options, Integer.valueOf(keepAliveTimeout));
                    }
                    FtpFileSystemConfigBuilder.getInstance().setKeepAliveCommand(options, ftc.getAdvancedOptions().getKeepAliveFtpCommand());
                    break block17;
                }
                throw new IllegalStateException("Unknown access type " + (Object)((Object)ftc.getAccessType()));
            }
            catch (FileSystemException e) {
                LOG.error((Throwable)e);
            }
        }
        WebServerConfig.checkProperEqualsAndHash(options);
        FileSystemOptions fileSystemOptions = options;
        if (fileSystemOptions == null) {
            WebServerConfig.$$$reportNull$$$0(9);
        }
        return fileSystemOptions;
    }

    @Nullable
    private static ProtocolCommandListener createProtocolCommandListener(Logger log) {
        if (!log.isDebugEnabled()) {
            return null;
        }
        return new MyPrintCommandListener(log);
    }

    public String getRootUri() {
        return this.getFileTransferConfig().getRootUri();
    }

    static void checkProperEqualsAndHash(FileSystemOptions options) {
        try {
            Field optionsField = FileSystemOptions.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            Object optionsFieldValue = optionsField.get(options);
            Map optionsMap = (Map)optionsFieldValue;
            for (Object value : optionsMap.values()) {
                WebServerConfig.checkProperEqualsAndHash(value);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkProperEqualsAndHash(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof StaticUserAuthenticator || value instanceof SftpUserInfo || value instanceof AuthType || value instanceof FTPFileEntryParserFactory || value instanceof Class || value instanceof File || value instanceof IdentityInfo || value instanceof IdentityInfo[] || value instanceof FtpsMode || value instanceof FtpsDataChannelProtectionLevel || value instanceof JBFtpKeepAliveCommand || value instanceof IdentityRepositoryFactoryAdapter || value instanceof EventDispatcher || value instanceof MyPrintCommandListener) {
            return;
        }
        if (DeploymentSocketUtils.hasProperEqualsAndHash(value)) {
            return;
        }
        throw new IllegalStateException("Unexpected value " + value.getClass());
    }

    private static void ensureExists(File file) {
        try {
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                LOG.warn("failed to create folder " + file.getParent());
            }
            if (!file.isFile() && !file.createNewFile()) {
                LOG.warn("failed to create file " + file.getPath());
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        AccessType accessType = this.getFileTransferConfig().getAccessType();
        if (accessType == null) {
            WebServerConfig.$$$reportNull$$$0(10);
        }
        return accessType;
    }

    @Override
    @Nullable
    public String getMountedFolder() {
        return this.getFileTransferConfig().getMountedFolder();
    }

    @Override
    public String getFullPath(String deployPath) {
        if (this.getAccessType().isProtocolBased()) {
            return DeploymentPathMapping.ensureRelative(deployPath);
        }
        return DeploymentPathUtils.join(this.getFileTransferConfig().getMountedFolder(), deployPath);
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return true;
        }
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean needsTransfer() {
        return PublishUtils.needsTransfer(this.getFileTransferConfig().getAccessType());
    }

    @Override
    @Nullable
    public String validateUrl() {
        return PublishUtils.validateUrl(this.myUrl);
    }

    @Nullable
    public String getNonBlockingWarnings() {
        return this.getFileTransferConfig().getNonBlockingWarnings();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebServerConfig that = (WebServerConfig)o;
        if (!Objects.equals(this.myId, that.myId)) {
            return false;
        }
        if (!this.myFileTransferConfig.equals(that.myFileTransferConfig)) {
            return false;
        }
        if (!Objects.equals(this.myName, that.myName)) {
            return false;
        }
        if (!Objects.equals(this.myUrl, that.myUrl)) {
            return false;
        }
        return this.isProjectLevel == that.isProjectLevel;
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myUrl != null ? this.myUrl.hashCode() : 0);
        result = 31 * result + this.myFileTransferConfig.hashCode();
        result = 31 * result + (this.myId != null ? this.myId.hashCode() : 0);
        result = 31 * result + (this.isProjectLevel ? 1 : 0);
        return result;
    }

    @Override
    public String getPresentablePath(@NotNull RemotePath path) {
        if (path == null) {
            WebServerConfig.$$$reportNull$$$0(11);
        }
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return DeploymentPathUtils.join(this.getFileTransferConfig().getRootFolder(), path.path);
        }
        return path.path;
    }

    @Override
    public String getPresentablePath(FileName fileName) {
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return DeploymentPathUtils.join(this.getFileTransferConfig().getRootFolder(), fileName.getPath());
        }
        return DeploymentPathUtils.getLocalPath(fileName);
    }

    @Override
    public RemotePath getRootPath() {
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return new RemotePath("/");
        }
        return new RemotePath(FileUtil.toSystemDependentName((String)this.getFileTransferConfig().getMountedFolder()));
    }

    public boolean isUsedInProject(Project project, PublishConfig publishConfig, boolean deployPathOnly) {
        List<DeploymentPathMapping> mappings = publishConfig.getPathMappings(this.getId());
        AccessType accessType = this.getFileTransferConfig().getAccessType();
        for (DeploymentPathMapping mapping : mappings) {
            if (!mapping.isLocalPathValid() || !mapping.isDeployPathValid(accessType.isProtocolBased()) && (deployPathOnly || !mapping.isWebPathValid())) continue;
            return true;
        }
        return false;
    }

    public void loadDataFromSshConfigById(@Nullable Project project) {
        FileTransferConfig config = this.getFileTransferConfig();
        PresentableId presentableId = config.getSshPresentableId();
        if (this.getAccessType() == AccessType.SFTP && presentableId != null) {
            SshConfig sshConfig = SshConfigManager.getInstance((Project)project).findConfigById(presentableId.getId());
            if (sshConfig != null) {
                config.setSshConfig(sshConfig);
            } else if (presentableId.getName() != null) {
                config.setSshConfig(presentableId, null);
            }
        }
    }

    public void loadDataFromSshConfigByInitialName(@NotNull SshConfigManager manager) {
        FileTransferConfig config;
        PresentableId id;
        if (manager == null) {
            WebServerConfig.$$$reportNull$$$0(12);
        }
        if ((id = (config = this.getFileTransferConfig()).getSshPresentableId()) != null && id.getName() != null) {
            config.setSshConfig(id, manager.getConfigFromInitialMappingNameToId(id.getName()));
        }
    }

    public void loadDataFromSshConfig(@NotNull SshConfigManager manager) {
        if (manager == null) {
            WebServerConfig.$$$reportNull$$$0(13);
        }
        if (this.getAccessType() != AccessType.SFTP) {
            return;
        }
        PresentableId id = this.myFileTransferConfig.getSshPresentableId();
        if (id == null || !id.hasId()) {
            return;
        }
        SshUiData sshConfig = manager.findCurrentDataById(id.getId());
        this.myFileTransferConfig.setSshConfig(id, sshConfig == null ? null : sshConfig.getConfig());
    }

    @Nullable
    public SshConfig findSshConfig(@Nullable Project project) {
        if (this.getAccessType() != AccessType.SFTP) {
            return null;
        }
        FileTransferConfig config = this.getFileTransferConfig();
        PresentableId presentableId = config.getSshPresentableId();
        if (presentableId == null) {
            return null;
        }
        return SshConfigManager.getInstance((Project)project).findConfig(presentableId);
    }

    @Nullable
    public SshUiData getOrCreateSshUiData(@Nullable Project project) {
        if (!this.getFileTransferConfig().isConfiguredWithSshConfig()) {
            return null;
        }
        SshConfig config = this.findSshConfig(project);
        if (config == null) {
            return null;
        }
        return new SshUiData(config, true);
    }

    public static String getNextId() {
        return UUID.randomUUID().toString();
    }

    private static String getNonDuplicatingName(String existingServerName, Collection<String> otherNames) {
        if (StringUtil.isEmptyOrSpaces((String)existingServerName)) {
            existingServerName = WDBundle.message("unnamed", new Object[0]);
        }
        if (otherNames.contains(existingServerName)) {
            int i = 1;
            String newName = existingServerName + " (" + i + ")";
            while (otherNames.contains(newName)) {
                newName = existingServerName + " (" + ++i + ")";
            }
            return newName;
        }
        return existingServerName;
    }

    public static void fixDuplicatingNames(List<? extends WebServerGroupingWrap> wraps) {
        ArrayList<String> names = new ArrayList<String>(wraps.size());
        for (WebServerGroupingWrap webServerGroupingWrap : wraps) {
            if (webServerGroupingWrap.isSingleServer()) {
                WebServerConfig.fixName(webServerGroupingWrap.getAsSingleServer(), names);
                continue;
            }
            String name = webServerGroupingWrap.getName();
            String newName = WebServerConfig.getNonDuplicatingName(name, names);
            webServerGroupingWrap.setName(newName);
            names.add(newName);
            for (WebServerConfig server : webServerGroupingWrap.getServers()) {
                WebServerConfig.fixName(server, names);
            }
        }
    }

    private static void fixName(WebServerConfig server, List<String> names) {
        String name = server.getName();
        String newName = WebServerConfig.getNonDuplicatingName(name, names);
        server.setName(newName);
        names.add(newName);
    }

    @NonNls
    public String toString() {
        return "WebServerConfig{myName='" + this.myName + '\'' + ", myId='" + this.myId + '\'' + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServerConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTransferConfig";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTransferConfig";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServerConfig";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithNewIdAndCredentials";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionOptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setFileTransferConfig";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionOptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadDataFromSshConfigByInitialName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadDataFromSshConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FTPFileEntryParserFactory
    extends DefaultFTPFileEntryParserFactory {
        private final boolean myLoggingEnabled;
        private final Logger myLogger;

        private FTPFileEntryParserFactory(Logger logger) {
            this.myLogger = logger;
            this.myLoggingEnabled = logger.isDebugEnabled();
        }

        public FTPFileEntryParser createFileEntryParser(@NonNls String key) {
            FTPFileEntryParser parser;
            try {
                parser = super.createFileEntryParser(key);
            }
            catch (RuntimeException ex) {
                if (key.startsWith("WIN32")) {
                    LOG.info("Failed to get parser for key " + key);
                    parser = super.createFileEntryParser("WINDOWS");
                }
                throw ex;
            }
            if (this.myLoggingEnabled) {
                final FTPFileEntryParser finalParser = parser;
                return new FTPFileEntryParser(){

                    public FTPFile parseFTPEntry(String listEntry) {
                        return finalParser.parseFTPEntry(listEntry);
                    }

                    public String readNextEntry(BufferedReader reader) throws IOException {
                        String line = finalParser.readNextEntry(reader);
                        myLogger.debug(line);
                        return line;
                    }

                    public List<String> preParse(List<String> original) {
                        return finalParser.preParse(original);
                    }
                };
            }
            return parser;
        }

        public boolean equals(Object obj) {
            return obj instanceof FTPFileEntryParserFactory;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class RemotePath {
        public final String path;

        public RemotePath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemotePath that = (RemotePath)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return this.path != null ? this.path.hashCode() : 0;
        }

        public String toString() {
            return this.path;
        }
    }

    private static class MyPrintCommandListener
    extends PrintCommandListener {
        private final Logger myLog;

        private MyPrintCommandListener(final Logger log) {
            super(new PrintWriter(new StringWriter(1024){

                @Override
                public void flush() {
                    StringBuffer buffer = this.getBuffer();
                    String message = buffer.toString();
                    if (message.toUpperCase(Locale.ENGLISH).startsWith("PASS ") && message.length() > 5) {
                        message = "PASS ***";
                    }
                    message = StringUtil.trimEnd((String)message, (String)"\r\n");
                    log.debug(message);
                    buffer.setLength(0);
                }
            }));
            this.myLog = log;
        }

        public int hashCode() {
            return this.myLog.hashCode();
        }

        public boolean equals(Object obj) {
            return obj.getClass() == MyPrintCommandListener.class && this.myLog == ((MyPrintCommandListener)((Object)obj)).myLog;
        }
    }
}

