/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.ServerBaseDeployable;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerPasswordSafeDeployable
extends ServerBaseDeployable {
    private static final Logger LOG = Logger.getInstance(ServerBaseDeployable.class);
    private SshUiData mySshUiData;

    public ServerPasswordSafeDeployable(@NotNull WebServerConfig server, @Nullable SshUiData sshUiData) {
        if (server == null) {
            ServerPasswordSafeDeployable.$$$reportNull$$$0(0);
        }
        super(server, sshUiData == null ? null : sshUiData.getConfig());
        this.mySshUiData = sshUiData;
    }

    @Nullable
    protected SshUiData getSshUiData() {
        return this.mySshUiData;
    }

    public void refreshCredentials() {
        if (this.mySshUiData != null) {
            this.mySshUiData.reloadAuthDataFromPasswordSafe();
        }
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        if (this.mySshUiData != null) {
            return (Credentials)this.mySshUiData.getCredentialsAndMemoryOnly().first;
        }
        return WebDeploymentCredentialHelper.getCredentials(this.myServer, false);
    }

    @Override
    public void setCredentials(Credentials credentials, boolean memoryOnly, boolean isApplyCredentialsToPasswordSafe, boolean notifyGlobalUpdate) {
        LOG.assertTrue(isApplyCredentialsToPasswordSafe);
        if (this.mySshUiData != null) {
            this.mySshUiData.setCredentials(credentials, !memoryOnly, true);
        } else {
            WebDeploymentCredentialHelper.saveCredentials(this.myServer, memoryOnly, credentials);
        }
        if (notifyGlobalUpdate) {
            ApplicationManager.getApplication().invokeLater(() -> ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged());
        }
    }

    @Override
    public boolean isPassMemoryOnly() {
        if (this.mySshUiData != null) {
            switch (this.mySshUiData.getAuthType()) {
                case PASSWORD: {
                    return !this.mySshUiData.isStorePassword();
                }
                case KEY_PAIR: {
                    return !this.mySshUiData.isStorePassphrase();
                }
            }
            return true;
        }
        return (Boolean)WebDeploymentCredentialHelper.getCredentialsAndMemoryOnlyStatus(this.myServer, false).getSecond();
    }

    @Override
    @NotNull
    public Deployable copyToImmutable() {
        ServerDeployableWithTempCredentials clone = new ServerDeployableWithTempCredentials(this.myServer.clone(), this.mySshUiData == null ? null : this.mySshUiData.clone());
        Credentials credentials = this.getCredentials();
        clone.setCredentials(credentials, this.isPassMemoryOnly(), false, false);
        ServerDeployableWithTempCredentials serverDeployableWithTempCredentials = clone;
        if (serverDeployableWithTempCredentials == null) {
            ServerPasswordSafeDeployable.$$$reportNull$$$0(1);
        }
        return serverDeployableWithTempCredentials;
    }

    @Override
    @NotNull
    public ServerPasswordSafeDeployable clone() {
        ServerPasswordSafeDeployable clone = (ServerPasswordSafeDeployable)super.clone();
        if (this.mySshUiData != null) {
            clone.mySshUiData = this.mySshUiData.clone();
        }
        ServerPasswordSafeDeployable serverPasswordSafeDeployable = clone;
        if (serverPasswordSafeDeployable == null) {
            ServerPasswordSafeDeployable.$$$reportNull$$$0(2);
        }
        return serverPasswordSafeDeployable;
    }

    @Override
    public String toString() {
        return "ServerPasswordSafeDeployable{myServer=" + this.myServer + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/ServerPasswordSafeDeployable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/ServerPasswordSafeDeployable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToImmutable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

