/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.apache.commons.vfs2.FileName;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@Tag(value="excludedPath")
public class ExcludedPath
implements Cloneable {
    @NonNls
    public static final String EXCLUDED_PATH_TAG = "excludedPath";
    @NonNls
    public static final String PATH_ATTRIBUTE = "path";
    @NonNls
    public static final String LOCAL_ATTRIBUTE = "local";
    private String myPath;
    private boolean isLocal;

    public ExcludedPath() {
    }

    public ExcludedPath(String path, boolean local) {
        this.myPath = path;
        this.isLocal = local;
    }

    @Transient
    public String getPath() {
        return this.myPath;
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    @Attribute(value="path")
    public String getSerializedPath() {
        if (this.isLocal && this.myPath != null) {
            return FileUtil.toSystemIndependentName((String)this.myPath);
        }
        return this.myPath;
    }

    public void setSerializedPath(String path) {
        this.setPath(path);
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    @Attribute(value="local")
    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isParentForLocalPath(String localPath) {
        assert (this.isLocal);
        if (StringUtil.isEmpty((String)this.myPath) || StringUtil.isEmpty((String)localPath)) {
            return false;
        }
        String remainder = DeploymentPathUtils.getPathRemainder(this.myPath, localPath, SystemInfo.isFileSystemCaseSensitive);
        return remainder != null;
    }

    public boolean isParentForRemotePath(FileName remotePath, boolean equal, Mappable mappable) {
        assert (!this.isLocal);
        if (StringUtil.isEmpty((String)this.myPath)) {
            return false;
        }
        String remainder = DeploymentPathMapping.getPathRemainderForRemotePath(remotePath, mappable, this.myPath);
        return remainder != null && (!equal || remainder.length() == 0);
    }

    public boolean isParentForRemotePath(WebServerConfig.RemotePath remotePath, Mappable mappable) {
        assert (!this.isLocal);
        if (StringUtil.isEmpty((String)this.myPath)) {
            return false;
        }
        String remainder = DeploymentPathMapping.getPathRemainderForRemotePath(remotePath, mappable, this.myPath);
        return remainder != null;
    }

    public boolean isParent(ExcludedPath child, Mappable mappable) {
        if (this.isLocal() != child.isLocal()) {
            return false;
        }
        if (this.isLocal()) {
            return this.isParentForLocalPath(child.getPath());
        }
        return this.isParentForRemotePath(new WebServerConfig.RemotePath(child.getPath()), mappable);
    }

    @Nullable
    public ExcludedPath clone() {
        try {
            return (ExcludedPath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExcludedPath that = (ExcludedPath)o;
        if (this.isLocal != that.isLocal) {
            return false;
        }
        return !(this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null);
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.isLocal ? 1 : 0);
        return result;
    }
}

