/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.AddServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseScenarioStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.DeploymentFileChooserDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FileChooserStep
extends BaseStep {
    public static final ActionTypeDescription.Local[] LOCAL_ACTION_TYPE_DESCRIPTIONS = new ActionTypeDescription.Local[]{ActionTypeDescription.LOCAL_TEST_ROOTS_ACTION_DESCRIPTION, ActionTypeDescription.LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION, ActionTypeDescription.LOCAL_RESOURCE_ROOTS_ACTION_DESCRIPTION};
    public static final Object ID_NO_SERVER = Pair.create(FileChooserStep.class, (Object)((Object)CreateProjectModel.Scenario.NoServer));
    public static final Object ID_LOCAL_SERVER = Pair.create(FileChooserStep.class, (Object)((Object)CreateProjectModel.Scenario.LocalServer));
    private final DeploymentFileChooserDialog myDialog;
    private final CreateProjectModel.Scenario myScenario;
    private JPanel myFormPane;
    private JPanel myContentPane;
    private final Object myID;

    public FileChooserStep(CreateProjectModel model, CreateProjectModel.Scenario scenario) {
        super(WDBundle.message("create.web.project.choose.directory.step.title", new Object[0]), model);
        this.$$$setupUI$$$();
        this.myID = scenario == CreateProjectModel.Scenario.NoServer ? ID_NO_SERVER : ID_LOCAL_SERVER;
        this.myScenario = scenario;
        FileChooserDescriptor d = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myDialog = new DeploymentFileChooserDialog(d, null);
        JPanel northSection = new JPanel(new BorderLayout());
        this.myFormPane.add((Component)northSection, "North");
        JComponent titlePane = this.myDialog.getTitlePane();
        if (titlePane != null) {
            northSection.add((Component)titlePane, "Center");
        }
        JPanel centerSection = new JPanel(new BorderLayout());
        this.myFormPane.add((Component)centerSection, "Center");
        centerSection.add((Component)this.myDialog.createCenterPanel(), "Center");
        this.myDialog.addListener(new DeploymentFileChooserDialog.StateChangeListener(){

            @Override
            public void stateChanged() {
                FileChooserStep.this.fireStateChanged();
            }
        });
    }

    @NotNull
    public Object getStepId() {
        Object object = this.myID;
        if (object == null) {
            FileChooserStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    public Object getNextStepId() {
        if (this.myScenario == CreateProjectModel.Scenario.NoServer) {
            return null;
        }
        return CreateProjectModel.getServers(this.myScenario).isEmpty() ? AddServerStep.ID : ChooseServerStep.ID;
    }

    public Object getPreviousStepId() {
        return ChooseScenarioStep.ID;
    }

    public boolean isComplete() {
        if (this.myScenario != this.myModel.scenario) {
            return true;
        }
        return this.myDialog.getProjectRoot() != null;
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        if (commitType == AbstractWizardStepEx.CommitType.Prev) {
            return;
        }
        this.myModel.localPath = this.myDialog.getProjectRoot().getPresentableUrl();
        this.processActionPaths();
    }

    private void processActionPaths() {
        MultiMap<String, VirtualFile> actionPaths = this.myDialog.getActionPaths();
        this.myModel.getLocalActionPaths().clear();
        this.myModel.getLocalActionPaths().putAllValues(actionPaths);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDialog.getPreferredFocusedComponent();
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.myDialog.createCenterPanel();
    }

    public void dispose() {
        this.myDialog.close(0);
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.from.existing.files.choose.project.directory";
    }

    @Override
    @Nls
    @NotNull
    protected String getSummaryText() {
        String string = WDBundle.message("create.web.project.file.chooser.step.summary", new Object[0]);
        if (string == null) {
            FileChooserStep.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doInit() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myFormPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/FileChooserStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummaryText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

