/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.autoupload.MuteFilter;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteHostTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(RemoteHostTask.class);
    private final DistinctRootsCollections.SystemIndependentPaths myAffectedLocalRoots;
    private final Collection<AutoUploadComponent.MuteLock> myMuteLocks;
    private final DistinctRootsCollections.RemotePaths myAffectedRemoteRoots;
    private Pair<WebServerConfig.RemotePath, Object> myToSelect;
    protected final ConnectionOwner myConnectionOwner;
    private final Deployable myServerConfig;
    private final PublishConfig myPublishConfig;
    protected final DeploymentMode myDeploymentMode;
    private volatile boolean myProjectCloseRequested;
    private volatile boolean myFinished;
    protected LocalHistoryAction myLocalHistoryAction;
    protected final DeploymentRevisionTracker myRevisionTracker;

    protected RemoteHostTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull Deployable serverConfig, @NotNull PublishConfig publishConfig, @NotNull String title, final boolean background, @NotNull DeploymentRevisionTracker revisionTracker, @NotNull DeploymentMode mode) {
        if (connectionOwner == null) {
            RemoteHostTask.$$$reportNull$$$0(0);
        }
        if (serverConfig == null) {
            RemoteHostTask.$$$reportNull$$$0(1);
        }
        if (publishConfig == null) {
            RemoteHostTask.$$$reportNull$$$0(2);
        }
        if (title == null) {
            RemoteHostTask.$$$reportNull$$$0(3);
        }
        if (revisionTracker == null) {
            RemoteHostTask.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            RemoteHostTask.$$$reportNull$$$0(5);
        }
        super(project, title, true, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return background;
            }
        });
        this.myMuteLocks = new SmartList();
        this.myConnectionOwner = connectionOwner;
        this.myServerConfig = serverConfig;
        this.myPublishConfig = publishConfig;
        this.myAffectedLocalRoots = new DistinctRootsCollections.SystemIndependentPaths(SystemInfo.isFileSystemCaseSensitive);
        boolean isCaseSensitive = this.myServerConfig.getAccessType().isProtocolBased() ? this.myServerConfig.isCaseSensitive() : SystemInfo.isFileSystemCaseSensitive;
        this.myAffectedRemoteRoots = new DistinctRootsCollections.RemotePaths(isCaseSensitive);
        this.myRevisionTracker = revisionTracker;
        this.myDeploymentMode = mode;
    }

    public boolean isConditionalModal() {
        return true;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RemoteHostTask.$$$reportNull$$$0(6);
        }
        this.doRun(indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doRun(@NotNull ProgressIndicator pi) {
        boolean bl;
        RemoteConnection connection;
        block36: {
            String error;
            if (pi == null) {
                RemoteHostTask.$$$reportNull$$$0(7);
            }
            LOG.assertTrue(!this.myFinished);
            this.beforeTaskStarted();
            Object pi_ = !this.canChangeProgressText() ? new DelegatingProgressIndicator(){

                public void setText(String text) {
                }
            } : pi;
            pi.setText(WDBundle.message("validating.server", new Object[0]));
            try {
                error = this.myServerConfig.validateInternalSlow(-1L, true);
            }
            catch (TimeoutException e) {
                LOG.error((Throwable)e);
                error = null;
            }
            if (error != null) {
                String message = WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)error));
                this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                this.showBalloon(MessageType.ERROR, message, true);
                return false;
            }
            String operationCancelledMessage = WDBundle.message("operation.cancelled", this.getTitle());
            if (!AuthHelper.ensureAuthSpecified(this.myProject, this.myServerConfig, this.myConnectionOwner)) {
                this.print(operationCancelledMessage, ConsoleViewContentType.ERROR_OUTPUT);
                return false;
            }
            pi.setText(WDBundle.message("logging.in", new Object[0]));
            if (this.getExistingConnection() != null) {
                connection = this.getExistingConnection().clone();
            } else {
                try {
                    connection = RemoteConnectionManager.getInstance().openConnection(this.myConnectionOwner, this.myTitle, (Connectable)this.myServerConfig, FileTransferConfig.Origin.Default, null, (ProgressIndicator)pi_);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    this.print(WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))), ConsoleViewContentType.ERROR_OUTPUT);
                    this.showBalloon(MessageType.ERROR, WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)PublishUtils.getMessage(e, false))), true);
                    PublishUtils.showLoginDialogAfterAuthFail(e, this.myServerConfig);
                    return false;
                }
            }
            pi.setText(WDBundle.message("running", new Object[0]));
            VetoableProjectManagerListener listener = null;
            try {
                if (this.myProject != null) {
                    listener = new VetoableProjectManagerListener((ProgressIndicator)pi_){
                        final /* synthetic */ ProgressIndicator val$pi_;
                        {
                            this.val$pi_ = progressIndicator;
                        }

                        public boolean canClose(@NotNull Project project) {
                            if (project == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            if (project != RemoteHostTask.this.myProject) {
                                return true;
                            }
                            String title = WDBundle.message("warning.running.dialog.title", RemoteHostTask.this.getTitle());
                            String text = WDBundle.message("warning.running.on.project.close", RemoteHostTask.this.getTitle());
                            int result = Messages.showOkCancelDialog((Project)RemoteHostTask.this.myProject, (String)text, (String)title, (Icon)Messages.getQuestionIcon());
                            if (result != 0) {
                                return false;
                            }
                            RemoteHostTask.this.myProjectCloseRequested = true;
                            this.val$pi_.cancel();
                            return RemoteHostTask.this.myFinished;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/RemoteHostTask$3", "canClose"));
                        }
                    };
                    ProjectManager.getInstance().addProjectManagerListener(listener);
                }
                ExecutionContextBase context = new ExecutionContextBase((ProgressIndicator)pi_, connection){
                    final /* synthetic */ ProgressIndicator val$pi_;
                    final /* synthetic */ RemoteConnection val$connection;
                    {
                        this.val$pi_ = progressIndicator;
                        this.val$connection = remoteConnection;
                    }

                    @Override
                    public void addAffectedRoot(FileName fileName, boolean remote) {
                        if (remote) {
                            RemoteHostTask.this.myAffectedRemoteRoots.add(RemoteHostTask.this.myServerConfig.getRemotePath(fileName));
                        } else {
                            String path = DeploymentPathUtils.getLocalPath(fileName);
                            RemoteHostTask.this.myAffectedLocalRoots.add(path);
                            if (RemoteHostTask.this.myProject != null && !RemoteHostTask.this.myProject.isDefault()) {
                                AutoUploadComponent autoUploadComponent = AutoUploadComponent.getInstance(RemoteHostTask.this.myProject);
                                LocalFileSystem instance = LocalFileSystem.getInstance();
                                while (!StringUtil.isEmpty((String)path)) {
                                    VirtualFile file = instance.findFileByPath(path);
                                    if (file != null) {
                                        AutoUploadComponent.MuteLock lock = autoUploadComponent.mutePaths(MuteFilter.create(path));
                                        RemoteHostTask.this.myMuteLocks.add(lock);
                                        break;
                                    }
                                    path = PathUtil.getParentPath((String)path);
                                }
                            }
                        }
                    }

                    @Override
                    public ProgressIndicator getProgressIndicator() {
                        return this.val$pi_;
                    }

                    @Override
                    public FileObject findRemoteFile(WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
                        FileObject file = PublishUtils.findFile(this.val$connection, path, (Connectable)RemoteHostTask.this.myServerConfig);
                        if (refreshUpRecursively) {
                            DeploymentPathUtils.refreshRemoteFile(file, this);
                        } else {
                            file.refresh();
                        }
                        return file;
                    }

                    @Override
                    public Deployable getServer() {
                        return RemoteHostTask.this.myServerConfig;
                    }

                    @Override
                    public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
                        RemoteHostTask.this.myToSelect = Pair.create((Object)remotePath, (Object)requestor);
                    }

                    @Override
                    public DeploymentMode getDeploymentMode() {
                        return RemoteHostTask.this.myDeploymentMode;
                    }
                };
                bl = (Boolean)connection.executeServerOperationSilently(() -> this.executeOperations(context, connection), (ProgressIndicator)pi_);
                this.myFinished = true;
                if (listener == null) break block36;
            }
            catch (ProcessCanceledException e) {
                boolean bl2;
                block37: {
                    try {
                        LOG.debug("cancelled");
                        this.print(operationCancelledMessage, ConsoleViewContentType.ERROR_OUTPUT);
                        bl2 = false;
                        this.myFinished = true;
                        if (listener == null) break block37;
                    }
                    catch (Throwable throwable) {
                        this.myFinished = true;
                        if (listener != null) {
                            ProjectManager.getInstance().removeProjectManagerListener(listener);
                        }
                        connection.release();
                        if (this.myProjectCloseRequested) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (this.myProject != null) {
                                    ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
                                }
                            });
                        } else {
                            if (!this.myAffectedLocalRoots.isEmpty()) {
                                pi.setText(WDBundle.message("refreshing.local.files", new Object[0]));
                                pi.setIndeterminate(true);
                                ArrayList files = new ArrayList(this.myAffectedLocalRoots.size());
                                ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                                    Iterator iterator = this.myAffectedLocalRoots.iterator();
                                    while (iterator.hasNext()) {
                                        String root = (String)iterator.next();
                                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                                        if (file == null || !file.isValid()) continue;
                                        files.add(file);
                                    }
                                }));
                                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])files.toArray(VirtualFile.EMPTY_ARRAY));
                                if (this.myLocalHistoryAction != null) {
                                    this.myLocalHistoryAction.finish();
                                }
                                if (!this.myMuteLocks.isEmpty() && this.myProject != null && !this.myProject.isDefault()) {
                                    AutoUploadComponent uploader = AutoUploadComponent.getInstance(this.myProject);
                                    for (AutoUploadComponent.MuteLock lock : this.myMuteLocks) {
                                        uploader.unmutePaths(lock);
                                    }
                                }
                            }
                            if (!this.myAffectedRemoteRoots.isEmpty()) {
                                pi.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                                pi.setIndeterminate(true);
                                ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(this.myServerConfig, (Collection<WebServerConfig.RemotePath>)((Object)this.myAffectedRemoteRoots), false, true, (WebServerConfig.RemotePath)Pair.getFirst(this.myToSelect), Pair.getSecond(this.myToSelect));
                            }
                        }
                        throw throwable;
                    }
                    ProjectManager.getInstance().removeProjectManagerListener(listener);
                }
                connection.release();
                if (this.myProjectCloseRequested) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.myProject != null) {
                            ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
                        }
                    });
                } else {
                    if (!this.myAffectedLocalRoots.isEmpty()) {
                        pi.setText(WDBundle.message("refreshing.local.files", new Object[0]));
                        pi.setIndeterminate(true);
                        ArrayList files = new ArrayList(this.myAffectedLocalRoots.size());
                        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                            Iterator iterator = this.myAffectedLocalRoots.iterator();
                            while (iterator.hasNext()) {
                                String root = (String)iterator.next();
                                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                                if (file == null || !file.isValid()) continue;
                                files.add(file);
                            }
                        }));
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])files.toArray(VirtualFile.EMPTY_ARRAY));
                        if (this.myLocalHistoryAction != null) {
                            this.myLocalHistoryAction.finish();
                        }
                        if (!this.myMuteLocks.isEmpty() && this.myProject != null && !this.myProject.isDefault()) {
                            AutoUploadComponent uploader = AutoUploadComponent.getInstance(this.myProject);
                            for (AutoUploadComponent.MuteLock lock : this.myMuteLocks) {
                                uploader.unmutePaths(lock);
                            }
                        }
                    }
                    if (!this.myAffectedRemoteRoots.isEmpty()) {
                        pi.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                        pi.setIndeterminate(true);
                        ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(this.myServerConfig, (Collection<WebServerConfig.RemotePath>)((Object)this.myAffectedRemoteRoots), false, true, (WebServerConfig.RemotePath)Pair.getFirst(this.myToSelect), Pair.getSecond(this.myToSelect));
                    }
                }
                return bl2;
            }
            ProjectManager.getInstance().removeProjectManagerListener(listener);
        }
        connection.release();
        if (this.myProjectCloseRequested) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject != null) {
                    ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
                }
            });
        } else {
            if (!this.myAffectedLocalRoots.isEmpty()) {
                pi.setText(WDBundle.message("refreshing.local.files", new Object[0]));
                pi.setIndeterminate(true);
                ArrayList files = new ArrayList(this.myAffectedLocalRoots.size());
                ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    Iterator iterator = this.myAffectedLocalRoots.iterator();
                    while (iterator.hasNext()) {
                        String root = (String)iterator.next();
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                        if (file == null || !file.isValid()) continue;
                        files.add(file);
                    }
                }));
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])files.toArray(VirtualFile.EMPTY_ARRAY));
                if (this.myLocalHistoryAction != null) {
                    this.myLocalHistoryAction.finish();
                }
                if (!this.myMuteLocks.isEmpty() && this.myProject != null && !this.myProject.isDefault()) {
                    AutoUploadComponent uploader = AutoUploadComponent.getInstance(this.myProject);
                    for (AutoUploadComponent.MuteLock lock : this.myMuteLocks) {
                        uploader.unmutePaths(lock);
                    }
                }
            }
            if (!this.myAffectedRemoteRoots.isEmpty()) {
                pi.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                pi.setIndeterminate(true);
                ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(this.myServerConfig, (Collection<WebServerConfig.RemotePath>)((Object)this.myAffectedRemoteRoots), false, true, (WebServerConfig.RemotePath)Pair.getFirst(this.myToSelect), Pair.getSecond(this.myToSelect));
            }
        }
        return bl;
    }

    protected void beforeTaskStarted() {
    }

    @Nullable
    protected RemoteConnection getExistingConnection() {
        return null;
    }

    protected boolean canChangeProgressText() {
        return true;
    }

    protected abstract boolean executeOperations(ExecutionContextBase var1, RemoteConnection var2);

    protected void print(String text, ConsoleViewContentType contentType) {
        FileTransferToolWindow.printWithTimestamp(this.myProject, this.myServerConfig, text, contentType, this.myPublishConfig.getTraceLevel());
    }

    protected DeploymentNotifier.ToolWindowIdProvider getBalloonAnchor() {
        return FileTransferToolWindow.ID_PROVIDER;
    }

    protected void showBalloon(MessageType type, String text, boolean isSummary) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject == null || this.myProject.isDisposed()) {
                return;
            }
            DeploymentNotifier.notifyWithBalloon(null, text, type.toNotificationType(), null, this.myProject, this.getBalloonAnchor());
        });
    }

    public static String getItemsMessage(int number) {
        return WDBundle.message("items", number, number == 1 ? 1 : 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionTracker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/RemoteHostTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

