/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.trivialif.JSSplitIfAndIntention;
import org.jetbrains.annotations.NotNull;

public class JSSplitIfOrIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new SplitIfOrPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement jsElement;
        if (element == null) {
            JSSplitIfOrIntention.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = jsElement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        assert (jsElement != null);
        assert (jsElement instanceof JSIfStatement);
        JSIfStatement ifStatement = (JSIfStatement)jsElement;
        assert (ifStatement.getCondition() instanceof JSBinaryExpression);
        JSBinaryExpression condition = (JSBinaryExpression)ifStatement.getCondition();
        String lhsText = JSSplitIfAndIntention.getConditionText(condition.getLOperand(), condition);
        String rhsText = JSSplitIfAndIntention.getConditionText(condition.getROperand(), condition);
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        String thenText = thenBranch.getText();
        assert (condition.getOperationSign().equals(JSTokenTypes.OROR));
        StringBuilder statement = new StringBuilder(ifStatement.getTextLength());
        statement.append("if (").append(lhsText).append(')').append(thenText).append("\nelse if (").append(rhsText).append(')').append(thenText);
        if (elseBranch != null) {
            statement.append(" else ").append(elseBranch.getText());
        }
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)ifStatement, (String)statement.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfOrIntention", "processIntention"));
    }

    private static class SplitIfOrPredicate
    implements JSElementPredicate {
        private SplitIfOrPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            JSExpression condition;
            PsiElement parent;
            if (element == null) {
                SplitIfOrPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if ((condition = (ifStatement = (JSIfStatement)parent).getCondition()) == null || PsiUtilCore.hasErrorElementChild((PsiElement)condition)) {
                return false;
            }
            return condition instanceof JSBinaryExpression && JSTokenTypes.OROR.equals(((JSBinaryExpression)condition).getOperationSign());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfOrIntention$SplitIfOrPredicate", "satisfiedBy"));
        }
    }
}

