/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeParallelIfsIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new MergeParallelIfsPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSMergeParallelIfsIntention.$$$reportNull$$$0(0);
        }
        PsiElement nextElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        assert (nextElement != null);
        JSIfStatement firstStatement = (JSIfStatement)element;
        JSIfStatement secondStatement = (JSIfStatement)nextElement;
        StringBuilder statementBuffer = new StringBuilder();
        this.mergeIfStatements(statementBuffer, firstStatement, secondStatement);
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)firstStatement, (String)statementBuffer.toString());
        JSRefactoringUtil.removeElementWithLinebreak((PsiElement)secondStatement);
    }

    private void mergeIfStatements(StringBuilder statementBuffer, JSIfStatement firstStatement, JSIfStatement secondStatement) {
        JSExpression condition = firstStatement.getCondition();
        JSStatement firstThenBranch = firstStatement.getThen();
        JSStatement secondThenBranch = secondStatement.getThen();
        JSStatement firstElseBranch = firstStatement.getElse();
        JSStatement secondElseBranch = secondStatement.getElse();
        statementBuffer.append(IF_STATEMENT_PREFIX).append(condition.getText()).append(')');
        ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstThenBranch, (JSStatement)secondThenBranch);
        if (firstElseBranch != null || secondElseBranch != null) {
            statementBuffer.append(ELSE_KEYWORD);
            if (firstElseBranch instanceof JSIfStatement && secondElseBranch instanceof JSIfStatement && MergeParallelIfsPredicate.ifStatementsCanBeMerged((JSIfStatement)firstElseBranch, (JSIfStatement)secondElseBranch)) {
                this.mergeIfStatements(statementBuffer, (JSIfStatement)firstElseBranch, (JSIfStatement)secondElseBranch);
            } else {
                ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstElseBranch, (JSStatement)secondElseBranch);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeParallelIfsIntention", "processIntention"));
    }

    private static class MergeParallelIfsPredicate
    implements JSElementPredicate {
        private MergeParallelIfsPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MergeParallelIfsPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSIfStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
            if (!(nextStatement instanceof JSIfStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)nextStatement)) {
                return false;
            }
            return MergeParallelIfsPredicate.ifStatementsCanBeMerged((JSIfStatement)element, (JSIfStatement)nextStatement);
        }

        public static boolean ifStatementsCanBeMerged(JSIfStatement statement1, JSIfStatement statement2) {
            JSExpression secondCondition;
            JSStatement thenBranch = statement1.getThen();
            JSStatement elseBranch = statement1.getElse();
            if (thenBranch == null) {
                return false;
            }
            JSExpression firstCondition = statement1.getCondition();
            if (!EquivalenceChecker.expressionsAreEquivalent((JSExpression)firstCondition, (JSExpression)(secondCondition = statement2.getCondition()))) {
                return false;
            }
            JSStatement nextThenBranch = statement2.getThen();
            if (!ControlFlowUtils.canBeMerged((JSStatement)thenBranch, (JSStatement)nextThenBranch)) {
                return false;
            }
            JSStatement nextElseBranch = statement2.getElse();
            return elseBranch == null || nextElseBranch == null || ControlFlowUtils.canBeMerged((JSStatement)elseBranch, (JSStatement)nextElseBranch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeParallelIfsIntention$MergeParallelIfsPredicate", "satisfiedBy"));
        }
    }
}

