/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.initialization.JSSplitDeclarationAndInitializationIntention;
import org.jetbrains.annotations.NotNull;

public class JSSplitDeclarationAndMoveToScopeStartIntention
extends JSSplitDeclarationAndInitializationIntention {
    private static final JSElementPredicate PREDICATE = new JSVariablesWithInitializerPredicate(){

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (!super.satisfiedBy(element)) {
                return false;
            }
            JSFunction scope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
            return scope != null && JSPsiImplUtils.findFirstFunctionStatement((JSFunction)scope) != element && this.checkNoConflicts(scope, (JSVarStatement)element);
        }

        private boolean checkNoConflicts(JSFunction scope, JSVarStatement element) {
            if (element.getVarKeyword() == null || element.getVarKeyword() == JSVarStatement.VarKeyword.VAR) {
                return true;
            }
            PsiElement parent = this.getBlockScopeParent((PsiElement)element);
            if (parent == null) {
                return true;
            }
            JSVariable[] variables = element.getVariables();
            if (variables.length == 0) {
                return true;
            }
            Set names = Arrays.stream(variables).map(v -> v.getName()).collect(Collectors.toSet());
            PsiElement declarationScope = variables[0].getDeclarationScope();
            return SyntaxTraverser.psiTraverser((PsiElement)scope).filter(JSVarStatement.class).filter(s -> s.getVarKeyword() != null && s.getVarKeyword() != JSVarStatement.VarKeyword.VAR).flatMap(v -> JBIterable.of((Object[])v.getVariables())).filter(v -> names.contains(v.getName()) && PsiTreeUtil.isAncestor((PsiElement)v.getDeclarationScope(), (PsiElement)declarationScope, (boolean)true)).isEmpty();
        }

        private PsiElement getBlockScopeParent(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSLoopStatement.class});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention$1", "satisfiedBy"));
        }
    };

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            JSSplitDeclarationAndMoveToScopeStartIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof JSVarStatement && ((JSVarStatement)element).getVarKeyword() == JSVarStatement.VarKeyword.CONST) {
            return JSIntentionBundle.message("initialization.split-declaration-and-move-to-scope-start.let.display-name", new Object[0]);
        }
        return JSIntentionBundle.message("initialization.split-declaration-and-move-to-scope-start.display-name", new Object[0]);
    }

    @Override
    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        JSStatement newStatement = JSPsiElementFactory.createJSStatement((String)declarations, (PsiElement)oldVarStatement);
        JSStatement newStatementAnchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)oldVarStatement);
        if (newStatementAnchor == null) {
            newStatementAnchor = oldVarStatement;
        }
        newStatement = newStatementAnchor.getParent().addBefore((PsiElement)newStatement, (PsiElement)newStatementAnchor);
        PsiElement parent = oldVarStatement.getParent();
        if (parent instanceof JSVariableDeclaringScope) {
            PsiElement newElement = JSSplitDeclarationAndMoveToScopeStartIntention.createForParent(oldVarStatement, parent, initializations);
            oldVarStatement.replace(newElement);
            return;
        }
        int startOffset = newStatement.getTextOffset();
        JSStatement assignmentStatement = null;
        boolean first = true;
        for (String initialization : initializations) {
            if (first) {
                first = false;
                JSStatement newInitializer = JSPsiElementFactory.createJSStatement((String)initialization, (PsiElement)newStatement);
                assignmentStatement = oldVarStatement.replace(newInitializer);
                continue;
            }
            assignmentStatement = assignmentStatement.addStatementAfter(JSPsiElementFactory.createJSStatement((String)initialization, (PsiElement)newStatement));
        }
        if (assignmentStatement == null) {
            return;
        }
        int endOffset = assignmentStatement.getTextOffset() + assignmentStatement.getTextLength();
        if (PsiDocumentManager.getInstance((Project)newStatement.getProject()).getDocument(newStatement.getContainingFile()) != null) {
            CodeStyleManager.getInstance((Project)newStatement.getProject()).reformatText(newStatement.getContainingFile(), startOffset, endOffset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention", "getElementPredicate"));
    }
}

