/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeToCStyleCommentIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new EndOfLineCommentPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiComment nextComment;
        if (element == null) {
            JSChangeToCStyleCommentIntention.$$$reportNull$$$0(0);
        }
        PsiComment firstComment = (PsiComment)element;
        PsiElement prevComment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstComment);
        while (JSChangeToCStyleCommentIntention.isCommentContinuation(prevComment)) {
            firstComment = (PsiComment)prevComment;
            prevComment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstComment);
        }
        StringBuilder buffer = new StringBuilder();
        PsiComment lastElementToDelete = nextComment = firstComment;
        boolean hasLineBreaks = false;
        String minIndent = null;
        boolean isContinuation = JSChangeToCStyleCommentIntention.isCommentContinuation((PsiElement)nextComment);
        if (!isContinuation) {
            buffer.append(JSChangeToCStyleCommentIntention.getCommentContents(nextComment));
        }
        while (isContinuation) {
            String text;
            int lastNewLine;
            PsiElement prevSibling = nextComment.getPrevSibling();
            if (prevSibling instanceof PsiWhiteSpace && (lastNewLine = (text = prevSibling.getText()).lastIndexOf(10)) >= 0) {
                String substring = text.substring(lastNewLine + 1);
                if (minIndent == null || substring.length() < minIndent.length()) {
                    minIndent = substring;
                }
                if (buffer.length() > 0) {
                    buffer.append('\n');
                }
                buffer.append(substring);
                hasLineBreaks = true;
            }
            buffer.append(JSChangeToCStyleCommentIntention.getCommentContents(nextComment));
            lastElementToDelete = nextComment;
            nextComment = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextComment);
            isContinuation = JSChangeToCStyleCommentIntention.isCommentContinuation((PsiElement)nextComment);
        }
        String text = StringUtil.replace((String)buffer.toString(), (String)"*/", (String)"* /");
        if (!hasLineBreaks && text.length() >= 1) {
            if (!Character.isWhitespace(text.charAt(0))) {
                text = " " + text;
            }
            if (!Character.isWhitespace(text.charAt(text.length() - 1))) {
                text = text + " ";
            }
        }
        String lineBreak = hasLineBreaks ? "\n" : "";
        String extraIndent = minIndent != null ? minIndent : "";
        String newCommentString = "/*" + lineBreak + text + lineBreak + extraIndent + "*/";
        PsiComment newComment = JSPsiElementFactory.createPsiComment((String)newCommentString, (PsiElement)firstComment);
        if (lastElementToDelete == firstComment) {
            firstComment.replace((PsiElement)newComment);
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)firstComment.getProject()).getDocument(firstComment.getContainingFile());
        PsiElement nextSibling = firstComment.getNextSibling();
        PsiElement newElement = firstComment.replace((PsiElement)newComment);
        if (document != null) {
            FormatFixer ff = FormatFixer.create((PsiElement)newElement, (PsiElement)lastElementToDelete, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak);
            newElement.getParent().deleteChildRange(nextSibling, (PsiElement)lastElementToDelete);
            ff.fixFormat();
        } else {
            newElement.getParent().deleteChildRange(nextSibling, (PsiElement)lastElementToDelete);
        }
    }

    @Contract(value="null -> false")
    private static boolean isCommentContinuation(@Nullable PsiElement prevComment) {
        return JSChangeToCStyleCommentIntention.isEndOfLineComment(prevComment) && JSChangeToCStyleCommentIntention.isValidSiblingComment(prevComment);
    }

    private static boolean isValidSiblingComment(@NotNull PsiElement prevComment) {
        PsiElement prevForPrevComment;
        if (prevComment == null) {
            JSChangeToCStyleCommentIntention.$$$reportNull$$$0(1);
        }
        return (prevForPrevComment = prevComment.getPrevSibling()) == null || prevForPrevComment instanceof PsiWhiteSpace && prevForPrevComment.getText().indexOf(10) >= 0;
    }

    @Contract(value="null -> false")
    private static boolean isEndOfLineComment(@Nullable PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JSTokenTypes.END_OF_LINE_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(PsiComment comment) {
        return comment.getText().substring(2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevComment";
                break;
            }
        }
        objectArray2[1] = "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSiblingComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EndOfLineCommentPredicate
    implements JSElementPredicate {
        private EndOfLineCommentPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                EndOfLineCommentPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            IElementType type = ((PsiComment)element).getTokenType();
            return JSTokenTypes.END_OF_LINE_COMMENT.equals(type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention$EndOfLineCommentPredicate", "satisfiedBy"));
        }
    }
}

