/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class JSFlipConjunctionIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        return this.getText(sign == JSTokenTypes.ANDAND ? "&&" : "||");
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSFlipConjunctionIntention.$$$reportNull$$$0(0);
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        JSBinaryExpression exp = ConjunctionPredicate.getTopConjunction(binaryExpression, sign);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)this.flipExpression((JSExpression)exp, sign, binaryExpression.getOperationNode()));
    }

    private String flipExpression(JSExpression exp, IElementType conjunctionType, ASTNode node) {
        if (ConjunctionPredicate.isConjunctionExpression((JSElement)exp, conjunctionType)) {
            JSBinaryExpression andExpression = (JSBinaryExpression)exp;
            return this.flipExpression(andExpression.getROperand(), conjunctionType, node) + ' ' + node.getText() + ' ' + this.flipExpression(andExpression.getLOperand(), conjunctionType, node);
        }
        return exp.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention", "processIntention"));
    }
}

