/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class JSDeMorgansLawIntention
extends JSMutablyNamedIntention {
    private static final String AND_OPERATOR = "&&";
    private static final String OR_OPERATOR = "||";
    private static final String AND_SUFFIX = "ANDAND";
    private static final String OR_SUFFIX = "OROR";

    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        return this.getSuffixedDisplayName(JSTokenTypes.ANDAND.equals(tokenType) ? AND_SUFFIX : OR_SUFFIX, new Object[0]);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDeMorgansLawIntention.$$$reportNull$$$0(0);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        IElementType tokenType = exp.getOperationSign();
        exp = ConjunctionPredicate.getTopConjunction(exp, tokenType);
        assert (tokenType != null);
        String newExpression = this.convertConjunctionExpression(exp, tokenType);
        ConditionalUtils.replaceExpressionWithNegatedExpressionString((JSExpression)exp, newExpression);
    }

    private String convertConjunctionExpression(JSBinaryExpression exp, IElementType tokenType) {
        IElementType flippedOperator = tokenType.equals(JSTokenTypes.ANDAND) ? JSTokenTypes.OROR : JSTokenTypes.ANDAND;
        int precedence = flippedOperator.equals(JSTokenTypes.ANDAND) ? 14 : 15;
        String leftText = this.getOperandText(exp.getLOperand(), tokenType, precedence);
        String rightText = this.getOperandText(exp.getROperand(), tokenType, precedence);
        String flippedConjunction = flippedOperator.equals(JSTokenTypes.ANDAND) ? AND_OPERATOR : OR_OPERATOR;
        return leftText + flippedConjunction + rightText;
    }

    private String getOperandText(JSExpression operand, IElementType tokenType, int precedence) {
        return ConjunctionPredicate.isConjunctionExpression((JSElement)operand, tokenType) ? this.convertConjunctionExpression((JSBinaryExpression)operand, tokenType) : BoolUtils.getNegatedExpressionText(operand, precedence);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention", "processIntention"));
    }
}

