/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSThrowExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConjunctionPredicate
implements JSElementPredicate {
    ConjunctionPredicate() {
    }

    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            ConjunctionPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JSBinaryExpression)) {
            return false;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
            return false;
        }
        JSBinaryExpression expression = (JSBinaryExpression)element;
        IElementType sign = expression.getOperationSign();
        return (JSTokenTypes.ANDAND == sign || JSTokenTypes.OROR == sign) && !ConjunctionPredicate.hasUnsafeExpression(ConjunctionPredicate.getTopConjunction(expression, sign));
    }

    private static boolean hasUnsafeExpression(@NotNull JSBinaryExpression element) {
        if (element == null) {
            ConjunctionPredicate.$$$reportNull$$$0(1);
        }
        return !SyntaxTraverser.psiTraverser((PsiElement)element.getROperand()).filter(JSThrowExpression.class).isEmpty() || !((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)element.getLOperand()).forceIgnore(t -> t == JSElementTypes.PARENTHESIZED_EXPRESSION)).filter(JSBinaryExpression.class).transform(e -> e.getROperand()).filter(JSThrowExpression.class).filter(JSThrowExpression.class).isEmpty();
    }

    static boolean isConjunctionExpression(@Nullable JSElement expression, @NotNull IElementType conjunctionType) {
        if (conjunctionType == null) {
            ConjunctionPredicate.$$$reportNull$$$0(2);
        }
        if (!(expression instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
        return conjunctionType.equals(binaryExpression.getOperationSign());
    }

    @NotNull
    static JSBinaryExpression getTopConjunction(JSBinaryExpression exp, IElementType tokenType) {
        JSElement parent = (JSElement)exp.getParent();
        while (ConjunctionPredicate.isConjunctionExpression(parent, tokenType)) {
            exp = (JSBinaryExpression)parent;
            parent = (JSElement)exp.getParent();
        }
        JSBinaryExpression jSBinaryExpression = exp;
        if (jSBinaryExpression == null) {
            ConjunctionPredicate.$$$reportNull$$$0(3);
        }
        return jSBinaryExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conjunctionType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/ConjunctionPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/ConjunctionPredicate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopConjunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "satisfiedBy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasUnsafeExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConjunctionExpression";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

