/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NotNullLazyValue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JavaScriptFileType
extends LanguageFileType {
    private static final NotNullLazyValue<List<FileType>> ourFileTypesCompilableToJavaScript = new NotNullLazyValue<List<FileType>>(){

        @NotNull
        protected List<FileType> compute() {
            ArrayList<FileType> fileTypes = new ArrayList<FileType>();
            for (FileType type : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                Language language;
                if (type.getDefaultExtension().equals("as") || !(type instanceof LanguageFileType) || !(language = ((LanguageFileType)type).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE)) continue;
                fileTypes.add(type);
            }
            if (fileTypes.isEmpty()) {
                Logger.getInstance(JavaScriptFileType.class).error("No file types compilable to JavaScript");
            }
            ImmutableList immutableList = ImmutableList.copyOf(fileTypes);
            if (immutableList == null) {
                1.$$$reportNull$$$0(0);
            }
            return immutableList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptFileType$1", "compute"));
        }
    };
    public static final JavaScriptFileType INSTANCE = new JavaScriptFileType();
    public static final String DEFAULT_EXTENSION = "js";

    public JavaScriptFileType() {
        super((Language)JavascriptLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return "JavaScript";
    }

    @NotNull
    public String getDescription() {
        String string = JavaScriptBundle.message("javascript.filetype.description", new Object[0]);
        if (string == null) {
            JavaScriptFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.JavaScript;
    }

    @Deprecated
    @NotNull
    public static List<FileType> getFileTypesCompilableToJavaScript() {
        List list = (List)ourFileTypesCompilableToJavaScript.getValue();
        if (list == null) {
            JavaScriptFileType.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/JavaScriptFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesCompilableToJavaScript";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

