/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.util.Asserts;
import com.yourkit.util.Strings;
import com.yourkit.util.http.Protocol;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpUri {
    @NotNull
    private Protocol myProtocol;
    @NotNull
    private String myHost;
    private int myPort;
    @NotNull
    private String myPath;
    @NotNull
    private String myAnchor;
    @NotNull
    private final HashMap<String, List<String>> myParams;

    public HttpUri(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this(Protocol.RELATIVE, "", -1, path);
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this(protocol, host, -1, "");
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this(protocol, host, -1, path);
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host, int port, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        this.myPath = "";
        this.myAnchor = "";
        this.myParams = new HashMap(2);
        this.myProtocol = protocol;
        this.myHost = host;
        this.myPort = port;
        this.setPath(path);
    }

    @NotNull
    public Protocol getProtocol() {
        Protocol protocol = this.myProtocol;
        if (protocol == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return protocol;
    }

    public void setProtocol(@NotNull Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myProtocol = protocol;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public void setHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myHost = host;
    }

    public final int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public void setPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (path.contains("?")) {
            Asserts.fail();
        }
        this.myPath = path;
    }

    @NotNull
    public final String getAnchor() {
        String string = this.myAnchor;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public final void setAnchor(@NotNull String anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (anchor.contains("#")) {
            Asserts.fail();
        }
        this.myAnchor = anchor;
    }

    @Nullable
    private String getFirstParameter(@Nullable String name) {
        List<String> values = this.myParams.get(name);
        if (values != null && values.size() <= 0) {
            Asserts.fail();
        }
        return values != null ? values.get(0) : null;
    }

    @Nullable
    public final String getParameter(@Nullable String name) {
        return this.getFirstParameter(name);
    }

    public final void setParameter(@NotNull String paramName, @Nullable String paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (paramValue == null || paramValue.isEmpty()) {
            this.myParams.remove(paramName);
        } else {
            this.myParams.put(paramName, Collections.singletonList(paramValue));
        }
    }

    @Nullable
    public final List<? extends String> getParameterValues(@Nullable String name) {
        return this.myParams.get(name);
    }

    public final void setParameterValues(@NotNull String paramName, @Nullable List<? extends String> values) {
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (values == null || values.isEmpty()) {
            this.myParams.remove(paramName);
            return;
        }
        this.myParams.put(paramName, new ArrayList<String>(values));
    }

    public final void setParameter(@NotNull String paramName, int paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.setParameter(paramName, Integer.toString(paramValue));
    }

    public final void setParameters(@NotNull Map<String, String> key2Value) {
        if (key2Value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (Map.Entry<String, String> e : key2Value.entrySet()) {
            this.setParameter(e.getKey(), e.getValue());
        }
    }

    @NotNull
    public final Collection<String> getParameterNames() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myParams.keySet());
        if (collection == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return collection;
    }

    @NotNull
    public final String getUrlEncodedQuery() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.myParams.entrySet()) {
            List<String> values;
            String key = entry.getKey();
            if (key == null) {
                Asserts.fail();
            }
            if (key.isEmpty()) {
                Asserts.fail();
            }
            if ((values = entry.getValue()) == null || values.size() <= 0) {
                Asserts.fail();
            }
            for (String val : values) {
                if (val == null || val.isEmpty()) continue;
                if (b.length() > 0) {
                    b.append("&");
                }
                b.append(HttpUri.encodeUrl(key)).append("=").append(HttpUri.encodeUrl(val));
            }
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    private String asString(boolean withQuery) {
        String query;
        String path;
        StringBuilder result = new StringBuilder();
        if (!this.myHost.isEmpty()) {
            if (this.myProtocol != Protocol.RELATIVE) {
                result.append(this.getProtocol().name).append(":");
            }
            result.append("//").append(this.getHost());
            int port = this.getPort();
            if (port >= 0) {
                result.append(":").append(port);
            }
        }
        if (!(path = this.getPath()).isEmpty()) {
            result.append(path);
        }
        if (withQuery && !(query = this.getUrlEncodedQuery()).isEmpty()) {
            result.append("?").append(query);
        }
        if (!this.myAnchor.isEmpty()) {
            result.append('#').append(this.myAnchor);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public final String asStringWithoutQuery() {
        String string = this.asString(false);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public final String asString() {
        String string = this.asString(true);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static HttpUri parse(@NotNull String uriStr) {
        URL url;
        if (uriStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            url = new URL(uriStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
        Protocol protocol = Protocol.parse(url.getProtocol());
        if (protocol == null) {
            return null;
        }
        return new HttpUri(protocol, url.getHost(), url.getPort(), url.getPath());
    }

    @NotNull
    private static String encodeUrl(@NotNull String url) {
        String string;
        if (url == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            string = URLEncoder.encode(url, Strings.UTF_8.name());
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException(exc);
        }
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpUri)) {
            return false;
        }
        HttpUri uri = (HttpUri)obj;
        return this.myProtocol.equals((Object)uri.myProtocol) && this.myHost.equals(uri.myHost) && this.myPort == uri.myPort && this.myPath.equals(uri.myPath) && this.myAnchor.equals(uri.myAnchor) && this.myParams.equals(uri.myParams);
    }

    public int hashCode() {
        return this.myProtocol.hashCode() + this.myHost.hashCode() + this.myPort + this.myPath.hashCode() + this.myAnchor.hashCode() + this.myParams.hashCode();
    }
}

