/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.util.ArrayUtil;
import com.yourkit.util.Asserts;
import com.yourkit.util.IoUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.Value;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileUtil {
    private static final File[] FILE_EMPTY_ARRAY = new File[0];

    public static void copy(@NotNull File source, @NotNull File destination) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(destination);){
            IoUtil.copy(in, out);
        }
    }

    @NotNull
    public static byte[] readBytes(@NotNull InputStream in) throws IOException {
        byte[] byArray;
        block13: {
            if (in == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                IoUtil.copy(in, output);
                output.flush();
                byArray = output.toByteArray();
                if (byArray != null) break block13;
            }
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String normalize(@NotNull File file) {
        String string;
        String string2;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException ignored) {
            String absolutePath = file.getAbsolutePath();
            string = Constants.OS_WINDOWS ? absolutePath.toLowerCase() : absolutePath;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = string2;
        if (string2 == null) throw new IllegalStateException("Method must not return null");
        return string;
    }

    @NotNull
    public static String normalizeDirectory(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String result = FileUtil.normalize(file);
        String string = result.endsWith(File.separator) ? result : result + File.separator;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static boolean hasExtension(@NotNull File file, @NotNull String extension) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        return FileUtil.hasExtension(file.getName(), extension);
    }

    public static boolean hasExtension(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return Strings.endsWithIgnoreCase(fileName, extension);
        }
        return fileName.endsWith(extension);
    }

    public static boolean hasName(@NotNull File file, @NotNull String name) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return file.getName().equalsIgnoreCase(name);
        }
        return file.getName().equals(name);
    }

    public static boolean nameStartsWith(@NotNull File file, @NotNull String prefix) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String name = file.getName();
        if (Constants.OS_WINDOWS) {
            return name.toLowerCase().startsWith(prefix);
        }
        return name.startsWith(prefix);
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        String string = index == -1 ? fileName : fileName.substring(0, index);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String validateTempFilePrefix(@NotNull String prefix) {
        String string;
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int length = prefix.length();
        if (length == 0) {
            return "___";
        }
        if (length == 1) {
            string = prefix + "__";
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        if (length == 2) {
            string = prefix + "_";
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = prefix;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int index = fileName.lastIndexOf(46);
        String string = index == -1 ? "" : fileName.substring(index);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void setExecutableAttributeAsync(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            Asserts.fail();
        }
        try {
            Runtime.getRuntime().exec("chmod ugoa+x " + file.getName(), null, file.getParentFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasHprofExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasExtension(fileName, ".hprof") || FileUtil.hasExtension(fileName, ".bin");
    }

    public static boolean hasSnapshotExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasExtension(fileName, ".snapshot");
    }

    public static boolean hasSnapshotOrHprofExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasSnapshotOrHprofExtension(file.getName());
    }

    public static boolean hasSnapshotOrHprofExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasSnapshotExtension(fileName) || FileUtil.hasHprofExtension(fileName);
    }

    public static boolean hasGzippedSnapshotExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasExtension(file, ".snapshot.gz") || FileUtil.hasExtension(file, ".hprof.gz");
    }

    public static boolean hasZipExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return FileUtil.hasExtension(file, ".zip");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String cutSnapshotExtension(@NotNull String fileName) {
        String string;
        if (fileName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String extension = ".snapshot";
        if (FileUtil.hasExtension(fileName, ".snapshot")) {
            string = fileName.substring(0, fileName.length() - ".snapshot".length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = fileName;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    public static String getOwnJavaExecutablePath(boolean withJavaW) {
        return new File(System.getProperty("java.home"), Constants.OS_WINDOWS ? (withJavaW ? "bin\\javaw.exe" : "bin\\java.exe") : "bin/java").getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String expandUserHome(@NotNull String path) {
        String string;
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String homeDirPrefix = "~/";
        if (path.startsWith("~/")) {
            string = System.getProperty("user.home") + "/" + path.substring("~/".length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = path;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    public static void visitDirectory(File dir, DirectoryVisitor visitor) throws IOException {
        if (visitor.isStopped()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                visitor.visitDirectoryBeforeVisitingContent(file);
                if (visitor.isStopped()) {
                    return;
                }
                FileUtil.visitDirectory(file, visitor);
                visitor.visitDirectoryAfterVisitingContent(file);
                if (!visitor.isStopped()) continue;
                return;
            }
            visitor.visitFile(file);
            if (!visitor.isStopped()) continue;
            return;
        }
    }

    public static void visitDirectoryAndPrintElapsedTime(File dir, DirectoryVisitor visitor) throws IOException {
        long startMs = System.currentTimeMillis();
        FileUtil.visitDirectory(dir, visitor);
        long stopMs = System.currentTimeMillis();
        System.out.println(Strings.getFirstToken(Strings.getLastToken(visitor.getClass().getName(), '.'), '$') + ": elapsed " + (stopMs - startMs) / 1000L + " seconds");
    }

    @NotNull
    public static byte[] readFileContent(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        long fileLength = file.length();
        if (fileLength > 0x7FFFFFF7L) {
            throw new IOException("File is too big: " + file.getAbsolutePath());
        }
        byte[] byArray = FileUtil.readFileContent(file, (int)fileLength);
        if (byArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return byArray;
    }

    @NotNull
    public static byte[] readFileContent(@NotNull File file, int bytesToRead) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] result = new byte[bytesToRead];
        try (DataInputStream stream = new DataInputStream(new FileInputStream(file));){
            stream.readFully(result);
        }
        if (result == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return result;
    }

    @NotNull
    public static String readFileContentAsUtf8(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] bytes = FileUtil.readFileContent(file);
        String string = Strings.createUtf8String(bytes);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static String readFileContentAsUtf8OrNull(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            return FileUtil.readFileContentAsUtf8(file);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    public static String readTextFileContentAsUtf8(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String result = FileUtil.readFileContentAsUtf8(file);
        String string = Constants.OS_WINDOWS ? Strings.replace(result, "\r\n", "\n") : result;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void readFully(@NotNull Reader reader, @NotNull char[] buffer) throws IOException {
        int count;
        if (reader == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int len = buffer.length;
        for (int n = 0; n < len; n += count) {
            count = reader.read(buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static void readFully(@NotNull InputStream input, @NotNull byte[] buffer) throws IOException {
        int count;
        if (input == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        int len = buffer.length;
        for (int n = 0; n < len; n += count) {
            count = input.read(buffer, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @NotNull
    public static String readFileContentAsAscii(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        byte[] bytes = FileUtil.readFileContent(file);
        StringBuilder builder = new StringBuilder(bytes.length);
        for (byte b : bytes) {
            int bb = b & 0xFF;
            builder.append((char)(bb < 128 ? (int)bb : 32));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void writeFileContent(@NotNull File file, @NotNull byte[] content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            stream.write(content);
        }
    }

    public static void appendFileContent(@NotNull File file, @NotNull byte[] content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file, true));){
            stream.write(content);
        }
    }

    public static void writeFileContentAsUtf8(@NotNull File file, @NotNull String content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.writeFileContent(file, Strings.getUtf8Bytes(content));
    }

    public static void appendFileContentAsUtf8(@NotNull File file, @NotNull String content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.appendFileContent(file, Strings.getUtf8Bytes(content));
    }

    public static void writeTextFileContentAsUtf8(@NotNull File file, @NotNull String content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.writeFileContentAsUtf8(file, Constants.OS_WINDOWS ? Strings.replace(content, "\n", "\r\n") : content);
    }

    public static void appendTextFileContentAsUtf8(@NotNull File file, @NotNull String content) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.appendFileContentAsUtf8(file, Constants.OS_WINDOWS ? Strings.replace(content, "\n", "\r\n") : content);
    }

    public static String[] readFileAsLines(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String s;
            while ((s = reader.readLine()) != null) {
                result.add(s);
            }
        }
        return ArrayUtil.toArray(result);
    }

    public static String[] readStreamAsLines(InputStream stream) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String s;
            while ((s = reader.readLine()) != null) {
                result.add(s);
            }
        }
        return ArrayUtil.toArray(result);
    }

    public static boolean equalPaths(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Constants.OS_WINDOWS) {
            return FileUtil.normalize(file1).equalsIgnoreCase(FileUtil.normalize(file2));
        }
        return FileUtil.normalize(file1).equals(FileUtil.normalize(file2));
    }

    public static void deleteSafe(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        file.delete();
    }

    public static void mkdirsSafe(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        dir.mkdirs();
    }

    public static void deleteTreeSafe(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            FileUtil.visitDirectory(file, new DirectoryVisitorAdapter(){

                @Override
                public void visitFile(@NotNull File f) {
                    if (f == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    FileUtil.deleteSafe(f);
                }

                @Override
                public void visitDirectoryAfterVisitingContent(@NotNull File f) {
                    if (f == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    FileUtil.deleteSafe(f);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FileUtil.deleteSafe(file);
    }

    public static boolean equalBinaryFiles(@NotNull String file1, @NotNull String file2) throws IOException {
        if (file1 == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (new File(file1).length() != new File(file2).length()) {
            return false;
        }
        try (BufferedInputStream s1 = new BufferedInputStream(new FileInputStream(file1));
             DataInputStream s2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));){
            int length;
            byte[] buffer1 = new byte[131072];
            byte[] buffer2 = new byte[buffer1.length];
            while ((length = ((InputStream)s1).read(buffer1)) != -1) {
                s2.readFully(buffer2, 0, length);
                for (int i = 0; i < length; ++i) {
                    if (buffer1[i] == buffer2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    @NotNull
    public static File[] listFilesSafe(@NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        File[] fileArray = Value.notNull(directory.listFiles(), FILE_EMPTY_ARRAY);
        if (fileArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return fileArray;
    }

    public static boolean isAllowedFileNameCharacter(char c) {
        return c >= ' ' && "\\/<>|\":?*".indexOf(c) < 0;
    }

    public static boolean isFileNameValid(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            file.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static Character findFirstNonAllowedFileNameCharacter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (FileUtil.isAllowedFileNameCharacter(ch)) continue;
            return Character.valueOf(ch);
        }
        return null;
    }

    @NotNull
    public static String toFileNamePart(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (FileUtil.isAllowedFileNameCharacter(ch)) {
                result.append(ch);
                continue;
            }
            result.append('-');
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @NotNull String extension) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        Random random = new Random();
        int i = 1;
        while (true) {
            int runningNumber = i < 100 ? i : Math.abs(random.nextInt());
            File f = new File(tmpDir, prefix + runningNumber + extension);
            if (f.createNewFile()) {
                File file = f;
                if (file == null) {
                    throw new IllegalStateException("Method must not return null");
                }
                return file;
            }
            ++i;
        }
    }

    public static boolean canWrite(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Constants.OS_WINDOWS && file.isDirectory()) {
            try {
                FileUtil.deleteSafe(File.createTempFile("yjp_chk_", ".tmp", file));
            }
            catch (IOException ignored) {
                return false;
            }
        }
        return file.canWrite();
    }

    public static class DirectoryVisitorAdapter
    implements DirectoryVisitor {
        private boolean myStopped;

        @Override
        public boolean isStopped() {
            return this.myStopped;
        }

        public final void stopIterations() {
            this.myStopped = true;
        }

        @Override
        public void visitFile(@NotNull File file) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryBeforeVisitingContent(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }

        @Override
        public void visitDirectoryAfterVisitingContent(@NotNull File directory) throws IOException {
            if (directory == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
        }
    }

    public static interface DirectoryVisitor {
        public boolean isStopped();

        public void visitFile(@NotNull File var1) throws IOException;

        public void visitDirectoryBeforeVisitingContent(@NotNull File var1) throws IOException;

        public void visitDirectoryAfterVisitingContent(@NotNull File var1) throws IOException;
    }
}

