/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ElementIterator
implements Iterator<Element>,
Iterable<Element> {
    private int myNextIndex;
    private final NodeList myChildNodes;
    @Nullable
    private final String myNameOfTags;

    public ElementIterator(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this(element, null);
    }

    public ElementIterator(@NotNull Element element, @Nullable String nameOfChildrenTags) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myNameOfTags = nameOfChildrenTags;
        this.myChildNodes = element.getChildNodes();
        this.myNextIndex = 0;
    }

    @Override
    @NotNull
    public Iterator<Element> iterator() {
        ElementIterator elementIterator = this;
        if (elementIterator == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return elementIterator;
    }

    @Override
    public boolean hasNext() {
        int count = this.myChildNodes.getLength();
        while (this.myNextIndex < count) {
            Node node = this.myChildNodes.item(this.myNextIndex);
            if (node instanceof Element && (this.myNameOfTags == null || this.myNameOfTags.equals(((Element)node).getTagName()))) {
                return true;
            }
            ++this.myNextIndex;
        }
        return false;
    }

    @Override
    @NotNull
    public Element next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Element element = (Element)this.myChildNodes.item(this.myNextIndex++);
        if (element == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return element;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getChildCount() {
        int oldNextIndex = this.myNextIndex;
        int count = 0;
        while (this.hasNext()) {
            this.next();
            ++count;
        }
        this.myNextIndex = oldNextIndex;
        return count;
    }

    @Nullable
    public static Element getChild(@NotNull Element element, @NotNull String tagName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        ElementIterator iterator = new ElementIterator(element, tagName);
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Nullable
    public static String getOptionalString(@NotNull Element element, @NotNull String attributeName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Attr node = element.getAttributeNode(attributeName);
        if (node != null) {
            return node.getValue().trim();
        }
        return null;
    }

    public static boolean getBooleanAttribute(@NotNull Element element, @NotNull String attributeName, boolean defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Attr node = element.getAttributeNode(attributeName);
        if (node == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(node.getValue().trim());
    }

    public static int getIntAttribute(@NotNull Element element, @NotNull String attributeName, int defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Attr node = element.getAttributeNode(attributeName);
        if (node == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(node.getValue().trim(), 10);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @NotNull
    public static String getRequiredString(@NotNull Element element, @NotNull String attributeName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String value = ElementIterator.getOptionalString(element, attributeName);
        if (value == null) {
            throw new RuntimeException("attribute required: " + attributeName);
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String writeChildrenToXml(@NotNull Element element) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = ElementIterator.writeChildrenToXml(element, TransformerFactory.newInstance().newTransformer());
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String writeChildrenToXml(@NotNull Element element, @NotNull Transformer transformer) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (transformer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            DOMSource source = new DOMSource(children.item(i));
            transformer.transform(source, result);
            writer.flush();
        }
        String string = writer.toString().trim();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

