/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.runtime;

import com.yourkit.util.Strings;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class Quoter {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String unquote(@NotNull String quotedString) {
        String string;
        if (quotedString == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String prefix = "YJPQUOTED";
        if (!quotedString.startsWith("YJPQUOTED")) {
            string = quotedString;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        String rest = quotedString.substring("YJPQUOTED".length());
        if (rest.length() % 2 != 0) {
            string = quotedString;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        byte[] result = new byte[rest.length() / 2];
        for (int i = 0; i < rest.length() / 2; ++i) {
            int x1 = Quoter.decodeHexChar(rest.charAt(i * 2));
            int x2 = Quoter.decodeHexChar(rest.charAt(i * 2 + 1));
            if (x1 == -1 || x2 == -1) {
                string = quotedString;
                if (string == null) throw new IllegalStateException("Method must not return null");
                return string;
            }
            result[i] = (byte)(x1 * 16 + x2);
        }
        string = Strings.createUtf8String(result);
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    private static int decodeHexChar(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        return -1;
    }

    public static String quote(@NotNull String original) {
        if (original == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!Quoter.containsCharactersToQuote(original)) {
            return original;
        }
        StringBuilder result = new StringBuilder();
        byte[] bytes = Strings.getUtf8Bytes(original);
        result.append("YJPQUOTED");
        for (byte aByte : bytes) {
            String hex = Integer.toString(aByte & 0xFF, 16);
            if (hex.length() == 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    @NotNull
    public static String quote(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = Quoter.quote(file.getAbsolutePath());
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static boolean containsCharactersToQuote(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '.' || ch == '/' || ch == '-' || ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') continue;
            return true;
        }
        return false;
    }
}

