/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.codeinsight.inspections;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.coffeescript.CoffeeScriptUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptArgumentsOutsideFunctionInspection
extends JavaScriptInspection {
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public static boolean argumentsOutsideFunction(JSReferenceExpression node) {
        JSFunction fun;
        return !(node.getParent() instanceof JSCallExpression) && "arguments".equals(node.getText()) && (fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) == null;
    }

    @Nullable
    protected String buildErrorString(Object ... args) {
        return JavaScriptBundle.message((String)"javascript.validation.message.arguments.out.of.function", (Object[])new Object[0]);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            CoffeeScriptArgumentsOutsideFunctionInspection.$$$reportNull$$$0(0);
        }
        return super.isSuppressedFor(element) || CoffeeScriptUtil.isInspectionSuppressedFor(element, this.getID());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/codeinsight/inspections/CoffeeScriptArgumentsOutsideFunctionInspection", "isSuppressedFor"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            if (CoffeeScriptArgumentsOutsideFunctionInspection.argumentsOutsideFunction(node)) {
                this.registerError((PsiElement)node);
            }
        }
    }
}

