/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ObjectNode {
    private static final ObjectNode[] EMPTY_ARRAY = new ObjectNode[0];
    private static final Logger LOG = Logger.getInstance(ObjectNode.class);
    private final ObjectTree myTree;
    private ObjectNode myParent;
    private final Disposable myObject;
    private List<ObjectNode> myChildren;
    private final Throwable myTrace;

    ObjectNode(@NotNull ObjectTree tree, @Nullable ObjectNode parentNode, @NotNull Disposable object) {
        if (tree == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = parentNode == null && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    void addChild(@NotNull ObjectNode child) {
        List<ObjectNode> children;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(2);
        }
        if ((children = this.myChildren) == null) {
            this.myChildren = new SmartList<ObjectNode>(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode child) {
        List<ObjectNode> children;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        if ((children = this.myChildren) != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode node = children.get(i);
                if (!node.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectNode getParent() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            return this.myParent;
        }
    }

    void execute(@NotNull List<? super Throwable> exceptions, boolean onlyChildren) {
        if (exceptions == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        ObjectTree.executeActionWithRecursiveGuard(this, this.myTree.getNodesInExecution(), each -> {
            ObjectNode[] childrenArray;
            if (this.myTree.getDisposalInfo(this.myObject) != null) {
                return;
            }
            if (!onlyChildren && this.myObject instanceof Disposable.Parent) {
                try {
                    ((Disposable.Parent)this.myObject).beforeTreeDispose();
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
            Object object = this.myTree.treeLock;
            synchronized (object) {
                List<ObjectNode> children = this.myChildren;
                childrenArray = children == null || children.isEmpty() ? EMPTY_ARRAY : children.toArray(EMPTY_ARRAY);
                this.myChildren = null;
            }
            for (int i = childrenArray.length - 1; i >= 0; --i) {
                try {
                    ObjectNode childNode = childrenArray[i];
                    childNode.execute(exceptions, false);
                    Object object2 = this.myTree.treeLock;
                    synchronized (object2) {
                        childNode.myParent = null;
                        continue;
                    }
                }
                catch (Throwable e) {
                    exceptions.add(e);
                }
            }
            if (onlyChildren) {
                return;
            }
            try {
                this.myObject.dispose();
                this.myTree.rememberDisposedTrace(this.myObject);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            this.removeFromObjectTree();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromObjectTree() {
        Object object = this.myTree.treeLock;
        synchronized (object) {
            this.myTree.putNode(this.myObject, null);
            if (this.myParent == null) {
                this.myTree.removeRootObject(this.myObject);
            }
        }
    }

    @NotNull
    Disposable getObject() {
        Disposable disposable = this.myObject;
        if (disposable == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        return disposable;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        if (aDisposable == null) {
            ObjectNode.$$$reportNull$$$0(6);
        }
        assert (this.getObject() != aDisposable);
        if (this.myChildren != null) {
            for (ObjectNode node : this.myChildren) {
                node.assertNoReferencesKept(aDisposable);
            }
        }
    }

    <D extends Disposable> D findChildEqualTo(@NotNull D object) {
        List<ObjectNode> children;
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(7);
        }
        if ((children = this.myChildren) != null) {
            for (ObjectNode node : children) {
                Disposable nodeObject = node.getObject();
                if (!nodeObject.equals(object)) continue;
                return (D)nodeObject;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildEqualTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

