/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateKeyStore;
import com.intellij.execution.rmi.ssl.SslSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SslKeyStore
extends DelegateKeyStore {
    private static final String NAME = "idea-key-store";

    public SslKeyStore() {
        super("PKCS12");
    }

    public static void setDefault() {
        System.setProperty("javax.net.ssl.keyStoreType", NAME);
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", SslKeyStore.getDefaultKeyStorePath());
        }
    }

    private void appendUserCert() {
        try {
            X509Certificate cert = SslSocketFactory.readCertificate(System.getProperty("sslClientCertPath"));
            PrivateKey key = SslSocketFactory.readPrivateKey(System.getProperty("sslClientKeyPath"));
            this.delegate.setKeyEntry("user-provided-key", key, null, new Certificate[]{cert});
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.delegate.load(null, null);
        this.appendUserCert();
    }

    static {
        ourProvider.setProperty("KeyStore.idea-key-store", SslKeyStore.class.getName());
    }
}

