/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.settings;

import com.intellij.DynamicBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.settings.CustomDictionariesPanel;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OptionalChooserComponent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class SpellCheckerSettingsPane
implements Disposable {
    public static final int MIN_CORRECTIONS = 1;
    public static final int MAX_CORRECTIONS = 15;
    private JPanel root;
    private JPanel linkContainer;
    private JPanel myPanelForBundledDictionaries;
    private JPanel panelForAcceptedWords;
    private JPanel myPanelForCustomDictionaries;
    private JSpinner myMaxCorrectionsSpinner;
    private JBCheckBox myUseSingleDictionary;
    private ComboBox<String> myDictionariesComboBox;
    private JPanel myAdvancedSettingsPanel;
    private JPanel myAdvancedSettingsPlaceHolder;
    private final CustomDictionariesPanel myDictionariesPanel;
    private final OptionalChooserComponent<String> myProvidedDictionariesChooserComponent;
    private final Set<String> bundledDictionaries;
    private final Set<String> runtimeDictionaries;
    private final List<Pair<String, Boolean>> providedDictionaries;
    private final WordsPanel wordsPanel;
    private final SpellCheckerManager manager;
    private final SpellCheckerSettings settings;
    private final HideableDecorator decorator;

    public SpellCheckerSettingsPane(final SpellCheckerSettings settings, Project project) {
        this.$$$setupUI$$$();
        this.bundledDictionaries = new HashSet<String>();
        this.runtimeDictionaries = new HashSet<String>();
        this.providedDictionaries = new ArrayList<Pair<String, Boolean>>();
        this.settings = settings;
        this.manager = SpellCheckerManager.getInstance(project);
        HyperlinkLabel link = new HyperlinkLabel(SpellCheckerBundle.message("link.to.inspection.settings", new Object[0]));
        link.addHyperlinkListener(e -> {
            ErrorsConfigurable errorsConfigurable;
            Settings allSettings;
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (allSettings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext())) != null && (errorsConfigurable = (ErrorsConfigurable)allSettings.find(ErrorsConfigurable.class)) != null) {
                allSettings.select((Configurable)errorsConfigurable).doWhenDone(() -> errorsConfigurable.selectInspectionTool("SpellCheckingInspection"));
            }
        });
        this.myUseSingleDictionary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpellCheckerSettingsPane.this.myDictionariesComboBox.setEnabled(SpellCheckerSettingsPane.this.myUseSingleDictionary.isSelected());
            }
        });
        this.myMaxCorrectionsSpinner.setModel(new SpinnerNumberModel(1, 1, 15, 1));
        this.myDictionariesComboBox.addItem((Object)SpellCheckerManager.DictionaryLevel.APP.getName());
        this.myDictionariesComboBox.addItem((Object)SpellCheckerManager.DictionaryLevel.PROJECT.getName());
        this.linkContainer.setLayout(new BorderLayout());
        this.linkContainer.add((Component)link);
        this.fillProvidedDictionaries();
        this.myDictionariesPanel = new CustomDictionariesPanel(settings, project, this.manager);
        this.myPanelForCustomDictionaries.setBorder((Border)IdeBorderFactory.createTitledBorder((String)SpellCheckerBundle.message("add.dictionary.description", SpellCheckerSettingsPane.getHunspellDescription()), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myPanelForCustomDictionaries.setLayout(new BorderLayout());
        this.myPanelForCustomDictionaries.add((Component)this.myDictionariesPanel, "Center");
        this.myProvidedDictionariesChooserComponent = new OptionalChooserComponent<String>(this.providedDictionaries){

            public JCheckBox createCheckBox(String path, boolean checked) {
                return new JCheckBox(FileUtil.toSystemDependentName((String)path), checked);
            }

            public void apply() {
                super.apply();
                HashSet<String> bundledDisabledDictionaries = new HashSet<String>();
                HashSet<String> runtimeDisabledDictionaries = new HashSet<String>();
                for (Pair pair : SpellCheckerSettingsPane.this.providedDictionaries) {
                    if (((Boolean)pair.second).booleanValue()) continue;
                    if (SpellCheckerSettingsPane.this.bundledDictionaries.contains(pair.first)) {
                        bundledDisabledDictionaries.add((String)pair.first);
                        continue;
                    }
                    if (!SpellCheckerSettingsPane.this.runtimeDictionaries.contains(pair.first)) continue;
                    runtimeDisabledDictionaries.add((String)pair.first);
                }
                settings.setBundledDisabledDictionariesPaths(bundledDisabledDictionaries);
                settings.setRuntimeDisabledDictionariesNames(runtimeDisabledDictionaries);
            }

            public void reset() {
                super.reset();
                SpellCheckerSettingsPane.this.fillProvidedDictionaries();
            }
        };
        this.myPanelForBundledDictionaries.setBorder((Border)IdeBorderFactory.createTitledBorder((String)SpellCheckerBundle.message("dictionaries.panel.description", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myPanelForBundledDictionaries.setLayout(new BorderLayout());
        this.myPanelForBundledDictionaries.add((Component)this.myProvidedDictionariesChooserComponent.getContentPane(), "Center");
        this.myProvidedDictionariesChooserComponent.getEmptyText().setText(SpellCheckerBundle.message("no.dictionaries", new Object[0]));
        this.wordsPanel = new WordsPanel(this.manager);
        this.panelForAcceptedWords.setLayout(new BorderLayout());
        this.panelForAcceptedWords.add((Component)((Object)this.wordsPanel), "Center");
        this.decorator = new HideableDecorator(this.myAdvancedSettingsPlaceHolder, SpellCheckerBundle.message("advanced.settings", new Object[0]), false);
        this.decorator.setContentComponent((JComponent)this.myAdvancedSettingsPanel);
        this.decorator.setOn(!settings.isDefaultAdvancedSettings());
    }

    private static String getHunspellDescription() {
        PluginId hunspellId = PluginId.getId((String)"hunspell");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)hunspellId);
        if (PluginManagerCore.isPluginInstalled((PluginId)hunspellId) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) {
            return ", " + SpellCheckerBundle.message("hunspell.description", new Object[0]);
        }
        return "";
    }

    public JComponent getPane() {
        return this.root;
    }

    public boolean isModified() {
        return this.wordsPanel.isModified() || this.myProvidedDictionariesChooserComponent.isModified() || this.myDictionariesPanel.isModified() || this.settings.getCorrectionsLimit() != this.getLimit() || this.settings.isUseSingleDictionaryToSave() != this.myUseSingleDictionary.isSelected() || this.settings.isUseSingleDictionaryToSave() && this.settings.getDictionaryToSave() != this.myDictionariesComboBox.getSelectedItem();
    }

    public void apply() throws ConfigurationException {
        if (this.wordsPanel.isModified()) {
            this.manager.updateUserDictionary(this.wordsPanel.getWords());
        }
        if (this.settings.getCorrectionsLimit() != this.getLimit()) {
            this.settings.setCorrectionsLimit(this.getLimit());
        }
        if (this.settings.isUseSingleDictionaryToSave() != this.myUseSingleDictionary.isSelected()) {
            this.settings.setUseSingleDictionaryToSave(this.myUseSingleDictionary.isSelected());
        }
        if (this.myUseSingleDictionary.isSelected() && this.settings.getDictionaryToSave() != this.myDictionariesComboBox.getSelectedItem()) {
            this.settings.setDictionaryToSave((String)this.myDictionariesComboBox.getSelectedItem());
        }
        SpellCheckerManager.restartInspections();
        if (!this.myProvidedDictionariesChooserComponent.isModified() && !this.myDictionariesPanel.isModified()) {
            return;
        }
        this.myProvidedDictionariesChooserComponent.apply();
        this.myDictionariesPanel.apply();
        this.manager.updateBundledDictionaries(this.myDictionariesPanel.getRemovedDictionaries());
    }

    private int getLimit() {
        return ((SpinnerNumberModel)this.myMaxCorrectionsSpinner.getModel()).getNumber().intValue();
    }

    public void reset() {
        this.myMaxCorrectionsSpinner.setValue(this.settings.getCorrectionsLimit());
        this.myUseSingleDictionary.setSelected(this.settings.isUseSingleDictionaryToSave());
        this.myDictionariesComboBox.setSelectedItem((Object)this.settings.getDictionaryToSave());
        this.myDictionariesComboBox.setEnabled(this.myUseSingleDictionary.isSelected());
        this.myDictionariesPanel.reset();
        this.myProvidedDictionariesChooserComponent.reset();
    }

    private void fillProvidedDictionaries() {
        this.providedDictionaries.clear();
        this.bundledDictionaries.clear();
        for (String dictionary : SpellCheckerManager.getBundledDictionaries()) {
            this.bundledDictionaries.add(dictionary);
            this.providedDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)(!this.settings.getBundledDisabledDictionariesPaths().contains(dictionary) ? 1 : 0)));
        }
        this.runtimeDictionaries.clear();
        for (String dictionary : ContainerUtil.map(SpellCheckerManager.getRuntimeDictionaries(), it -> it.getName())) {
            this.runtimeDictionaries.add(dictionary);
            this.providedDictionaries.add((Pair<String, Boolean>)Pair.create((Object)dictionary, (Object)(!this.settings.getRuntimeDisabledDictionariesNames().contains(dictionary) ? 1 : 0)));
        }
    }

    public void dispose() {
        if (this.wordsPanel != null) {
            Disposer.dispose((Disposable)this.wordsPanel);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JSpinner jSpinner;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.root = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.linkContainer = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(24, 38), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel9.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 200), null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/SpellCheckerBundle").getString("settings.tab.dictionaries"), null, jPanel10, null);
        this.myAdvancedSettingsPlaceHolder = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAdvancedSettingsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel4, "Center");
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/SpellCheckerBundle", SpellCheckerSettingsPane.class).getString("max.number.of.corrections"));
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaxCorrectionsSpinner = jSpinner = new JSpinner();
        jPanel4.add((Component)jSpinner, new GridConstraints(1, 1, 1, 2, 8, 2, 2, 0, null, new Dimension(50, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUseSingleDictionary = jBCheckBox = new JBCheckBox();
        jBCheckBox.setName("");
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SpellCheckerBundle", SpellCheckerSettingsPane.class).getString("use.single.dictionary"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDictionariesComboBox = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPanelForBundledDictionaries = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPanelForCustomDictionaries = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/SpellCheckerBundle").getString("settings.tab.accepted.words"), null, jPanel11, null);
        this.panelForAcceptedWords = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor(jSpinner);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class WordsPanel
    extends AddDeleteListPanel<String>
    implements Disposable {
        private final SpellCheckerManager manager;

        private WordsPanel(SpellCheckerManager manager) {
            super(null, ContainerUtil.sorted(manager.getUserDictionaryWords()));
            this.manager = manager;
            this.getEmptyText().setText(SpellCheckerBundle.message("no.words", new Object[0]));
        }

        protected String findItemToAdd() {
            String word = Messages.showInputDialog((String)SpellCheckerBundle.message("enter.simple.word", new Object[0]), (String)SpellCheckerBundle.message("add.new.word", new Object[0]), null);
            if (word == null) {
                return null;
            }
            if (Strings.isMixedCase(word = word.trim())) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.mixed.cased.you.must.enter.simple.word", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            if (!this.manager.hasProblem(word)) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message("entered.word.0.is.correct.you.no.need.to.add.this.in.list", word), (String)SpellCheckerBundle.message("add.new.word", new Object[0]));
                return null;
            }
            return word;
        }

        public void dispose() {
            this.myListModel.removeAllElements();
        }

        @NotNull
        public List<String> getWords() {
            Object[] pairs = this.getListItems();
            if (pairs == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> words = new ArrayList<String>();
            for (Object pair : pairs) {
                words.add(pair.toString());
            }
            ArrayList<String> arrayList = words;
            if (arrayList == null) {
                WordsPanel.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public boolean isModified() {
            List<String> newWords = this.getWords();
            Set<String> words = this.manager.getUserDictionaryWords();
            if (newWords.size() != words.size()) {
                return true;
            }
            return !words.containsAll(newWords) || !newWords.containsAll(words);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/settings/SpellCheckerSettingsPane$WordsPanel", "getWords"));
        }
    }
}

