/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.variables;

import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.variables.JupyterVarsFrameAccessor;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlineCallback;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlinePainterKt;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlineService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0002()B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0012\u0010\u001f\u001a\u00020\u00112\b\u0010 \u001a\u0004\u0018\u00010\u001eH\u0002J\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020\u0011J\b\u0010#\u001a\u00020\u0011H\u0002J\u0006\u0010$\u001a\u00020\u0011J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0006\u0010'\u001a\u00020\u0011R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsToolWindowPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;)V", "clickListener", "Lcom/intellij/ui/ClickListener;", "getNotebookFile", "()Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "variablesView", "Lcom/intellij/xdebugger/impl/frame/XStandaloneVariablesView;", "clearInlineValuesData", "", "jupyterFile", "createActionToolbar", "frameAccessor", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsFrameAccessor;", "createContent", "Lcom/intellij/ui/content/Content;", "dispose", "getData", "", "dataId", "", "getInlineCallback", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/inline/JupyterInlineCallback;", "initVariablesView", "frameVarsCallback", "logViewUsage", "rebuildView", "removeClickListener", "showInitMessage", "showMessage", "text", "showRemoteWarning", "Companion", "RefreshAction", "intellij.python.jupyter"})
public final class JupyterVarsToolWindowPanel
extends SimpleToolWindowPanel
implements Disposable {
    private XStandaloneVariablesView variablesView;
    private ClickListener clickListener;
    @NotNull
    private final Project project;
    @NotNull
    private final NotebookVirtualFile notebookFile;
    private static final String HELP_ID = "tool_window.jupyter_variables";
    public static final Companion Companion = new Companion(null);

    private final void initVariablesView(JupyterInlineCallback frameVarsCallback) {
        this.removeAll();
        JupyterVarsFrameAccessor frameAccessor = new JupyterVarsFrameAccessor(this.project, this.notebookFile, frameVarsCallback);
        PyStackFrame stackFrame = new PyStackFrame(this.project, frameAccessor, new PyStackFrameInfo("", "", "", null), null);
        this.removeClickListener();
        XStandaloneVariablesView xStandaloneVariablesView = this.variablesView = new XStandaloneVariablesView(this.project, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider(), (XStackFrame)stackFrame);
        if (xStandaloneVariablesView != null) {
            XStandaloneVariablesView xStandaloneVariablesView2 = xStandaloneVariablesView;
            boolean bl = false;
            boolean bl2 = false;
            XStandaloneVariablesView it = xStandaloneVariablesView2;
            boolean bl3 = false;
            Disposer.register((Disposable)this, (Disposable)((Disposable)it));
            this.add(it.getPanel(), "Center");
            this.clickListener = new ClickListener(this){
                final /* synthetic */ JupyterVarsToolWindowPanel this$0;
                {
                    this.this$0 = jupyterVarsToolWindowPanel;
                }

                public boolean onClick(@NotNull MouseEvent event2, int clickCount) {
                    Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                    this.this$0.logViewUsage();
                    return false;
                }
            };
            ListenerUtil.addClickListener((Component)it.getPanel(), (ClickListener)this.clickListener);
        }
        this.createActionToolbar(frameAccessor);
        this.validate();
        this.repaint();
    }

    public final void logViewUsage() {
        FUCounterUsageLogger.getInstance().logEvent("jupyter.vars", "jupyter.vars.click", new FeatureUsageData().addProject(this.project));
    }

    private final void removeClickListener() {
        block1: {
            XStandaloneVariablesView xStandaloneVariablesView = this.variablesView;
            if (xStandaloneVariablesView == null) break block1;
            XStandaloneVariablesView xStandaloneVariablesView2 = xStandaloneVariablesView;
            boolean bl = false;
            boolean bl2 = false;
            XStandaloneVariablesView it = xStandaloneVariablesView2;
            boolean bl3 = false;
            ClickListener clickListener = this.clickListener;
            if (clickListener != null) {
                ClickListener clickListener2 = clickListener;
                boolean bl4 = false;
                boolean bl5 = false;
                ClickListener listener2 = clickListener2;
                boolean bl6 = false;
                ListenerUtil.removeClickListener((Component)it.getPanel(), (ClickListener)listener2);
            }
        }
    }

    private final void createActionToolbar(JupyterVarsFrameAccessor frameAccessor) {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JupyterVarsToolWindowPanel", (ActionGroup)toolbarActions, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026\", toolbarActions, false)");
        ActionToolbar actionToolbar2 = actionToolbar;
        this.add(actionToolbar2.getComponent(), "West");
        actionToolbar2.setTargetComponent((JComponent)((Object)this));
        toolbarActions.add((AnAction)new RefreshAction(this));
        DefaultActionGroup settings = new DefaultActionGroup(JupyterBundle.message("jupyter.toolbar.variables.settings.short.name", new Object[0]), true);
        Presentation presentation = settings.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"settings.templatePresentation");
        presentation.setIcon(AllIcons.General.GearPlain);
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        PyVariableViewSettings.VariablesPolicyGroup variablesPolicyGroup = new PyVariableViewSettings.VariablesPolicyGroup();
        variablesPolicyGroup.addValuesPolicyListener(new PyVariableViewSettings.VariablesPolicyGroup.ValuesPolicyListener(frameAccessor){
            final /* synthetic */ JupyterVarsFrameAccessor $frameAccessor;

            public final void valuesPolicyUpdated() {
                this.$frameAccessor.updateLoadingPolicy();
            }
            {
                this.$frameAccessor = jupyterVarsFrameAccessor;
            }
        });
        settings.add((AnAction)variablesPolicyGroup);
        toolbarActions.add((AnAction)settings);
    }

    private final JupyterInlineCallback getInlineCallback(Project project, NotebookVirtualFile jupyterFile) {
        return JupyterInlineService.Companion.getInstance(project).getInlineCallback(jupyterFile);
    }

    private final void clearInlineValuesData(Project project, NotebookVirtualFile jupyterFile) {
        block2: {
            JupyterInlineCallback inlineCallback = this.getInlineCallback(project, jupyterFile);
            PsiFile psiFile = JupyterInlinePainterKt.getJupyterPythonPsiFile(project, jupyterFile.getOriginFile());
            if (!(psiFile instanceof ScopeOwner)) {
                psiFile = null;
            }
            ScopeOwner scopeOwner = (ScopeOwner)psiFile;
            if (scopeOwner == null) break block2;
            ScopeOwner scopeOwner2 = scopeOwner;
            boolean bl = false;
            boolean bl2 = false;
            ScopeOwner scopeOwner3 = scopeOwner2;
            boolean bl3 = false;
            JupyterInlineCallback jupyterInlineCallback = inlineCallback;
            if (jupyterInlineCallback != null) {
                XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
                Intrinsics.checkExpressionValueIsNotNull((Object)xValueChildrenList, (String)"XValueChildrenList.EMPTY");
                jupyterInlineCallback.frameChanged(xValueChildrenList, scopeOwner3);
            }
        }
    }

    private final void showMessage(String text2) {
        this.removeAll();
        JLabel initLabel = new JLabel();
        initLabel.setHorizontalAlignment(0);
        initLabel.setVerticalAlignment(0);
        initLabel.setText(text2);
        this.add(initLabel);
        this.variablesView = null;
        this.clearInlineValuesData(this.project, this.notebookFile);
        this.repaint();
    }

    public final void showInitMessage() {
        this.showMessage("Variables are unavailable while cell is executing");
    }

    public final void showRemoteWarning() {
        this.showMessage("Variables are unavailable for Remote Jupyter Server");
    }

    public final void rebuildView() {
        block1: {
            if (this.variablesView == null) {
                JupyterInlineCallback inlineCallback = this.getInlineCallback(this.project, this.notebookFile);
                this.initVariablesView(inlineCallback);
            }
            XStandaloneVariablesView xStandaloneVariablesView = this.variablesView;
            if (xStandaloneVariablesView == null) break block1;
            xStandaloneVariablesView.rebuildView();
        }
    }

    @NotNull
    public final Content createContent() {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent((JComponent)((Object)this), "Variables: " + this.notebookFile.getName(), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"contentFactory.createCon\u2026 notebookFile.name, true)");
        Content content3 = content2;
        content3.setComponent((JComponent)((Object)this));
        content3.setShouldDisposeContent(true);
        Disposer.register((Disposable)this, (Disposable)((Disposable)content3));
        return content3;
    }

    public void dispose() {
        this.removeClickListener();
        this.clearInlineValuesData(this.project, this.notebookFile);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    public JupyterVarsToolWindowPanel(@NotNull Project project, @NotNull NotebookVirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookFile), (String)"notebookFile");
        super(false);
        this.project = project;
        this.notebookFile = notebookFile;
        this.showInitMessage();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsToolWindowPanel$RefreshAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "view", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsToolWindowPanel;", "(Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsToolWindowPanel;)V", "getView", "()Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsToolWindowPanel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.jupyter"})
    private static final class RefreshAction
    extends AnAction {
        @NotNull
        private final JupyterVarsToolWindowPanel view;

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            JupyterInlineCallback inlineCallback = this.view.getInlineCallback(this.view.getProject(), this.view.getNotebookFile());
            this.view.initVariablesView(inlineCallback);
            this.view.rebuildView();
        }

        @NotNull
        public final JupyterVarsToolWindowPanel getView() {
            return this.view;
        }

        public RefreshAction(@NotNull JupyterVarsToolWindowPanel view) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)view), (String)"view");
            super(JupyterBundle.message("jupyter.refresh.variables.title", new Object[0]), JupyterBundle.message("jupyter.refresh.variables.description", new Object[0]), AllIcons.Actions.Refresh);
            this.view = view;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsToolWindowPanel$Companion;", "", "()V", "HELP_ID", "", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

