/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.variables;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterExecutionException;
import org.jetbrains.plugins.notebooks.jupyter.variables.JupyterVarsCommandExecutor;
import org.jetbrains.plugins.notebooks.jupyter.variables.JupyterVarsFrameExecutorKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u000e2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u001c0\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010!\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsFrameExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;)V", "commandExecutor", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsCommandExecutor;", "getNotebookFile", "()Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "executeCommand", "", "command", "executeCommands", "commands", "", "parseArrayChunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "result", "varName", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "parseAsyncValues", "", "vars", "Lcom/jetbrains/python/debugger/PyFrameAccessor$PyAsyncValue;", "parseFrameVars", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "parentValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "parseVar", "Companion", "intellij.python.jupyter"})
public class JupyterVarsFrameExecutor {
    private final JupyterVarsCommandExecutor commandExecutor;
    @NotNull
    private final Project project;
    @NotNull
    private final NotebookVirtualFile notebookFile;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final String executeCommands(@NotNull List<String> commands) {
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        return this.commandExecutor.executeCommands(this.project, commands, JupyterVarsFrameExecutorKt.findAnyCell(this.notebookFile, this.project));
    }

    @NotNull
    public final String executeCommand(@NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        return this.commandExecutor.executeCommands(this.project, CollectionsKt.listOf((Object)command), JupyterVarsFrameExecutorKt.findAnyCell(this.notebookFile, this.project));
    }

    @Nullable
    public final XValueChildrenList parseFrameVars(@NotNull String result, @Nullable PyDebugValue parentValue, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)frameAccessor, (String)"frameAccessor");
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            LOG.warn("Failed to load Jupyter variables: result is empty");
            return null;
        }
        try {
            List<PyDebugValue> list = ProtocolParser.parseValues(result, frameAccessor);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"ProtocolParser.parseValues(result, frameAccessor)");
            List<PyDebugValue> values = list;
            XValueChildrenList variables = new XValueChildrenList(values.size());
            for (PyDebugValue value2 : values) {
                if (parentValue != null) {
                    PyDebugValue pyDebugValue = value2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDebugValue), (String)"value");
                    pyDebugValue.setParent(parentValue);
                }
                PyDebugValue pyDebugValue = value2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDebugValue), (String)"value");
                pyDebugValue.setFrameAccessor(frameAccessor);
                variables.add(value2.getVisibleName(), (XValue)value2);
            }
            return variables;
        }
        catch (Exception e) {
            LOG.warn("Failed to load Jupyter variables: " + result);
            return null;
        }
    }

    @NotNull
    public final PyDebugValue parseVar(@NotNull String result, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)frameAccessor, (String)"frameAccessor");
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new JupyterExecutionException("Failed to evaluate expression: " + result);
        }
        try {
            PyDebugValue pyDebugValue = ProtocolParser.parseValue(result, frameAccessor);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDebugValue), (String)"ProtocolParser.parseValue(result, frameAccessor)");
            return pyDebugValue;
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Failed to evaluate expression: " + result);
        }
    }

    @NotNull
    public final ArrayChunk parseArrayChunk(@NotNull String result, @NotNull String varName, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)varName, (String)"varName");
        Intrinsics.checkParameterIsNotNull((Object)frameAccessor, (String)"frameAccessor");
        CharSequence charSequence = result;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new JupyterExecutionException("Failed to load variable: " + varName);
        }
        try {
            ArrayChunk arrayChunk = ProtocolParser.parseArrayValues(result, frameAccessor);
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayChunk, (String)"ProtocolParser.parseArra\u2026es(result, frameAccessor)");
            return arrayChunk;
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Failed to load array: " + result);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseAsyncValues(@NotNull String result, @NotNull List<? extends PyFrameAccessor.PyAsyncValue<String>> vars, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        Intrinsics.checkParameterIsNotNull((Object)frameAccessor, (String)"frameAccessor");
        try {
            void var5_7;
            List<PyDebugValue> list = ProtocolParser.parseValues(result, frameAccessor);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"ProtocolParser.parseValues(result, frameAccessor)");
            List<PyDebugValue> debugValues = list;
            boolean n = false;
            int n2 = ((Collection)debugValues).size();
            while (var5_7 < n2) {
                PyDebugValue resultValue = debugValues.get((int)var5_7);
                PyDebugCallback<String> pyDebugCallback = vars.get((int)var5_7).getCallback();
                PyDebugValue pyDebugValue = resultValue;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDebugValue), (String)"resultValue");
                pyDebugCallback.ok(pyDebugValue.getValue());
                ++var5_7;
            }
        }
        catch (Exception e) {
            for (PyFrameAccessor.PyAsyncValue<String> pyAsyncValue : vars) {
                pyAsyncValue.getCallback().error(new PyDebuggerException(result));
            }
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    public JupyterVarsFrameExecutor(@NotNull Project project, @NotNull NotebookVirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookFile), (String)"notebookFile");
        this.project = project;
        this.notebookFile = notebookFile;
        this.commandExecutor = JupyterVarsCommandExecutor.Companion.getInstance(this.project);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/JupyterVarsFrameExecutor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

