/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.psi;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterLanguage;
import org.jetbrains.plugins.notebooks.jupyter.lexer.JupyterTemplateLexer;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterTemplateTypes;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterTemplateDataElementType;", "Lcom/intellij/psi/templateLanguages/TemplateDataElementType;", "debugName", "", "templateElementType", "Lcom/intellij/psi/tree/IElementType;", "(Ljava/lang/String;Lcom/intellij/psi/tree/IElementType;)V", "createTemplateFile", "Lcom/intellij/psi/PsiFile;", "psiFile", "templateLanguage", "Lcom/intellij/lang/Language;", "sourceCode", "", "viewProvider", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "rangeCollector", "Lcom/intellij/psi/templateLanguages/TemplateDataElementType$RangeCollector;", "intellij.python.jupyter"})
public abstract class JupyterTemplateDataElementType
extends TemplateDataElementType {
    @NotNull
    protected PsiFile createTemplateFile(@NotNull PsiFile psiFile, @Nullable Language templateLanguage, @NotNull CharSequence sourceCode, @Nullable TemplateLanguageFileViewProvider viewProvider, @NotNull TemplateDataElementType.RangeCollector rangeCollector) {
        VirtualFile originalFile;
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkParameterIsNotNull((Object)rangeCollector, (String)"rangeCollector");
        JupyterTemplateLexer lexer = new JupyterTemplateLexer();
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"psiFile.viewProvider");
        VirtualFile virtualFile2 = fileViewProvider.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"psiFile.viewProvider.virtualFile");
        VirtualFile jupyterFile = virtualFile2;
        if (jupyterFile instanceof NotebookVirtualFile) {
            lexer.setNotebook(((NotebookVirtualFile)jupyterFile).getNotebook());
        } else if (jupyterFile instanceof LightVirtualFile && ((LightVirtualFile)jupyterFile).getOriginalFile() instanceof NotebookVirtualFile && (originalFile = ((LightVirtualFile)jupyterFile).getOriginalFile()) instanceof NotebookVirtualFile) {
            lexer.setNotebook(((NotebookVirtualFile)originalFile).getNotebook());
        }
        CharSequence templateSourceCode = this.createTemplateText(sourceCode, (Lexer)lexer, rangeCollector);
        PsiFile psiFile2 = this.createPsiFileFromSource(templateLanguage, templateSourceCode, psiFile.getManager());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"createPsiFileFromSource(\u2026rceCode, psiFile.manager)");
        return psiFile2;
    }

    public JupyterTemplateDataElementType(@NotNull String debugName, @NotNull IElementType templateElementType) {
        Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
        Intrinsics.checkParameterIsNotNull((Object)templateElementType, (String)"templateElementType");
        super(debugName, (Language)JupyterLanguage.INSTANCE, templateElementType, JupyterTemplateTypes.OUTER);
    }
}

