/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor.preview;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterCustomizer;
import org.jetbrains.plugins.notebooks.jupyter.JupyterMessagingApiKt;
import org.jetbrains.plugins.notebooks.jupyter.JupyterWebFrontEndApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallback;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.editor.IndexedCell;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.colors.JupyterColorsKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterJSOutputConsole;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanel;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanel$onUIInitialized$;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanelController;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanelView;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterEvent;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.server.ui.JupyterServerToolWindowKt;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;
import org.jetbrains.plugins.notebooks.jupyter.trust.JupyterTrustManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 X2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001XB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010+\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u00102\u001a\u00020*H\u0016J(\u00103\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020,2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u000200H\u0002J\b\u00104\u001a\u000205H\u0016J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00108\u001a\u00020\rH\u0002J\u0018\u00109\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010:\u001a\u000207H\u0002J\u0010\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u000205H\u0016J\u0018\u0010=\u001a\u00020*2\u0006\u00108\u001a\u00020\r2\u0006\u0010>\u001a\u00020\rH\u0016J\u0010\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020\u001dH\u0016J\b\u0010A\u001a\u00020*H\u0016J\u0010\u0010B\u001a\u00020*2\u0006\u0010C\u001a\u000205H\u0016J\u0018\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u000205H\u0016J \u0010G\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010H\u001a\u00020IH\u0002J(\u0010J\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00108\u001a\u00020\r2\u0006\u0010>\u001a\u00020\rH\u0002J \u0010K\u001a\u00020*2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010L\u001a\u00020M2\u0006\u0010>\u001a\u00020\rH\u0002J\u0010\u0010N\u001a\u00020*2\u0006\u0010F\u001a\u00020OH\u0016J.\u0010P\u001a\u0004\u0018\u0001052\u0006\u0010Q\u001a\u0002052\b\u0010R\u001a\u0004\u0018\u0001052\u0006\u0010S\u001a\u0002052\b\u0010T\u001a\u0004\u0018\u000105H\u0016J\u0010\u0010!\u001a\u00020*2\u0006\u0010U\u001a\u00020VH\u0002J\b\u0010W\u001a\u00020*H\u0002R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanel;", "Lorg/jetbrains/plugins/notebooks/jupyter/JupyterWebFrontEndApi;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanelController;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "notebookFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;)V", "createCellCallback", "Lkotlin/Function1;", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "isNotebookTrusted", "", "()Z", "jComponent", "Ljavax/swing/JComponent;", "getJComponent", "()Ljavax/swing/JComponent;", "notebook", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "getNotebook", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "", "scale", "getScale", "()D", "setScale", "(D)V", "scaleFactor", "", "getScaleFactor", "()F", "view", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanelView;", "addCaretListener", "", "addMarkInGutter", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "endOffset", "color", "Ljava/awt/Color;", "addScrollingListener", "dispose", "fillCellArea", "getCssUri", "", "getIndexedCell", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/IndexedCell;", "cellIndex", "highlightCell", "indexedCell", "onAlert", "text", "onFocusChanged", "cellDistanceFromTheTop", "onScaleChanged", "deltaY", "onUIInitialized", "openUrl", "url", "printToConsole", "highSeverity", "message", "scrollPreview", "caretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "scrollSourceEditor", "scrollToCell", "psiCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "sendMessageToFrontEnd", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "sendMessageToKernel", "commId", "messageType", "data", "cellId", "jupyterSettings", "Lorg/jetbrains/plugins/notebooks/jupyter/settings/JupyterSettings;", "subscribeToEditorColorManager", "Companion", "intellij.python.jupyter"})
public final class JupyterPreviewHtmlPanel
implements JupyterWebFrontEndApi,
Disposable,
JupyterPreviewHtmlPanelController {
    private final JupyterPreviewHtmlPanelView view;
    private final Function1<Integer, JupyterCellExecutionCallback> createCellCallback;
    @NotNull
    private final Project project;
    private final TextEditor editor;
    private final NotebookVirtualFile notebookFile;
    @NotNull
    private static final Logger LOG;
    private static final double BASE_FONT_SIZE = 12.0;
    public static final Companion Companion;

    @NotNull
    public final JComponent getJComponent() {
        return this.view.getComponent();
    }

    @Override
    public void onUIInitialized() {
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public final void run() {
                JupyterPreviewHtmlPanel.access$setScale(this.this$0, JupyterSettings.Companion.getInstance());
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }
        });
        this.notebookFile.getNotebook().addJupyterChangeListener(new JupyterChangeListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public void onEvent(@NotNull JupyterEvent event2) {
                Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                JupyterPreviewHtmlPanel.access$getView$p(this.this$0).onNotebookChanged(event2);
            }
            {
                this.this$0 = $outer;
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        boolean bl2 = false;
        MessageBusConnection $this$apply = messageBusConnection;
        boolean bl3 = false;
        $this$apply.subscribe(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC(), (Object)new JupyterSettingsChangeListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }

            public void settingsChanged(@NotNull JupyterSettings before, @NotNull JupyterSettings after) {
                Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
                Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
                ApplicationManager.getApplication().invokeLater(new Runnable(this, after, before){
                    final /* synthetic */ onUIInitialized$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ JupyterSettings $after;
                    final /* synthetic */ JupyterSettings $before;
                    {
                        this.this$0 = var1_1;
                        this.$after = jupyterSettings;
                        this.$before = jupyterSettings2;
                    }

                    public final void run() {
                        JupyterPreviewHtmlPanel.access$getView$p(this.this$0.this$0).onSettingsChanged(this.$after);
                        DaemonCodeAnalyzer.getInstance((Project)this.this$0.this$0.getProject()).restart();
                        if (this.$before.getUseEditorFontSize() != this.$after.getUseEditorFontSize() || this.$before.getPreviewFontSize() != this.$after.getPreviewFontSize()) {
                            JupyterPreviewHtmlPanel.access$setScale(this.this$0.this$0, JupyterSettings.Companion.getInstance());
                        }
                    }
                });
            }
        });
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        messageBusConnection = application2.getMessageBus().connect((Disposable)this);
        bl = false;
        bl2 = false;
        $this$apply = messageBusConnection;
        boolean bl4 = false;
        $this$apply.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ onUIInitialized$$inlined$apply$lambda$2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        JupyterPreviewHtmlPanel.access$getView$p(this.this$0.this$0).onSettingsChanged(JupyterSettings.Companion.getInstance());
                        if (JupyterSettings.Companion.getInstance().getUseEditorFontSize()) {
                            JupyterPreviewHtmlPanel.access$setScale(this.this$0.this$0, JupyterSettings.Companion.getInstance());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void sendMessageToFrontEnd(@NotNull JupyterMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.view.sendMessageToFrontEnd(message);
    }

    @Override
    public boolean isNotebookTrusted() {
        JupyterTrustManager jupyterTrustManager = JupyterTrustManager.Companion.getTrustManager(this.project);
        String string = this.notebookFile.getOriginFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"notebookFile.originFile.path");
        JupyterTrustManager.FileSpecificView fileSpecificView = jupyterTrustManager.asFileSpecificView(string);
        return fileSpecificView != null && fileSpecificView.getTrusted();
    }

    @Override
    @NotNull
    public JupyterNotebook getNotebook() {
        return this.notebookFile.getNotebook();
    }

    @Override
    public void printToConsole(boolean highSeverity, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ApplicationManager.getApplication().invokeLater(new Runnable(this, message, highSeverity){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ String $message;
            final /* synthetic */ boolean $highSeverity;

            public final void run() {
                JupyterJSOutputConsole jupyterJSOutputConsole = JupyterJSOutputConsole.Companion.getConsoleIfEnabled(this.this$0.getProject());
                if (jupyterJSOutputConsole != null) {
                    jupyterJSOutputConsole.print(this.$message);
                }
                if (this.$highSeverity) {
                    Logger.getInstance(JupyterPreviewHtmlPanel.class).warn(this.$message);
                    String firstLine = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.$message, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null));
                    CharSequence charSequence = firstLine;
                    boolean bl = false;
                    if (!StringsKt.isBlank((CharSequence)charSequence)) {
                        JupyterServerToolWindowKt.createJupyterNotification("Jupyter Javascript: " + firstLine).notify(this.this$0.getProject());
                    }
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$message = string;
                this.$highSeverity = bl;
            }
        });
    }

    @Override
    public void openUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        BrowserUtil.browse((String)url);
    }

    @Override
    public void onFocusChanged(int cellIndex, int cellDistanceFromTheTop) {
        ApplicationManager.getApplication().invokeLater(new Runnable(this, cellIndex, cellDistanceFromTheTop){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ int $cellIndex;
            final /* synthetic */ int $cellDistanceFromTheTop;

            public final void run() {
                JupyterPreviewHtmlPanel.access$scrollSourceEditor(this.this$0, this.this$0.getProject(), JupyterPreviewHtmlPanel.access$getEditor$p(this.this$0), this.$cellIndex, this.$cellDistanceFromTheTop);
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$cellIndex = n;
                this.$cellDistanceFromTheTop = n2;
            }
        });
    }

    @Override
    @Nullable
    public String sendMessageToKernel(@NotNull String commId, @Nullable String messageType, @NotNull String data, @Nullable String cellId) {
        JupyterCellExecutionCallback jupyterCellExecutionCallback;
        JupyterCellExecutionManager executionManager;
        Intrinsics.checkParameterIsNotNull((Object)commId, (String)"commId");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(this.project).getSession(this.notebookFile);
        if (jupyterNotebookSession == null) {
            return null;
        }
        JupyterNotebookSession session = jupyterNotebookSession;
        JsonNode dataAsJson = JupyterJsonKt.getJackson().readTree(data);
        String string = messageType;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        JsonNode jsonNode = dataAsJson;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"dataAsJson");
        JupyterMessage message = JupyterMessagingApiKt.buildCommMessage(session, commId, string, jsonNode);
        JupyterCellExecutionManager jupyterCellExecutionManager = executionManager = JupyterCellExecutionManager.Companion.getInstance(this.project);
        JupyterNotebookSession jupyterNotebookSession2 = session;
        JupyterMessage jupyterMessage = message;
        Object object = cellId;
        if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
            Object object2 = object;
            JupyterMessage jupyterMessage2 = jupyterMessage;
            JupyterNotebookSession jupyterNotebookSession3 = jupyterNotebookSession2;
            JupyterCellExecutionManager jupyterCellExecutionManager2 = jupyterCellExecutionManager;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)object2).intValue();
            boolean bl3 = false;
            JupyterCellExecutionCallback jupyterCellExecutionCallback2 = (JupyterCellExecutionCallback)this.createCellCallback.invoke((Object)it);
            jupyterCellExecutionManager = jupyterCellExecutionManager2;
            jupyterNotebookSession2 = jupyterNotebookSession3;
            jupyterMessage = jupyterMessage2;
            jupyterCellExecutionCallback = jupyterCellExecutionCallback2;
        } else {
            jupyterCellExecutionCallback = null;
        }
        return jupyterCellExecutionManager.sendMessageToKernel(jupyterNotebookSession2, jupyterMessage, jupyterCellExecutionCallback);
    }

    @Override
    public void onAlert(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        SwingUtilities.invokeLater(new Runnable(text2){
            final /* synthetic */ String $text;

            public final void run() {
                JOptionPane.showMessageDialog(null, this.$text);
            }
            {
                this.$text = string;
            }
        });
    }

    @Override
    public void onScaleChanged(double deltaY) {
        ApplicationManager.getApplication().invokeLater(new Runnable(this, deltaY){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ double $deltaY;

            public final void run() {
                Editor editor2 = JupyterPreviewHtmlPanel.access$getEditor$p(this.this$0).getEditor();
                if (editor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                }
                EditorImpl editor3 = (EditorImpl)editor2;
                EditorSettings editorSettings = editor3.getSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"editor.settings");
                if (editorSettings.isWheelFontChangeEnabled()) {
                    JupyterPreviewHtmlPanel jupyterPreviewHtmlPanel = this.this$0;
                    double d = this.$deltaY;
                    double d2 = jupyterPreviewHtmlPanel.getScale();
                    JupyterPreviewHtmlPanel jupyterPreviewHtmlPanel2 = jupyterPreviewHtmlPanel;
                    boolean bl = false;
                    double d3 = Math.signum(d);
                    jupyterPreviewHtmlPanel2.setScale(d2 + d3);
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$deltaY = d;
            }
        });
    }

    public final double getScale() {
        return this.view.getScale() * 12.0;
    }

    public final void setScale(double value2) {
        this.view.setScale(value2 / 12.0);
    }

    private final float getScaleFactor() {
        return UISettings.Companion.getInstance().getPresentationMode() ? JBUIScale.getFontScale((float)UISettings.Companion.getInstance().getPresentationModeFontSize()) : 1.0f;
    }

    private final void subscribeToEditorColorManager() {
        this.project.getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                block0: {
                    Project project = this.this$0.getProject();
                    TextEditor textEditor = JupyterPreviewHtmlPanel.access$getEditor$p(this.this$0);
                    Editor editor2 = JupyterPreviewHtmlPanel.access$getEditor$p(this.this$0).getEditor();
                    Editor editor3 = JupyterPreviewHtmlPanel.access$getEditor$p(this.this$0).getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
                    CaretModel caretModel = editor3.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.editor.caretModel");
                    Caret caret = caretModel.getPrimaryCaret();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"editor.editor.caretModel.primaryCaret");
                    IndexedCell indexedCell = JupyterCellUtilKt.getIndexedJupyterCellByOffset(project, textEditor, editor2.logicalPositionToOffset(caret.getLogicalPosition()));
                    if (indexedCell == null) break block0;
                    IndexedCell indexedCell2 = indexedCell;
                    boolean bl = false;
                    boolean bl2 = false;
                    IndexedCell it2 = indexedCell2;
                    boolean bl3 = false;
                    JupyterPreviewHtmlPanel.access$highlightCell(this.this$0, JupyterPreviewHtmlPanel.access$getEditor$p(this.this$0), it2);
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }
        });
    }

    @Override
    @NotNull
    public String getCssUri() {
        return UIUtil.isUnderDarcula() ? "/css/jupyter_darcula.css" : "/css/jupyter_intellij.css";
    }

    private final void setScale(JupyterSettings jupyterSettings) {
        int n;
        if (jupyterSettings.getUseEditorFontSize()) {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            FontPreferences fontPreferences = appEditorFontOptions.getFontPreferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)fontPreferences, (String)"AppEditorFontOptions.getInstance().fontPreferences");
            FontPreferences fontPreferences2 = fontPreferences;
            n = fontPreferences2.getSize(fontPreferences2.getFontFamily());
        } else {
            n = jupyterSettings.getPreviewFontSize();
        }
        int configuredFontSize = n;
        this.setScale(configuredFontSize);
    }

    private final void addCaretListener(TextEditor editor2) {
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        editor3.getCaretModel().addCaretListener(new CaretListener(this, editor2){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;

            public void caretPositionChanged(@NotNull CaretEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Editor editor2 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                CaretModel caretModel = editor2.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.editor.caretModel");
                if (Intrinsics.areEqual((Object)caretModel.getPrimaryCaret(), (Object)e.getCaret()) ^ true) {
                    return;
                }
                LogicalPosition position = new LogicalPosition(e.getNewPosition().line, e.getNewPosition().column);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.this$0.getProject());
                Editor editor3 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
                psiDocumentManager.performForCommittedDocument(editor3.getDocument(), new Runnable(this, position){
                    final /* synthetic */ addCaretListener.1 this$0;
                    final /* synthetic */ LogicalPosition $position;

                    public final void run() {
                        block1: {
                            Editor editor2 = this.this$0.$editor.getEditor();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                            if (editor2.isDisposed()) {
                                return;
                            }
                            IndexedCell indexedCell = JupyterCellUtilKt.getIndexedJupyterCellByOffset(this.this$0.this$0.getProject(), this.this$0.$editor, this.this$0.$editor.getEditor().logicalPositionToOffset(this.$position));
                            if (indexedCell == null) break block1;
                            IndexedCell indexedCell2 = indexedCell;
                            boolean bl = false;
                            boolean bl2 = false;
                            IndexedCell it = indexedCell2;
                            boolean bl3 = false;
                            JupyterPreviewHtmlPanel.access$highlightCell(this.this$0.this$0, this.this$0.$editor, it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$position = logicalPosition;
                    }
                });
                Project project = this.this$0.getProject();
                LogicalPosition logicalPosition = e.getNewPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"e.newPosition");
                JupyterPreviewHtmlPanel.access$scrollPreview(this.this$0, project, this.$editor, logicalPosition);
            }
            {
                this.this$0 = $outer;
                this.$editor = $captured_local_variable$1;
            }
        }, (Disposable)this);
    }

    private final void addScrollingListener(TextEditor editor2) {
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        editor3.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(this, editor2){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;

            public final void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Editor editor2 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                if (editor2.isDisposed()) {
                    return;
                }
                Editor editor3 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
                JComponent jComponent = editor3.getContentComponent();
                Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.editor.contentComponent");
                if (jComponent.isFocusOwner()) {
                    Project project = this.this$0.getProject();
                    Editor editor4 = e.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"e.editor");
                    CaretModel caretModel = editor4.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"e.editor.caretModel");
                    Caret caret = caretModel.getCurrentCaret();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"e.editor.caretModel.currentCaret");
                    LogicalPosition logicalPosition = caret.getLogicalPosition();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"e.editor.caretModel.currentCaret.logicalPosition");
                    JupyterPreviewHtmlPanel.access$scrollPreview(this.this$0, project, this.$editor, logicalPosition);
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$editor = textEditor;
            }
        });
    }

    private final void scrollPreview(Project project, TextEditor editor2, LogicalPosition caretPosition) {
        int offset = editor2.getEditor().logicalPositionToOffset(caretPosition);
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        ScrollingModel scrollingModel = editor3.getScrollingModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)scrollingModel, (String)"editor.editor.scrollingModel");
        Rectangle rectangle = scrollingModel.getVisibleArea();
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"editor.editor.scrollingModel.visibleArea");
        int editorY = rectangle.getLocation().y;
        VirtualFile virtualFile2 = editor2.getFile();
        if (virtualFile2 == null) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Editor editor4 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"editor.editor");
        psiDocumentManager.performForCommittedDocument(editor4.getDocument(), new Runnable(this, editor2, project, offset, editorY){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $editorY;

            public final void run() {
                block1: {
                    Editor editor2 = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                    if (editor2.isDisposed()) {
                        return;
                    }
                    IndexedCell indexedCell = JupyterCellUtilKt.getIndexedJupyterCellByOffset(this.$project, this.$editor, this.$offset);
                    if (indexedCell == null) break block1;
                    IndexedCell indexedCell2 = indexedCell;
                    boolean bl = false;
                    boolean bl2 = false;
                    IndexedCell it = indexedCell2;
                    boolean bl3 = false;
                    int activeCellOffset = it.getCell().getTextOffset();
                    int cellY = this.$editor.getEditor().offsetToXY((int)activeCellOffset).y - this.$editorY;
                    JupyterPreviewHtmlPanel.access$getView$p(this.this$0).scrollPreview(it.getCellIndex(), (int)((float)cellY / JupyterPreviewHtmlPanel.access$getScaleFactor$p(this.this$0)));
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$editor = textEditor;
                this.$project = project;
                this.$offset = n;
                this.$editorY = n2;
            }
        });
    }

    private final void scrollSourceEditor(Project project, TextEditor editor2, int cellIndex, int cellDistanceFromTheTop) {
        ApplicationManager.getApplication().invokeLater(new Runnable(this, editor2, project, cellIndex, cellDistanceFromTheTop){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $cellIndex;
            final /* synthetic */ int $cellDistanceFromTheTop;

            public final void run() {
                block3: {
                    Editor editor2 = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                    if (editor2.isDisposed()) {
                        return;
                    }
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.$project);
                    Editor editor3 = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
                    if (!psiDocumentManager.isCommitted(editor3.getDocument())) {
                        return;
                    }
                    IndexedCell indexedCell = JupyterPreviewHtmlPanel.access$getIndexedCell(this.this$0, this.$project, this.$editor, this.$cellIndex);
                    if (indexedCell == null) break block3;
                    IndexedCell indexedCell2 = indexedCell;
                    boolean bl = false;
                    boolean bl2 = false;
                    IndexedCell it = indexedCell2;
                    boolean bl3 = false;
                    JupyterPreviewHtmlPanel.access$highlightCell(this.this$0, this.$editor, it);
                    if (JupyterSettings.Companion.getInstance().getAutoscrollToSource()) {
                        JupyterPreviewHtmlPanel.access$scrollToCell(this.this$0, this.$editor, it.getCell(), (int)((float)this.$cellDistanceFromTheTop * JupyterPreviewHtmlPanel.access$getScaleFactor$p(this.this$0)));
                    }
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$editor = textEditor;
                this.$project = project;
                this.$cellIndex = n;
                this.$cellDistanceFromTheTop = n2;
            }
        });
    }

    private final IndexedCell getIndexedCell(Project project, TextEditor editor2, int cellIndex) {
        List<JupyterCell> psiCells = JupyterCellUtilKt.getCells(project, editor2);
        if (psiCells == null) {
            return null;
        }
        return new IndexedCell(cellIndex, psiCells.get(cellIndex), cellIndex == psiCells.size() - 1);
    }

    private final void scrollToCell(TextEditor editor2, JupyterCell psiCell, int cellDistanceFromTheTop) {
        int cellY = editor2.getEditor().offsetToXY((int)psiCell.getTextOffset()).y;
        Editor editor3 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        editor3.getScrollingModel().scrollVertically(cellY - cellDistanceFromTheTop);
    }

    private final void highlightCell(TextEditor editor2, IndexedCell indexedCell) {
        TextRange textRange = indexedCell.getCell().getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"indexedCell.cell.textRange");
        int startOffset = textRange.getStartOffset();
        TextRange textRange2 = indexedCell.getCell().getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"indexedCell.cell.textRange");
        int endOffset = textRange2.getEndOffset() - 1;
        Editor editor3 = editor2.getEditor();
        boolean bl = false;
        boolean bl2 = false;
        Editor it = editor3;
        boolean bl3 = false;
        Editor editor4 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"it");
        editor4.getMarkupModel().removeAllHighlighters();
        Editor editor5 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor5, (String)"editor.editor");
        TextAttributes textAttributes = editor5.getColorsScheme().getAttributes(JupyterColorsKt.getSELECTED_CELL());
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"editor.editor.colorsSche\u2026s(\n        SELECTED_CELL)");
        Color foregroundColor = textAttributes.getForegroundColor();
        Editor editor6 = editor2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor6, (String)"editor.editor");
        TextAttributes textAttributes2 = editor6.getColorsScheme().getAttributes(JupyterColorsKt.getSELECTED_CELL());
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes2, (String)"editor.editor.colorsSche\u2026s(\n        SELECTED_CELL)");
        Color backgroundColor = textAttributes2.getBackgroundColor();
        if (backgroundColor != null && JupyterSettings.Companion.getInstance().getFillSelectedCellInSourceView()) {
            this.fillCellArea(it, startOffset, endOffset, backgroundColor);
        }
        if (foregroundColor != null && JupyterSettings.Companion.getInstance().getAddGutterMarkForSelectedCellInSourceView()) {
            this.addMarkInGutter(it, startOffset, endOffset, foregroundColor);
        }
    }

    private final void fillCellArea(Editor editor2, int startOffset, int endOffset, Color color) {
        editor2.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 3001, new TextAttributes(null, color, null, EffectType.ROUNDED_BOX, 0), HighlighterTargetArea.LINES_IN_RANGE);
    }

    private final void addMarkInGutter(Editor editor2, int startOffset, int endOffset, Color color) {
        int deepness = 0;
        int thickness = 1;
        RangeHighlighter rangeHighlighter = editor2.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        boolean bl = false;
        boolean bl2 = false;
        RangeHighlighter $this$apply = rangeHighlighter;
        boolean bl3 = false;
        $this$apply.setLineMarkerRenderer(new LineMarkerRenderer(color, thickness, deepness){
            final /* synthetic */ Color $color$inlined;
            final /* synthetic */ int $thickness$inlined;
            final /* synthetic */ int $deepness$inlined;
            {
                this.$color$inlined = color;
                this.$thickness$inlined = n;
                this.$deepness$inlined = n2;
            }

            public final void paint(Editor $noName_0, Graphics g, Rectangle r) {
                Graphics graphics = g;
                Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"g");
                graphics.setColor(this.$color$inlined);
                g.fillRect(r.x, r.y, this.$thickness$inlined, r.height);
                g.fillRect(r.x + this.$thickness$inlined, r.y, this.$deepness$inlined, this.$thickness$inlined);
                g.fillRect(r.x + this.$thickness$inlined, r.y + r.height - this.$thickness$inlined, this.$deepness$inlined, this.$thickness$inlined);
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public JupyterPreviewHtmlPanel(@NotNull Project project, @NotNull TextEditor editor2, @NotNull NotebookVirtualFile notebookFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookFile), (String)"notebookFile");
        this.project = project;
        this.editor = editor2;
        this.notebookFile = notebookFile;
        this.view = JupyterCustomizer.Companion.getInstance().createHtmlPanelView(this);
        Disposer.register((Disposable)this, (Disposable)this.view);
        if (UIUtil.isUnderDarcula()) {
            this.view.setBackground(new Color(0x2B2B2B));
        }
        TextEditor textEditor = this.editor;
        boolean bl = false;
        boolean bl2 = false;
        TextEditor it = textEditor;
        boolean bl3 = false;
        this.addCaretListener(it);
        this.addScrollingListener(it);
        this.subscribeToEditorColorManager();
        this.createCellCallback = (Function1)new Function1<Integer, JupyterCellExecutionCallback>(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            @Nullable
            public final JupyterCellExecutionCallback invoke(int cellId) {
                return (JupyterCellExecutionCallback)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(this, cellId){
                    final /* synthetic */ createCellCallback.1 this$0;
                    final /* synthetic */ int $cellId;

                    @Nullable
                    public final JupyterCellExecutionCallback compute() {
                        JupyterCellExecutionCallback jupyterCellExecutionCallback;
                        List<JupyterCell> list = JupyterCellUtilKt.getCells(this.this$0.this$0.getProject(), JupyterPreviewHtmlPanel.access$getNotebookFile$p(this.this$0.this$0));
                        if (list != null && (list = (JupyterCell)CollectionsKt.getOrNull(list, (int)this.$cellId)) != null) {
                            List<JupyterCell> list2 = list;
                            boolean bl = false;
                            boolean bl2 = false;
                            List<JupyterCell> cell = list2;
                            boolean bl3 = false;
                            jupyterCellExecutionCallback = JupyterCellExecutionManager.Companion.getInstance(this.this$0.this$0.getProject()).createCellExecutionCallback((JupyterCell)((Object)cell));
                        } else {
                            jupyterCellExecutionCallback = null;
                        }
                        return jupyterCellExecutionCallback;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$cellId = n;
                    }
                }));
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                super(1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setScale(JupyterPreviewHtmlPanel $this, JupyterSettings jupyterSettings) {
        $this.setScale(jupyterSettings);
    }

    public static final /* synthetic */ JupyterPreviewHtmlPanelView access$getView$p(JupyterPreviewHtmlPanel $this) {
        return $this.view;
    }

    public static final /* synthetic */ void access$scrollSourceEditor(JupyterPreviewHtmlPanel $this, Project project, TextEditor editor2, int cellIndex, int cellDistanceFromTheTop) {
        $this.scrollSourceEditor(project, editor2, cellIndex, cellDistanceFromTheTop);
    }

    public static final /* synthetic */ TextEditor access$getEditor$p(JupyterPreviewHtmlPanel $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$highlightCell(JupyterPreviewHtmlPanel $this, TextEditor editor2, IndexedCell indexedCell) {
        $this.highlightCell(editor2, indexedCell);
    }

    public static final /* synthetic */ void access$scrollPreview(JupyterPreviewHtmlPanel $this, Project project, TextEditor editor2, LogicalPosition caretPosition) {
        $this.scrollPreview(project, editor2, caretPosition);
    }

    public static final /* synthetic */ float access$getScaleFactor$p(JupyterPreviewHtmlPanel $this) {
        return $this.getScaleFactor();
    }

    public static final /* synthetic */ IndexedCell access$getIndexedCell(JupyterPreviewHtmlPanel $this, Project project, TextEditor editor2, int cellIndex) {
        return $this.getIndexedCell(project, editor2, cellIndex);
    }

    public static final /* synthetic */ void access$scrollToCell(JupyterPreviewHtmlPanel $this, TextEditor editor2, JupyterCell psiCell, int cellDistanceFromTheTop) {
        $this.scrollToCell(editor2, psiCell, cellDistanceFromTheTop);
    }

    public static final /* synthetic */ NotebookVirtualFile access$getNotebookFile$p(JupyterPreviewHtmlPanel $this) {
        return $this.notebookFile;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanel$Companion;", "", "()V", "BASE_FONT_SIZE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

