/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookOfflineSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookRuntimeSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.ManagedJupyterServerNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterStatusMessage;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterKernelManagementAction;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterKernelManagementActionKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerFinished;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarted;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarting;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerState;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStopped;
import org.jetbrains.plugins.notebooks.jupyter.ui.BalloonStyle;
import org.jetbrains.plugins.notebooks.jupyter.ui.BalloonsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterKernelManagementAction;", "Lcom/intellij/openapi/actionSystem/ex/ComboBoxAction;", "()V", "createdComponent", "Ljavax/swing/JComponent;", "createActionForKernelSpec", "Lcom/intellij/openapi/actionSystem/AnAction;", "kernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "currentKernelName", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createCustomComponent", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "createPopupActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "button", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getKernelSpecsForCurrentConnectionParameters", "", "project", "Lcom/intellij/openapi/project/Project;", "showWarning", "", "text", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.jupyter"})
public final class JupyterKernelManagementAction
extends ComboBoxAction {
    private JComponent createdComponent;

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        JComponent jComponent = super.createCustomComponent(presentation, place);
        boolean bl = false;
        boolean bl2 = false;
        JComponent $this$apply = jComponent;
        boolean bl3 = false;
        JComponent jComponent2 = $this$apply;
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent2, (String)"this");
        this.createdComponent = jComponent2;
        JComponent jComponent3 = jComponent;
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent3, (String)"super.createCustomCompon\u2026tedComponent = this\n    }");
        return jComponent3;
    }

    public final void showWarning(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        JComponent jComponent = this.createdComponent;
        if (jComponent == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"createdComponent");
        }
        BalloonsKt.showBalloon(jComponent, text2, BalloonStyle.ERROR);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2) {
        Intrinsics.checkParameterIsNotNull((Object)button2, (String)"button");
        return new DefaultActionGroup();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)button2, (String)"button");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = JupyterActionsKt.getProject(dataContext);
        if (project == null) {
            return new DefaultActionGroup();
        }
        Project project2 = project;
        VirtualFile virtualFile2 = JupyterActionsKt.getVirtualFile(dataContext);
        JupyterNotebookRuntimeSettings settings = JupyterActionsKt.getJupyterNotebookRuntimeSettings(dataContext);
        if (settings == null) {
            Collection<AnAction> collection;
            void $this$mapTo$iv$iv;
            List<JupyterKernelSpec> list = this.getKernelSpecsForCurrentConnectionParameters(project2, virtualFile2);
            if (list == null) {
                return new DefaultActionGroup();
            }
            List<JupyterKernelSpec> kernelSpecs = list;
            NotebookVirtualFile jupyterVirtualFile = JupyterActionsKt.getJupyterVirtualFile(dataContext);
            Object object = jupyterVirtualFile;
            JupyterKernelSpec kernelSpec = object != null && (object = object.getNotebook()) != null ? object.getKernelSpec() : null;
            Iterable $this$map$iv = kernelSpecs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JupyterKernelSpec jupyterKernelSpec = (JupyterKernelSpec)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                JupyterKernelSpec jupyterKernelSpec2 = kernelSpec;
                AnAction anAction = this.createActionForKernelSpec((JupyterKernelSpec)it, jupyterKernelSpec2 != null ? jupyterKernelSpec2.getName() : null, virtualFile2);
                collection.add(anAction);
            }
            collection = (List)destination$iv$iv;
            List list2 = CollectionsKt.toMutableList((Collection)collection);
            return new DefaultActionGroup(list2);
        }
        return (DefaultActionGroup)settings.accept(new JupyterNotebookRuntimeSettings.Visitor<DefaultActionGroup>(this, project2, virtualFile2, button2){
            final /* synthetic */ JupyterKernelManagementAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ JComponent $button;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public DefaultActionGroup visit(@NotNull JupyterNotebookOfflineSettings settings) {
                Collection<AnAction> collection;
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List list = JupyterKernelManagementAction.access$getKernelSpecsForCurrentConnectionParameters(this.this$0, this.$project, this.$virtualFile);
                if (list == null) {
                    return new DefaultActionGroup();
                }
                List kernelSpecs = list;
                String currentKernelName = settings.getKernelSpec().getName();
                Iterable $this$map$iv = kernelSpecs;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JupyterKernelSpec jupyterKernelSpec = (JupyterKernelSpec)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    AnAction anAction = JupyterKernelManagementAction.access$createActionForKernelSpec(this.this$0, (JupyterKernelSpec)it, currentKernelName, this.$virtualFile);
                    collection.add(anAction);
                }
                collection = (List)destination$iv$iv;
                List list2 = CollectionsKt.toMutableList((Collection)collection);
                return new DefaultActionGroup(list2);
            }

            @NotNull
            public DefaultActionGroup visit(@NotNull JupyterNotebookSessionSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.createActionGroupForSession(settings.getSession());
            }

            @NotNull
            public DefaultActionGroup visit(@NotNull ManagedJupyterServerNotebookSessionSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.createActionGroupForSession(settings.getSession());
            }

            private final DefaultActionGroup createActionGroupForSession(JupyterNotebookSession session) {
                String currentKernelName = session.getKernelName();
                JupyterServer server = session.getJupyterServer();
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(this.getActions(currentKernelName, server));
                boolean bl = false;
                boolean bl2 = false;
                DefaultActionGroup it = defaultActionGroup;
                boolean bl3 = false;
                this.updateActionGroupAsync(it, server, currentKernelName);
                return defaultActionGroup;
            }

            /*
             * WARNING - void declaration
             */
            private final List<AnAction> getActions(String currentKernelName, JupyterServer jupyterServer) {
                List list;
                block4: {
                    block3: {
                        void $this$mapTo$iv$iv;
                        list = jupyterServer.getKernelSpecs();
                        if (list == null) break block3;
                        Iterable $this$map$iv = list;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            JupyterKernelSpec jupyterKernelSpec = (JupyterKernelSpec)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            AnAction anAction = JupyterKernelManagementAction.access$createActionForKernelSpec(this.this$0, (JupyterKernelSpec)it, currentKernelName, this.$virtualFile);
                            collection.add(anAction);
                        }
                        list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                        if (list != null) break block4;
                    }
                    boolean bl = false;
                    list = new ArrayList<E>();
                }
                return list;
            }

            private final void updateActionGroupAsync(DefaultActionGroup actionGroup, JupyterServer jupyterServer, String currentKernelName) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, jupyterServer, actionGroup, currentKernelName){
                    final /* synthetic */ createPopupActionGroup.2 this$0;
                    final /* synthetic */ JupyterServer $jupyterServer;
                    final /* synthetic */ DefaultActionGroup $actionGroup;
                    final /* synthetic */ String $currentKernelName;

                    public final void run() {
                        this.$jupyterServer.updateKernelSpecs();
                        ApplicationManager.getApplication().invokeLater(new Runnable(this){
                            final /* synthetic */ createPopupActionGroup.updateActionGroupAsync.1 this$0;

                            public final void run() {
                                this.this$0.$actionGroup.removeAll();
                                this.this$0.$actionGroup.addAll((Collection)createPopupActionGroup.2.access$getActions(this.this$0.this$0, this.this$0.$currentKernelName, this.this$0.$jupyterServer));
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, ModalityState.stateForComponent((Component)this.this$0.$button));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$jupyterServer = jupyterServer;
                        this.$actionGroup = defaultActionGroup;
                        this.$currentKernelName = string;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                this.$virtualFile = $captured_local_variable$2;
                this.$button = $captured_local_variable$3;
            }

            public static final /* synthetic */ List access$getActions(createPopupActionGroup.2 $this, String currentKernelName, JupyterServer jupyterServer) {
                return $this.getActions(currentKernelName, jupyterServer);
            }
        });
    }

    private final AnAction createActionForKernelSpec(JupyterKernelSpec kernelSpec, String currentKernelName, VirtualFile virtualFile2) {
        boolean isKernelspecOfCurrentKernel = Intrinsics.areEqual((Object)currentKernelName, (Object)kernelSpec.getName());
        return new AnAction(isKernelspecOfCurrentKernel, virtualFile2, kernelSpec, kernelSpec.getDisplayName()){
            final /* synthetic */ boolean $isKernelspecOfCurrentKernel;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ JupyterKernelSpec $kernelSpec;

            public void actionPerformed(@NotNull AnActionEvent e) {
                JupyterRuntimeService runtimeService;
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (!this.$isKernelspecOfCurrentKernel && (runtimeService = JupyterActionsKt.getJupyterRuntimeService(e)) != null && this.$virtualFile != null) {
                    runtimeService.switchKernel(this.$virtualFile, this.$kernelSpec);
                }
            }
            {
                this.$isKernelspecOfCurrentKernel = $captured_local_variable$0;
                this.$virtualFile = $captured_local_variable$1;
                this.$kernelSpec = $captured_local_variable$2;
                super($super_call_param$3);
                Presentation presentation = this.getTemplatePresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
                presentation.setDescription("Create session with " + $captured_local_variable$2.getDisplayName() + " kernel");
                if ($captured_local_variable$0) {
                    Presentation presentation2 = this.getTemplatePresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"templatePresentation");
                    presentation2.setIcon(AllIcons.Actions.Checked);
                }
            }
        };
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        VirtualFile virtualFile2 = JupyterActionsKt.getVirtualFile(e);
        JupyterNotebookRuntimeSettings runtimeSettings = JupyterActionsKt.getJupyterNotebookRuntimeSettings(e);
        if (runtimeSettings == null) {
            List<JupyterKernelSpec> kernelSpecs = this.getKernelSpecsForCurrentConnectionParameters(project2, virtualFile2);
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
            NotebookVirtualFile jupyterVirtualFile = JupyterActionsKt.getJupyterVirtualFile(dataContext);
            Object object = jupyterVirtualFile;
            JupyterKernelSpec kernelSpec = object != null && (object = object.getNotebook()) != null ? object.getKernelSpec() : null;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            Object object2 = kernelSpec;
            if (object2 == null || (object2 = object2.getDisplayName()) == null) {
                object2 = JupyterBundle.message("jupyter.kernel.spec.not.specified", new Object[0]);
            }
            presentation.setText((String)object2);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            Collection collection = kernelSpecs;
            Presentation presentation3 = presentation2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = collection == null || collection.isEmpty();
            presentation3.setEnabled(!bl3);
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"e.presentation");
            presentation4.setIcon(JupyterKernelManagementActionKt.access$getServerNotConnected$p());
        } else {
            runtimeSettings.accept(new JupyterNotebookRuntimeSettings.Visitor<Unit>(this, project2, virtualFile2, e){
                final /* synthetic */ JupyterKernelManagementAction this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ AnActionEvent $e;

                public void visit(@NotNull JupyterNotebookOfflineSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    List kernelSpecs = JupyterKernelManagementAction.access$getKernelSpecsForCurrentConnectionParameters(this.this$0, this.$project, this.$virtualFile);
                    Presentation presentation = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                    Collection collection = kernelSpecs;
                    Presentation presentation2 = presentation;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = collection == null || collection.isEmpty();
                    presentation2.setEnabled(!bl3);
                    Presentation presentation3 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
                    presentation3.setText(settings.getKernelSpec().getDisplayName());
                    Presentation presentation4 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"e.presentation");
                    presentation4.setIcon(JupyterKernelManagementActionKt.access$getServerNotConnected$p());
                }

                public void visit(@NotNull JupyterNotebookSessionSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    this.updatePresentationUsingSessionParameters(settings.getSession());
                }

                public void visit(@NotNull ManagedJupyterServerNotebookSessionSettings settings) {
                    Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                    settings.getJupyterServerExecution().getState().accept(new JupyterServerState.Visitor<Unit>(this, settings){
                        final /* synthetic */ update.1 this$0;
                        final /* synthetic */ ManagedJupyterServerNotebookSessionSettings $settings;

                        public void visit(@NotNull JupyterServerStopped state2) {
                            Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                            update.1.access$updatePresentationUsingNotStartedSessionParameters(this.this$0, this.$settings.getSession());
                        }

                        public void visit(@NotNull JupyterServerStarting state2) {
                            Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                            update.1.access$updatePresentationUsingNotStartedSessionParameters(this.this$0, this.$settings.getSession());
                        }

                        public void visit(@NotNull JupyterServerStarted state2) {
                            Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                            update.1.access$updatePresentationUsingSessionParameters(this.this$0, this.$settings.getSession());
                        }

                        public void visit(@NotNull JupyterServerFinished state2) {
                            Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                            update.1.access$updatePresentationUsingNotStartedSessionParameters(this.this$0, this.$settings.getSession());
                        }
                        {
                            this.this$0 = $outer;
                            this.$settings = $captured_local_variable$1;
                        }
                    });
                }

                private final void updatePresentationUsingSessionParameters(JupyterNotebookSession session) {
                    Presentation presentation = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                    presentation.setEnabledAndVisible(true);
                    Presentation presentation2 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
                    presentation2.setText(session.getKernelSpec().getDisplayName());
                    Presentation presentation3 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
                    JupyterStatusMessage.JupyterExecutionState jupyterExecutionState = session.getKernelClient().getExecutionState();
                    presentation3.setIcon(jupyterExecutionState != null ? JupyterKernelManagementActionKt.access$getIcon(jupyterExecutionState) : null);
                }

                private final void updatePresentationUsingNotStartedSessionParameters(JupyterNotebookSession session) {
                    Presentation presentation = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                    presentation.setEnabledAndVisible(true);
                    Presentation presentation2 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
                    presentation2.setText(session.getKernelSpec().getDisplayName());
                    Presentation presentation3 = this.$e.getPresentation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
                    presentation3.setIcon(JupyterKernelManagementActionKt.access$getServerNotConnected$p());
                }
                {
                    this.this$0 = $outer;
                    this.$project = $captured_local_variable$1;
                    this.$virtualFile = $captured_local_variable$2;
                    this.$e = $captured_local_variable$3;
                }

                public static final /* synthetic */ void access$updatePresentationUsingNotStartedSessionParameters(update.1 $this, JupyterNotebookSession session) {
                    $this.updatePresentationUsingNotStartedSessionParameters(session);
                }

                public static final /* synthetic */ void access$updatePresentationUsingSessionParameters(update.1 $this, JupyterNotebookSession session) {
                    $this.updatePresentationUsingSessionParameters(session);
                }
            });
        }
    }

    private final List<JupyterKernelSpec> getKernelSpecsForCurrentConnectionParameters(Project project, VirtualFile virtualFile2) {
        JupyterServer jupyterServer = JupyterConnectionSettingsUtilKt.getJupyterServer(project, virtualFile2);
        return jupyterServer != null ? jupyterServer.getKernelSpecs() : null;
    }

    public static final /* synthetic */ List access$getKernelSpecsForCurrentConnectionParameters(JupyterKernelManagementAction $this, Project project, VirtualFile virtualFile2) {
        return $this.getKernelSpecsForCurrentConnectionParameters(project, virtualFile2);
    }

    public static final /* synthetic */ AnAction access$createActionForKernelSpec(JupyterKernelManagementAction $this, JupyterKernelSpec kernelSpec, String currentKernelName, VirtualFile virtualFile2) {
        return $this.createActionForKernelSpec(kernelSpec, currentKernelName, virtualFile2);
    }
}

