/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.run.PythonCommandLineState;
import icons.PythonIcons;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.debugger.DebugConnectionNotifier;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugProcess;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugProcessHandler;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugRunner;
import org.jetbrains.plugins.notebooks.jupyter.debugger.OutputConsumer;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugRunner;", "Lcom/jetbrains/python/debugger/PyDebugRunner;", "()V", "Companion", "intellij.python.jupyter"})
public final class JupyterDebugRunner
extends PyDebugRunner {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0015\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00052\u0006\u0010\f\u001a\u00020\rH\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugRunner$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createDebugSession", "Lcom/intellij/xdebugger/XDebugSession;", "project", "Lcom/intellij/openapi/project/Project;", "cell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "connectionNotifier", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/DebugConnectionNotifier;", "output", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/OutputConsumer;", "afterCellExecuted", "Lkotlin/Function0;", "", "getFileName", "", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final XDebugSession createDebugSession(@NotNull Project project, @NotNull JupyterCell cell, @NotNull DebugConnectionNotifier connectionNotifier, @Nullable OutputConsumer output, @NotNull Function0<Unit> afterCellExecuted) throws ExecutionException {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
            Intrinsics.checkParameterIsNotNull((Object)connectionNotifier, (String)"connectionNotifier");
            Intrinsics.checkParameterIsNotNull(afterCellExecuted, (String)"afterCellExecuted");
            ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(this.getFileName(cell), PythonIcons.Python.IpythonNotebook, null, false, new XDebugProcessStarter(project, serverSocket, cell, connectionNotifier, output, afterCellExecuted){
                final /* synthetic */ Project $project;
                final /* synthetic */ ServerSocket $serverSocket;
                final /* synthetic */ JupyterCell $cell;
                final /* synthetic */ DebugConnectionNotifier $connectionNotifier;
                final /* synthetic */ OutputConsumer $output;
                final /* synthetic */ Function0 $afterCellExecuted;

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                    ConsoleView consoleView = new PyDebugConsoleBuilder(this.$project, null).getConsole();
                    Intrinsics.checkExpressionValueIsNotNull((Object)consoleView, (String)"PyDebugConsoleBuilder(project, null).console");
                    ConsoleView debugConsoleView = consoleView;
                    JupyterDebugProcessHandler jupyterDebugProcessHandler = new JupyterDebugProcessHandler(this.$project, session);
                    ServerSocket serverSocket = this.$serverSocket;
                    Intrinsics.checkExpressionValueIsNotNull((Object)serverSocket, (String)"serverSocket");
                    JupyterDebugProcess jupyterDebugProcess = new JupyterDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, jupyterDebugProcessHandler, this.$cell, this.$connectionNotifier, this.$output, (Function0<Unit>)this.$afterCellExecuted);
                    ConsoleView consoleView2 = debugConsoleView;
                    if (consoleView2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.console.PythonDebugLanguageConsoleView");
                    }
                    PyDebugRunner.initDebugConsoleView(this.$project, jupyterDebugProcess, (PythonDebugLanguageConsoleView)consoleView2, jupyterDebugProcessHandler, session);
                    jupyterDebugProcess.connect(this.$cell);
                    return jupyterDebugProcess;
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$serverSocket = $captured_local_variable$1;
                    this.$cell = $captured_local_variable$2;
                    this.$connectionNotifier = $captured_local_variable$3;
                    this.$output = $captured_local_variable$4;
                    this.$afterCellExecuted = $captured_local_variable$5;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"XDebuggerManager.getInst\u2026rocess\n        }\n      })");
            return xDebugSession;
        }

        public static /* synthetic */ XDebugSession createDebugSession$default(Companion companion, Project project, JupyterCell jupyterCell, DebugConnectionNotifier debugConnectionNotifier, OutputConsumer outputConsumer, Function0 function0, int n, Object object) throws ExecutionException {
            if ((n & 8) != 0) {
                outputConsumer = null;
            }
            if ((n & 0x10) != 0) {
                function0 = createDebugSession.1.INSTANCE;
            }
            return companion.createDebugSession(project, jupyterCell, debugConnectionNotifier, outputConsumer, (Function0<Unit>)function0);
        }

        private final String getFileName(JupyterCell cell) {
            String string;
            if (cell.getContainingFile() != null) {
                PsiFile psiFile = cell.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"cell.containingFile");
                string = FileUtil.getNameWithoutExtension((String)psiFile.getName());
            } else {
                this.getLOG().error("Containing file for cell is null: " + cell);
                string = "Jupyter File";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (cell.containingFile \u2026   \"Jupyter File\"\n      }");
            return string;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

