/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterKernelDoesNotExistsException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterKernelSpecMissingException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSockerClientClosedException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWrongNotebookLanguageException;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterRestClientErrorResponseException;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/ui/JupyterErrorReporter;", "", "()V", "Companion", "intellij.python.jupyter"})
public final class JupyterErrorReporter {
    private static final Logger LOG;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fJ\"\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J&\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u00112\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/ui/JupyterErrorReporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "displayAndLogError", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "displayKernelProblem", "jupyterFileEditor", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterTextEditorWithPreview;", "balloonMessage", "", "dialogMessage", "getJupyterFileEditor", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "showErrorDialog", "message", "title", "moreInfo", "intellij.python.jupyter"})
    public static final class Companion {
        public final void displayAndLogError(@Nullable Project project, @NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Exception exception = e;
            if (!(exception instanceof JupyterWebSockerClientClosedException)) {
                if (exception instanceof JupyterKernelDoesNotExistsException) {
                    NotebookVirtualFile notebookVirtualFile = ((JupyterKernelDoesNotExistsException)e).getNotebookVirtualFile();
                    JupyterTextEditorWithPreview jupyterFileEditor = this.getJupyterFileEditor(project, (VirtualFile)(notebookVirtualFile != null ? notebookVirtualFile.getOriginFile() : null));
                    ApplicationManager.getApplication().invokeLater(new Runnable(jupyterFileEditor, e){
                        final /* synthetic */ JupyterTextEditorWithPreview $jupyterFileEditor;
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter$Companion.access$displayKernelProblem(JupyterErrorReporter.Companion, this.$jupyterFileEditor, JupyterBundle.message("Jupyter.kernel.does.not.exist.balloon.message", new Object[0]), ((JupyterKernelDoesNotExistsException)this.$e).getMessage());
                        }
                        {
                            this.$jupyterFileEditor = jupyterTextEditorWithPreview;
                            this.$e = exception;
                        }
                    });
                } else if (exception instanceof JupyterKernelSpecMissingException) {
                    JupyterTextEditorWithPreview jupyterFileEditor = this.getJupyterFileEditor(project, ((JupyterKernelSpecMissingException)e).getNotebookVirtualFile().getOriginFile());
                    ApplicationManager.getApplication().invokeLater(new Runnable(jupyterFileEditor, e){
                        final /* synthetic */ JupyterTextEditorWithPreview $jupyterFileEditor;
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter$Companion.access$displayKernelProblem(JupyterErrorReporter.Companion, this.$jupyterFileEditor, JupyterBundle.message("Jupyter.kernel.spec.is.missing.in.notebook.balloon.message", new Object[0]), ((JupyterKernelSpecMissingException)this.$e).getMessage());
                        }
                        {
                            this.$jupyterFileEditor = jupyterTextEditorWithPreview;
                            this.$e = exception;
                        }
                    });
                } else if (exception instanceof JupyterRestClientErrorResponseException) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(e){
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter$Companion.access$showErrorDialog(JupyterErrorReporter.Companion, this.$e.getMessage(), JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), ((JupyterRestClientErrorResponseException)this.$e).getTraceback());
                        }
                        {
                            this.$e = exception;
                        }
                    });
                } else if (exception instanceof JupyterWrongNotebookLanguageException) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(e){
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter$Companion.showErrorDialog$default(JupyterErrorReporter.Companion, ((JupyterWrongNotebookLanguageException)this.$e).getMessage(), JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), null, 4, null);
                        }
                        {
                            this.$e = exception;
                        }
                    });
                } else {
                    LOG.error("Unhandled Jupyter error", (Throwable)e);
                    ApplicationManager.getApplication().invokeLater(new Runnable(e){
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter$Companion.showErrorDialog$default(JupyterErrorReporter.Companion, this.$e.getMessage(), JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), null, 4, null);
                        }
                        {
                            this.$e = exception;
                        }
                    });
                }
            }
        }

        private final void displayKernelProblem(JupyterTextEditorWithPreview jupyterFileEditor, String balloonMessage, String dialogMessage) {
            if (jupyterFileEditor != null && jupyterFileEditor.isValid()) {
                jupyterFileEditor.showErrorBalloonForKernelComboBoxAction(balloonMessage);
            } else {
                org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter$Companion.showErrorDialog$default(this, dialogMessage, JupyterBundle.message("Jupyter.run.error.dialog.title", new Object[0]), null, 4, null);
            }
        }

        private final JupyterTextEditorWithPreview getJupyterFileEditor(Project project, VirtualFile originalFile) {
            return project != null && originalFile != null ? JupyterCellUtilKt.getJupyterFileEditorByOriginalVirtualFile(project, originalFile) : null;
        }

        private final void showErrorDialog(String message, String title, String moreInfo) {
            if (moreInfo == null) {
                Messages.showErrorDialog((String)message, (String)title);
            } else {
                Messages.showDialog(null, (String)message, (String)title, (String)moreInfo, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (int)0, (Icon)Messages.getErrorIcon());
            }
        }

        static /* synthetic */ void showErrorDialog$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            companion.showErrorDialog(string, string2, string3);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$displayKernelProblem(Companion $this, JupyterTextEditorWithPreview jupyterFileEditor, String balloonMessage, String dialogMessage) {
            $this.displayKernelProblem(jupyterFileEditor, balloonMessage, dialogMessage);
        }

        public static final /* synthetic */ void access$showErrorDialog(Companion $this, String message, String title, String moreInfo) {
            $this.showErrorDialog(message, title, moreInfo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

