/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.util.Base64;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileContentsApiKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileModel;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileWriterOutputStream;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0016J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000b*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileWriterOutputStreamImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileWriterOutputStream;", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "path", "", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;Ljava/lang/String;)V", "chunk", "", "decoder", "Ljava/nio/charset/CharsetDecoder;", "kotlin.jvm.PlatformType", "<set-?>", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileModel;", "model", "getModel", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileModel;", "rootNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "close", "", "doWrite", "content", "format", "flush", "write", "b", "", "off", "len", "intellij.python.jupyter"})
public final class FileWriterOutputStreamImpl
extends FileWriterOutputStream {
    @Nullable
    private FileModel model;
    private final ObjectNode rootNode;
    private final CharsetDecoder decoder;
    private int chunk;
    private final HttpSession httpSession;
    private final String path;

    @Override
    @Nullable
    public FileModel getModel() {
        return this.model;
    }

    @Override
    public void write(int b) {
        String string = "Should be never called";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        void content2;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        try {
            pair = TuplesKt.to((Object)this.decoder.decode(ByteBuffer.wrap(b, off, len)).toString(), (Object)"text");
        }
        catch (MalformedInputException ignored) {
            pair = TuplesKt.to((Object)Base64.encode((byte[])ArraysKt.sliceArray((byte[])b, (IntRange)RangesKt.until((int)off, (int)(off + len)))), (Object)"base64");
        }
        Pair pair2 = pair;
        String string = (String)pair2.component1();
        String format = (String)pair2.component2();
        this.doWrite((String)content2, format);
    }

    @Override
    public void flush() {
        if (this.getModel() == null) {
            this.doWrite("", "text");
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final void doWrite(String content2, String format) {
        Object object;
        void $this$readValueWrappingError$iv;
        Object object2;
        Object object3;
        ObjectNode objectNode = this.rootNode;
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$with = objectNode;
        boolean bl3 = false;
        $this$with.put("chunk", this.chunk);
        $this$with.put("content", content2);
        $this$with.put("format", format);
        String endpoint = "/api/contents/" + StringsKt.trim((String)this.path, (char[])new char[]{'/'});
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object3 = $this$debug$iv;
            boolean bl4 = false;
            String string = content2;
            object2 = "Authority " + this.httpSession.getBaseURI().getAuthority() + ", path \"" + this.path + "\", writing chunk " + this.chunk + " with length " + (string != null ? Integer.valueOf(string.length()) : null) + ", format " + format + '.';
            object3.debug((String)object2, (Throwable)e$iv);
        }
        String string = JupyterJsonKt.getJackson().writeValueAsString((Object)this.rootNode);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jackson.writeValueAsString(rootNode)");
        String response = JupyterHttpSessionRestUtilsKt.put$default(this.httpSession, endpoint, string, null, 4, null);
        ++this.chunk;
        e$iv = JupyterJsonKt.getJackson();
        object3 = this;
        boolean $i$f$readValueWrappingError = false;
        try {
            object = $this$readValueWrappingError$iv.readValue(response, FileModel.class);
        }
        catch (JsonProcessingException err$iv) {
            String prettyJson$iv = $this$readValueWrappingError$iv.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JupyterJsonKt.getJackson().readTree(response));
            boolean bl5 = false;
            String string2 = "PUT " + endpoint;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", prettyJson$iv)};
            Throwable throwable = err$iv;
            String string3 = string2;
            throw (Throwable)new RuntimeExceptionWithAttachments(string3, throwable, attachmentArray);
        }
        object2 = object;
        object3.model = (FileModel)object2;
    }

    public FileWriterOutputStreamImpl(@NotNull HttpSession httpSession, @NotNull String path) {
        ObjectNode objectNode;
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.httpSession = httpSession;
        this.path = path;
        ObjectNode objectNode2 = JupyterJsonKt.getJackson().createObjectNode();
        FileWriterOutputStreamImpl fileWriterOutputStreamImpl = this;
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode2;
        boolean bl3 = false;
        $this$apply.put("type", "file");
        fileWriterOutputStreamImpl.rootNode = objectNode = objectNode2;
        this.decoder = Charsets.UTF_8.newDecoder();
        this.chunk = 1;
    }
}

