/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.MessageTracker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/MessageTracker;", "", "()V", "sessionIdToCodeMessages", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "sessionIdToNonCodeMessages", "codeMessageExecuted", "", "sessionId", "messageId", "handleExecutionFinished", "", "nonCodeMessageExecuted", "intellij.python.jupyter"})
final class MessageTracker {
    private final ConcurrentHashMap<String, Set<String>> sessionIdToCodeMessages = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> sessionIdToNonCodeMessages = new ConcurrentHashMap();

    public final void codeMessageExecuted(@NotNull String sessionId, @NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        this.sessionIdToCodeMessages.computeIfAbsent(sessionId, codeMessageExecuted.1.INSTANCE).add(messageId);
    }

    public final void nonCodeMessageExecuted(@NotNull String sessionId, @NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        this.sessionIdToNonCodeMessages.computeIfAbsent(sessionId, nonCodeMessageExecuted.1.INSTANCE).add(messageId);
    }

    public final boolean handleExecutionFinished(@NotNull String sessionId, @NotNull String messageId) {
        Set<String> executedMessages;
        block2: {
            Set<String> commMessages;
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
            Set<String> set = commMessages = this.sessionIdToNonCodeMessages.get(sessionId);
            if (set != null) {
                if (set.contains(messageId)) {
                    commMessages.remove(messageId);
                    return false;
                }
            }
            Set<String> set2 = executedMessages = this.sessionIdToCodeMessages.get(sessionId);
            if (set2 == null) break block2;
            set2.remove(messageId);
        }
        return executedMessages == null || executedMessages.isEmpty();
    }
}

