/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.core.impl.file;

import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.testFramework.LightVirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.JupyterLargeFileWriteRequestor;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFileSystem;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\r\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!H\u0016J\b\u0010\"\u001a\u00020\u0001H\u0016J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020\u0001H\u0016J\r\u0010*\u001a\u00070 \u00a2\u0006\u0002\b!H\u0016J\r\u0010+\u001a\u00070,\u00a2\u0006\u0002\b!H\u0002J\b\u0010-\u001a\u00020\u001dH\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020/H\u0016J\b\u00101\u001a\u00020/H\u0016J\"\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020/2\b\u00105\u001a\u0004\u0018\u000106H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/notebook/editor/BackedVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFileWithId;", "originalFile", "notebook", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;)V", "contentFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getNotebook", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "setNotebook", "(Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;)V", "contentsToByteArray", "", "kotlin.jvm.PlatformType", "flush", "", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFileSystem;", "getId", "", "getInputStream", "Ljava/io/InputStream;", "getLength", "", "getModificationStamp", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "getOriginFile", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getPublisher", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "getTimeStamp", "isDirectory", "", "isValid", "isWritable", "refresh", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "intellij.python.jupyter"})
public final class NotebookVirtualFile
extends VirtualFile
implements BackedVirtualFile,
VirtualFileWithId {
    private final LightVirtualFile contentFile;
    private final VirtualFile originalFile;
    @NotNull
    private JupyterNotebook notebook;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        if (!this.getOriginFile().isValid()) {
            return;
        }
        Closeable closeable = new OutputStreamWriter(this.getOriginFile().getOutputStream((Object)JupyterLargeFileWriteRequestor.INSTANCE), Charsets.UTF_8);
        boolean bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl2 = false;
            this.notebook.writeJson(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.getFileSystem().markUnmodified$intellij_python_jupyter(this);
    }

    public int getId() {
        VirtualFile virtualFile2 = this.originalFile;
        if (virtualFile2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        }
        return ((VirtualFileWithId)virtualFile2).getId();
    }

    @NotNull
    public VirtualFile getOriginFile() {
        return this.originalFile;
    }

    @NotNull
    public VirtualFile getParent() {
        VirtualFile virtualFile2 = this.originalFile.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"originalFile.parent");
        return virtualFile2;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        VirtualFile[] virtualFileArray = this.originalFile.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"originalFile.children");
        return virtualFileArray;
    }

    public boolean isWritable() {
        return this.contentFile.isWritable();
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.originalFile.refresh(asynchronous, recursive, postRunnable);
    }

    public long getLength() {
        return this.contentFile.getLength();
    }

    @NotNull
    public NotebookVirtualFileSystem getFileSystem() {
        return NotebookVirtualFileSystem.Companion.getNotebookVirtualFileSystem();
    }

    @NotNull
    public String getPath() {
        String string = this.originalFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalFile.path");
        return string;
    }

    public boolean isDirectory() {
        return false;
    }

    public long getTimeStamp() {
        return this.originalFile.getTimeStamp();
    }

    @NotNull
    public String getName() {
        String string = this.originalFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalFile.name");
        return string;
    }

    public byte[] contentsToByteArray() {
        return this.contentFile.contentsToByteArray();
    }

    public boolean isValid() {
        return this.contentFile.isValid();
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.contentFile.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"contentFile.inputStream");
        return inputStream;
    }

    public long getModificationStamp() {
        return this.originalFile.getModificationStamp();
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)new ByteArrayOutputStream(this, requestor, newModificationStamp){
            final /* synthetic */ NotebookVirtualFile this$0;
            final /* synthetic */ Object $requestor;
            final /* synthetic */ long $newModificationStamp;

            public void close() {
                boolean bl = this.this$0.isWritable();
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                VFileContentChangeEvent event2 = new VFileContentChangeEvent(this.$requestor, (VirtualFile)this.this$0, this.this$0.getModificationStamp(), this.$newModificationStamp, false);
                List events = CollectionsKt.listOf((Object)event2);
                NotebookVirtualFile.access$getPublisher(this.this$0).before(events);
                try {
                    NotebookVirtualFile.access$getContentFile$p(this.this$0).setContent((Object)((Object)this.this$0), (CharSequence)this.toString(this.this$0.getCharset().name()), false);
                }
                catch (UnsupportedEncodingException e) {
                    throw (Throwable)new RuntimeException(e);
                }
                NotebookVirtualFile.access$getPublisher(this.this$0).after(events);
            }
            {
                this.this$0 = $outer;
                this.$requestor = $captured_local_variable$1;
                this.$newModificationStamp = $captured_local_variable$2;
            }
        }, (VirtualFile)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"VfsUtilCore.outputStream\u2026nts)\n      }\n    }, this)");
        return outputStream;
    }

    private final BulkFileListener getPublisher() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        Object object = application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026lFileManager.VFS_CHANGES)");
        return (BulkFileListener)object;
    }

    @NotNull
    public final JupyterNotebook getNotebook() {
        return this.notebook;
    }

    public final void setNotebook(@NotNull JupyterNotebook jupyterNotebook) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterNotebook, (String)"<set-?>");
        this.notebook = jupyterNotebook;
    }

    public NotebookVirtualFile(@NotNull VirtualFile originalFile, @NotNull JupyterNotebook notebook) {
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
        this.originalFile = originalFile;
        this.notebook = notebook;
        this.contentFile = new LightVirtualFile(this.originalFile, this.notebook.asSource(), this.originalFile.getModificationStamp());
    }

    public static final /* synthetic */ BulkFileListener access$getPublisher(NotebookVirtualFile $this) {
        return $this.getPublisher();
    }

    public static final /* synthetic */ LightVirtualFile access$getContentFile$p(NotebookVirtualFile $this) {
        return $this.contentFile;
    }
}

