/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.core.impl.file;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookFileEventHandler;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookOriginToSourceChangePropagator;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterFileType;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.NotebookChanged;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/notebooks/core/impl/file/JupyterOriginEventHandler;", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookFileEventHandler;", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookOriginToSourceChangePropagator;", "()V", "handle", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "propagateChange", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.python.jupyter"})
final class JupyterOriginEventHandler
implements NotebookFileEventHandler,
NotebookOriginToSourceChangePropagator {
    public static final JupyterOriginEventHandler INSTANCE;

    @Override
    public boolean handle(@NotNull VFileEvent event2) {
        VirtualFile file2;
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        VirtualFile virtualFile2 = file2 = event2.getFile();
        if (!((virtualFile2 != null ? virtualFile2.getFileType() : null) instanceof JupyterFileType) || !event2.isFromRefresh()) {
            return false;
        }
        this.propagateChange(file2);
        return true;
    }

    private final void propagateChange(VirtualFile file2) {
        Document document = JupyterCellUtilKt.getDocumentByOriginalVirtualFile(file2);
        if (document == null) {
            return;
        }
        Document sourceDocument = document;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(sourceDocument);
        if (!(virtualFile2 instanceof NotebookVirtualFile)) {
            virtualFile2 = null;
        }
        NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)virtualFile2;
        if (notebookVirtualFile == null) {
            return;
        }
        NotebookVirtualFile sourceFile = notebookVirtualFile;
        JupyterNotebook originalNotebook = sourceFile.getNotebook();
        InputStream inputStream = file2.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, charset);
        Reader reader = inputStreamReader;
        JupyterNotebookBase updatedNotebook = new JupyterNotebookBase(reader);
        Iterable $this$forEach$iv = originalNotebook.getJupyterChangeListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterChangeListener it = (JupyterChangeListener)element$iv;
            boolean bl2 = false;
            updatedNotebook.addJupyterChangeListener(it);
        }
        originalNotebook.removeAllJupyterChangeListeners();
        sourceDocument.setText(updatedNotebook.asSource());
        updatedNotebook.notifyListeners$intellij_python_jupyter(new NotebookChanged(updatedNotebook));
        sourceFile.setNotebook(updatedNotebook);
    }

    private JupyterOriginEventHandler() {
    }

    static {
        JupyterOriginEventHandler jupyterOriginEventHandler;
        INSTANCE = jupyterOriginEventHandler = new JupyterOriginEventHandler();
    }
}

