/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.psi;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyReferenceResolveProvider;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.web2py.Web2PyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Web2PyReferenceResolveProvider
implements PyReferenceResolveProvider {
    private static final Set<String> ourDBGlobals = ImmutableSet.builder().add((Object)"SQLField").add((Object)"SQLTable").add((Object)"SQLXorable").add((Object)"SQLQuery").add((Object)"SQLSet").add((Object)"SQLRows").add((Object)"SQLStorage").add((Object)"GQLDB").add((Object)"SQLDB").build();

    @Override
    @NotNull
    public List<RatedResolveResult> resolveName(@NotNull PyQualifiedExpression element, @NotNull TypeEvalContext context) {
        PsiDirectory models;
        PsiDirectory applicationBase;
        if (element == null) {
            Web2PyReferenceResolveProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            Web2PyReferenceResolveProvider.$$$reportNull$$$0(1);
        }
        ArrayList<RatedResolveResult> result = new ArrayList<RatedResolveResult>();
        Project project = element.getProject();
        if (!Web2PyUtils.isWeb2PyProject(project) && !Web2PyUtils.isWeb2PyApp(project)) {
            ArrayList<RatedResolveResult> arrayList = result;
            if (arrayList == null) {
                Web2PyReferenceResolveProvider.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        PsiFile file2 = element.getContainingFile();
        PsiDirectory directory2 = file2.getContainingDirectory();
        if (directory2 != null && "modules".equals(directory2.getName())) {
            ArrayList<RatedResolveResult> arrayList = result;
            if (arrayList == null) {
                Web2PyReferenceResolveProvider.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        String referencedName = element.getReferencedName();
        if ("globals".equals(referencedName)) {
            ArrayList<RatedResolveResult> arrayList = result;
            if (arrayList == null) {
                Web2PyReferenceResolveProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        VirtualFile gluon = Web2PyUtils.findGluon(project);
        if (gluon != null) {
            PsiElement resultElement;
            PsiFile psiFile;
            VirtualFile dalFile;
            if (ourDBGlobals.contains(referencedName) && (dalFile = gluon.findChild("dal.py")) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(dalFile)) instanceof PyFile && (resultElement = ((PyFile)psiFile).getElementNamed(referencedName)) != null) {
                result.add(new RatedResolveResult(PyReferenceImpl.getRate(resultElement, context), resultElement));
            }
            PsiDirectory gluonDirectory = PsiManager.getInstance((Project)project).findDirectory(gluon);
            PsiFile initFile = null;
            if (gluonDirectory != null) {
                initFile = gluonDirectory.findFile("__init__.py");
            }
            if (initFile instanceof PyFile && (resultElement = ((PyFile)initFile).getElementNamed(referencedName)) != null) {
                result.add(new RatedResolveResult(PyReferenceImpl.getRate(resultElement, context), resultElement));
            }
        }
        if ((applicationBase = Web2PyUtils.getApplicationBase(file2)) != null && (models = applicationBase.findSubdirectory("models")) != null) {
            for (PsiFile child : models.getFiles()) {
                PsiElement resultElement;
                if (child.equals(file2) || !(child instanceof PyFile) || (resultElement = ((PyFile)child).getElementNamed(referencedName)) == null) continue;
                result.add(new RatedResolveResult(PyReferenceImpl.getRate(resultElement, context), resultElement));
            }
        }
        ArrayList<RatedResolveResult> arrayList = result;
        if (arrayList == null) {
            Web2PyReferenceResolveProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/web2py/psi/Web2PyReferenceResolveProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/web2py/psi/Web2PyReferenceResolveProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

