/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.project;

import com.intellij.DynamicBundle;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.web2py.project.Web2PyNewProjectSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class Web2PyProjectCreatePanel
extends JPanel {
    private TextFieldWithBrowseButton myWeb2PySourceFolder;
    private JTextField myAppName;
    private JPanel myMainPanel;
    private JBCheckBox myUseDownloaded;

    public Web2PyProjectCreatePanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myMainPanel, "Center");
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor2.withTreeRootVisible(true);
        descriptor2.setShowFileSystemRoots(true);
        this.myWeb2PySourceFolder.addBrowseFolderListener(PythonProBundle.message("python.web2py.select.source.folder.title"), PythonProBundle.message("python.web2py.select.source.folder.description"), null, descriptor2);
        this.myUseDownloaded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Web2PyProjectCreatePanel.this.myWeb2PySourceFolder.setEnabled(Web2PyProjectCreatePanel.this.myUseDownloaded.isSelected());
            }
        });
    }

    public void registerValidators(final @NotNull Runnable runnable) {
        if (runnable == null) {
            Web2PyProjectCreatePanel.$$$reportNull$$$0(0);
        }
        this.myAppName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/web2py/project/Web2PyProjectCreatePanel$2", "textChanged"));
            }
        });
        this.myWeb2PySourceFolder.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/web2py/project/Web2PyProjectCreatePanel$3", "textChanged"));
            }
        });
        this.myWeb2PySourceFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                runnable.run();
            }
        });
        this.myUseDownloaded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                runnable.run();
            }
        });
    }

    public ValidationResult getValidationResult(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            Web2PyProjectCreatePanel.$$$reportNull$$$0(1);
        }
        if (this.myUseDownloaded.isSelected()) {
            String web2PyFolder = this.myWeb2PySourceFolder.getText();
            if (StringUtil.isEmptyOrSpaces((String)web2PyFolder)) {
                return new ValidationResult(PythonProBundle.message("python.web2py.empty.source.folder.validation.error.message"));
            }
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(web2PyFolder);
            if (virtualFile2 == null || virtualFile2.findChild("gluon") == null) {
                return new ValidationResult(PythonProBundle.message("python.web2py.select.source.folder.validation.error.message"));
            }
            File file2 = new File(web2PyFolder);
            File baseDir = new File(baseDirPath);
            if (FileUtil.isAncestor((File)file2, (File)baseDir, (boolean)true)) {
                return new ValidationResult(PythonProBundle.message("python.web2py.copy.to.itself.validation.error.message"));
            }
        }
        return Web2PyProjectCreatePanel.validateNames(this.myAppName.getText());
    }

    public static ValidationResult validateNames(String appName) {
        if (appName.length() > 0 && !StringUtil.isJavaIdentifier((String)appName)) {
            return new ValidationResult(PythonProBundle.message("python.web2py.app.name.validation.error.message"));
        }
        return ValidationResult.OK;
    }

    public void saveSettings(Web2PyNewProjectSettings settings) {
        if (this.myUseDownloaded.isSelected()) {
            settings.setWeb2PyFolder(this.myWeb2PySourceFolder.getText());
        }
        settings.setApplicationName(this.myAppName.getText());
    }

    public ValidationResult getWarnings() {
        if (!this.myUseDownloaded.isSelected()) {
            return new ValidationResult(PythonProBundle.message("python.web2py.download.source.validation.error.message"));
        }
        return ValidationResult.OK;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PythonProBundle", Web2PyProjectCreatePanel.class).getString("python.web2py.app.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAppName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myUseDownloaded = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PythonProBundle", Web2PyProjectCreatePanel.class).getString("python.web2py.use.local"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myWeb2PySourceFolder = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/web2py/project/Web2PyProjectCreatePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerValidators";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidationResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

