/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.annotator;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.web2py.Web2PyUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyControllerLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            Web2PyControllerLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            Web2PyControllerLineMarkerProvider.$$$reportNull$$$0(1);
        }
        Web2PyControllerLineMarkerProvider.collectLineMarkersForElement(result, element);
    }

    private static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement element) {
        RelatedItemLineMarkerInfo<XmlFile> info;
        if (element instanceof XmlFile && Web2PyUtils.isWeb2PyProject(element.getProject()) && (info = Web2PyControllerLineMarkerProvider.createLineMarker((XmlFile)element)) != null) {
            result.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<XmlFile> createLineMarker(XmlFile file2) {
        PyFunction controllerFunction = Web2PyControllerLineMarkerProvider.getControllerFunction((PsiFile)file2);
        if (controllerFunction != null) {
            String templateName = controllerFunction.getName();
            String msg = PythonProBundle.message("python.web2py.referenced.message", templateName);
            ArrayList files = Lists.newArrayList((Object[])new PyFunction[]{controllerFunction});
            return new RelatedItemLineMarkerInfo((PsiElement)file2, file2.getTextRange(), PythonFileType.INSTANCE.getIcon(), 11, (Function)new ConstantFunction((Object)msg), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler((Collection)files, msg), GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems((Collection)files, (String)"Views"));
        }
        return null;
    }

    @Nullable
    public static PyFunction getControllerFunction(@NotNull PsiFile file2) {
        if (file2 == null) {
            Web2PyControllerLineMarkerProvider.$$$reportNull$$$0(2);
        }
        String fileName = Web2PyUtils.getFileNameWithoutExtension((PsiFileSystemItem)file2);
        PsiDirectory directory2 = file2.getContainingDirectory();
        if (directory2 == null) {
            return null;
        }
        PsiDirectory viewsDir = directory2.getParentDirectory();
        if (viewsDir == null) {
            return null;
        }
        PsiDirectory applicationBase = viewsDir.getParentDirectory();
        if (applicationBase == null) {
            return null;
        }
        VirtualFile controller = applicationBase.getVirtualFile().findFileByRelativePath("controllers/" + directory2.getName() + ".py");
        if (controller == null) {
            return null;
        }
        PsiFile psiFile = file2.getManager().findFile(controller);
        if (psiFile instanceof PyFile) {
            PsiElement element = ((PyFile)psiFile).getElementNamed(fileName);
            return element instanceof PyFunction ? (PyFunction)element : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/web2py/annotator/Web2PyControllerLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getControllerFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

