/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyUtils {
    private static final Key<Boolean> WEB2PY_PROJECT = Key.create((String)"WEB2PY_PROJECT");
    private static final Key<Boolean> WEB2PY_APP = Key.create((String)"WEB2PY_APP");

    private Web2PyUtils() {
    }

    public static boolean isWeb2PyProject(Project project) {
        Boolean isWeb2Py = (Boolean)project.getUserData(WEB2PY_PROJECT);
        if (isWeb2Py != null) {
            return isWeb2Py;
        }
        HashSet roots = Sets.newHashSet();
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        for (Module module : modules) {
            roots.addAll(PyUtil.getSourceRoots(module));
        }
        Collections.addAll(roots, ProjectRootManager.getInstance((Project)project).getContentRoots());
        for (VirtualFile root : roots) {
            if (!root.getName().equals("web2py")) continue;
            project.putUserData(WEB2PY_PROJECT, (Object)Boolean.TRUE);
            return true;
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile gluon = baseDir == null ? null : baseDir.findChild("gluon");
        boolean hasGluon = gluon != null;
        project.putUserData(WEB2PY_PROJECT, (Object)hasGluon);
        return hasGluon;
    }

    public static boolean isWeb2PyApp(Project project) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return false;
        }
        return Web2PyUtils.isWeb2PyApp(baseDir);
    }

    public static boolean isWeb2PyApp(@NotNull VirtualFile baseDir) {
        Boolean isWeb2PyApp;
        if (baseDir == null) {
            Web2PyUtils.$$$reportNull$$$0(0);
        }
        if ((isWeb2PyApp = (Boolean)baseDir.getUserData(WEB2PY_APP)) != null) {
            return isWeb2PyApp;
        }
        VirtualFile controllers = baseDir.findChild("controllers");
        VirtualFile views = baseDir.findChild("views");
        VirtualFile models = baseDir.findChild("models");
        isWeb2PyApp = controllers != null && views != null && models != null;
        baseDir.putUserData(WEB2PY_APP, (Object)isWeb2PyApp);
        return isWeb2PyApp;
    }

    @Nullable
    public static VirtualFile getViewFile(@NotNull PyFunction function, boolean isMobile) {
        String viewName;
        if (function == null) {
            Web2PyUtils.$$$reportNull$$$0(1);
        }
        String string = viewName = isMobile ? null : Web2PyUtils.getViewNameDefinedInFunction(function);
        if (viewName == null) {
            viewName = Web2PyUtils.getViewName(function, isMobile);
        }
        if (viewName == null) {
            return null;
        }
        return Web2PyUtils.getViewFileByFunctionName(function, viewName);
    }

    public static String getViewName(@NotNull PyFunction function, boolean isMobile) {
        String functionName;
        if (function == null) {
            Web2PyUtils.$$$reportNull$$$0(2);
        }
        if ((functionName = function.getName()) == null) {
            return null;
        }
        PsiFile file2 = function.getContainingFile();
        if (file2 == null) {
            return null;
        }
        String viewName = Web2PyUtils.getFileNameWithoutExtension((PsiFileSystemItem)file2) + "/" + functionName;
        if (isMobile) {
            viewName = viewName + ".mobile";
        }
        viewName = viewName + ".html";
        return viewName;
    }

    @Nullable
    public static String getViewNameDefinedInFunction(@NotNull PyFunction function) {
        if (function == null) {
            Web2PyUtils.$$$reportNull$$$0(3);
        }
        ViewNameVisitor visitor2 = new ViewNameVisitor();
        function.accept(visitor2);
        return visitor2.myViewName;
    }

    @Nullable
    public static VirtualFile getViewFileByFunctionName(@NotNull PyFunction function, @Nullable String viewName) {
        String functionName;
        if (function == null) {
            Web2PyUtils.$$$reportNull$$$0(4);
        }
        if ((functionName = function.getName()) == null) {
            return null;
        }
        PsiFile file2 = function.getContainingFile();
        if (file2 == null) {
            return null;
        }
        PsiDirectory controllers = file2.getContainingDirectory();
        if (controllers == null) {
            return null;
        }
        PsiDirectory applicationBase = controllers.getParentDirectory();
        if (applicationBase == null) {
            return null;
        }
        return applicationBase.getVirtualFile().findFileByRelativePath("views/" + viewName);
    }

    public static String getFileNameWithoutExtension(@NotNull PsiFileSystemItem file2) {
        String name;
        int index;
        if (file2 == null) {
            Web2PyUtils.$$$reportNull$$$0(5);
        }
        if ((index = (name = file2.getName()).lastIndexOf(46)) < 0) {
            return name;
        }
        String suffix = ".mobile";
        if (name.substring(0, index).endsWith(".mobile")) {
            index = name.lastIndexOf(".mobile");
        }
        return name.substring(0, index);
    }

    @Nullable
    public static VirtualFile findGluon(@NotNull Project project) {
        VirtualFile projectBase;
        if (project == null) {
            Web2PyUtils.$$$reportNull$$$0(6);
        }
        if ((projectBase = LocalFileSystem.getInstance().findFileByPath(project.getBasePath())) == null) {
            return null;
        }
        VirtualFile web2py = projectBase.findChild("web2py");
        if (web2py != null) {
            return web2py.findChild("gluon");
        }
        VirtualFile child = projectBase.findChild("gluon");
        if (child != null) {
            return child;
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length > 0) {
            VirtualFile parent = projectBase.getParent().getParent();
            if (parent.getName().equals("web2py")) {
                return parent.findChild("gluon");
            }
            Sdk sdk = PythonSdkUtil.findPythonSdk(modules[0]);
            if (sdk instanceof ProjectJdkImpl) {
                VirtualFile[] roots;
                PyPackage web2pyPackage;
                List<PyPackage> packages = PyPackageManager.getInstance(sdk).getPackages();
                PyPackage pyPackage = web2pyPackage = packages != null ? PyPsiPackageUtil.findPackage(packages, "web2py") : null;
                if (web2pyPackage == null) {
                    return null;
                }
                for (VirtualFile root : roots = ((ProjectJdkImpl)sdk).getRoots(OrderRootType.CLASSES)) {
                    VirtualFile rootChild = root.findChild("gluon");
                    if (rootChild == null) continue;
                    return rootChild;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getApplicationBase(@NotNull PsiFile file2) {
        PsiDirectory parentDirectory;
        PsiDirectory directory2;
        if (file2 == null) {
            Web2PyUtils.$$$reportNull$$$0(7);
        }
        for (directory2 = file2.getContainingDirectory(); !(directory2 == null || directory2.getVirtualFile().equals(file2.getProject().getBaseDir()) || (parentDirectory = directory2.getParentDirectory()) != null && "applications".equals(parentDirectory.getName())); directory2 = directory2.getParentDirectory()) {
        }
        return directory2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/web2py/Web2PyUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWeb2PyApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewNameDefinedInFunction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getViewFileByFunctionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileNameWithoutExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findGluon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicationBase";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ViewNameVisitor
    extends PyRecursiveElementVisitor {
        private String myViewName;

        ViewNameVisitor() {
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            PyExpression expression;
            super.visitPyStringLiteralExpression(node);
            PsiElement parent = node.getParent();
            if (parent instanceof PyAssignmentStatement && (expression = ((PyAssignmentStatement)parent).getLeftHandSideExpression()) instanceof PyTargetExpression && expression.getText().equals("response.view")) {
                this.myViewName = node.getStringValue();
            }
        }
    }
}

