/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sqlalchemy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLAlchemyTypeProvider
extends PyTypeProviderBase {
    private static final Map<String, String> ourQNameToClass = ImmutableMap.builder().put((Object)"Interval", (Object)"datetime.timedelta").put((Object)"DateTime", (Object)"datetime.datetime").put((Object)"Date", (Object)"datetime.date").put((Object)"Time", (Object)"datetime.time").build();
    private static final Map<String, String> ourEngineToClass = ImmutableMap.builder().put((Object)"plain", (Object)"sqlalchemy.engine.base.Engine").put((Object)"threadlocal", (Object)"sqlalchemy.engine.threadlocal.TLEngine").put((Object)"mock", (Object)"sqlalchemy.engine.strategies.MockEngineStrategy.MockConnection").build();
    private static final Map<String, String> ourQNameToBuiltin = ImmutableMap.builder().put((Object)"Integer", (Object)"int").put((Object)"Numeric", (Object)"float").put((Object)"Boolean", (Object)"bool").build();

    @Override
    public Ref<PyType> getReferenceType(@NotNull PsiElement referenceTarget, @NotNull TypeEvalContext context, @Nullable PsiElement anchor) {
        if (referenceTarget == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(1);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
        if (referenceTarget instanceof PyTargetExpression && referenceTarget.getContainingFile() instanceof PyFile) {
            PyTargetExpression target = (PyTargetExpression)referenceTarget;
            QualifiedName calleeName = target.getCalleeName();
            PyFile pyFile = (PyFile)target.getContainingFile();
            if (SQLAlchemyTypeProvider.isColumnDefinition(target, context)) {
                PyCallExpression call = PyUtil.as(target.findAssignedValue(), PyCallExpression.class);
                if (call != null) {
                    int index;
                    PyExpression[] args2;
                    for (PyExpression arg : args2 = call.getArguments()) {
                        if (!(arg instanceof PyKeywordArgument) || !"type_".equals(((PyKeywordArgument)arg).getKeyword())) continue;
                        return PyTypeUtil.notNullToRef(SQLAlchemyTypeProvider.getColumnType(((PyKeywordArgument)arg).getValueExpression()));
                    }
                    int n = index = args2.length > 0 && args2[0] instanceof PyStringLiteralExpression ? 1 : 0;
                    if (args2.length > index) {
                        return PyTypeUtil.notNullToRef(SQLAlchemyTypeProvider.getColumnType(args2[index]));
                    }
                }
            } else if (SQLAlchemyTypeProvider.isRelationshipDefinition(target, context)) {
                PyCallExpression call = PyUtil.as(target.findAssignedValue(), PyCallExpression.class);
                if (call != null) {
                    StreamEx modelReferenceTypes;
                    boolean isManyToMany;
                    PyBuiltinCache instance = PyBuiltinCache.getInstance((PsiElement)call);
                    PyClass list = instance.getClass("list");
                    if (list == null) {
                        return null;
                    }
                    PyExpression modelReference = call.getArgument(0, PyExpression.class);
                    boolean bl = isManyToMany = call.getKeywordArgument("secondary") != null;
                    if (modelReference instanceof PyReferenceExpression) {
                        modelReferenceTypes = PyTypeUtil.toStream(context.getType(modelReference));
                    } else if (modelReference instanceof PyStringLiteralExpression) {
                        String stringValue = ((PyStringLiteralExpression)modelReference).getStringValue();
                        QualifiedName referencedName = QualifiedName.fromDottedString((String)stringValue);
                        modelReferenceTypes = StreamEx.of(PyResolveUtil.resolveQualifiedNameInScope(referencedName, pyFile, context)).select(PyTypedElement.class).map(context::getType);
                    } else {
                        return null;
                    }
                    return ((StreamEx)modelReferenceTypes.select(PyClassType.class).filter(x -> SQLAlchemyTypeProvider.isDeclarativeModelClass(x.getPyClass(), context))).map(PyInstantiableType::toInstance).map(x -> isManyToMany ? new PyCollectionTypeImpl(list, false, Collections.singletonList(x)) : x).select(PyType.class).foldLeft(PyUnionType::union).map(Ref::create).orElse(null);
                }
            } else {
                String name = target.getName();
                if (name != null && StringUtil.containsIgnoreCase((String)name, (String)"session")) {
                    return PyTypeUtil.notNullToRef(SQLAlchemyTypeProvider.getSessionType(target, resolveContext));
                }
            }
            if (calleeName != null && SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile, context, PyFunction.class, "sqlalchemy.ext.declarative.api.declarative_base")) {
                return PyTypeUtil.notNullToRef(SQLAlchemyTypeProvider.getDeclarativeMetaInstanceType(target));
            }
        } else if (referenceTarget instanceof PyFunction) {
            return PyTypeUtil.notNullToRef(SQLAlchemyTypeProvider.getHybridPropertyType((PyFunction)referenceTarget, resolveContext));
        }
        return null;
    }

    private static boolean isColumnDefinition(@NotNull PyTargetExpression target, TypeEvalContext context) {
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(2);
        }
        if (!(ScopeUtil.getScopeOwner(target) instanceof PyClass)) {
            return false;
        }
        QualifiedName calleeName = target.getCalleeName();
        PyFile pyFile = PyUtil.as(target.getContainingFile(), PyFile.class);
        return calleeName != null && pyFile != null && SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile, context, PyClass.class, "sqlalchemy.sql.schema.Column");
    }

    private static boolean isRelationshipDefinition(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context) {
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(4);
        }
        if (!(ScopeUtil.getScopeOwner(target) instanceof PyClass)) {
            return false;
        }
        QualifiedName calleeName = target.getCalleeName();
        PyFile pyFile = PyUtil.as(target.getContainingFile(), PyFile.class);
        return calleeName != null && pyFile != null && SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(calleeName, pyFile, context, PyQualifiedNameOwner.class, "sqlalchemy.orm.relation", "sqlalchemy.orm.relationship");
    }

    @Override
    @Nullable
    public PyType getReferenceExpressionType(@NotNull PyReferenceExpression referenceExpression, @NotNull TypeEvalContext context) {
        List<PsiElement> resolved;
        PyClassType qualifierType;
        PyClass modelClass;
        if (referenceExpression == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(5);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(6);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context);
        PyCallExpression call = PyUtil.as(referenceExpression.getParent(), PyCallExpression.class);
        if (call != null && (modelClass = SQLAlchemyTypeProvider.findDeclarativeModelClass(referenceExpression.getReference(resolveContext), context)) != null) {
            List<PyTargetExpression> allClassAttributes = modelClass.getClassAttributesInherited(context);
            PyElementGenerator generator = PyElementGenerator.getInstance(referenceExpression.getProject());
            PyExpression defaultValue = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)referenceExpression), "None");
            List parameters = ((StreamEx)StreamEx.of(allClassAttributes).filter(target -> SQLAlchemyTypeProvider.isColumnDefinition(target, context) || SQLAlchemyTypeProvider.isRelationshipDefinition(target, context))).map(attr -> PyCallableParameterImpl.nonPsi(attr.getName(), context.getType((PyTypedElement)attr), defaultValue)).toList();
            return new PyCallableTypeImpl(parameters, new PyClassTypeImpl(modelClass, false));
        }
        PyExpression qualifier = referenceExpression.getQualifier();
        if (qualifier != null && (qualifierType = PyUtil.as(context.getType(qualifier), PyClassType.class)) != null && qualifierType.isDefinition() && SQLAlchemyTypeProvider.isDeclarativeModelClass(qualifierType.getPyClass(), context) && StreamEx.of(resolved = PyUtil.multiResolveTopPriority((PsiElement)referenceExpression, resolveContext)).select(PyTargetExpression.class).anyMatch(e -> SQLAlchemyTypeProvider.isColumnDefinition(e, context))) {
            return (PyType)Ref.deref((Ref)((Ref)StreamEx.of(resolved).select(PyTypedElement.class).map(elem -> {
                if (elem instanceof PyTargetExpression && SQLAlchemyTypeProvider.isColumnDefinition((PyTargetExpression)elem, context)) {
                    return SQLAlchemyTypeProvider.getClassType((PsiElement)elem, "sqlalchemy.orm.attributes.InstrumentedAttribute", false);
                }
                return context.getType((PyTypedElement)elem);
            }).collect(PyTypeUtil.toUnion())));
        }
        return null;
    }

    @Nullable
    private static PyClass findDeclarativeModelClass(@NotNull PsiPolyVariantReference reference, @NotNull TypeEvalContext context) {
        if (reference == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(8);
        }
        return StreamEx.of(PyUtil.multiResolveTopPriority(reference)).select(PyClass.class).findFirst(cls -> SQLAlchemyTypeProvider.isDeclarativeModelClass(cls, context)).orElse(null);
    }

    public static boolean isDeclarativeModelClass(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        PyClassLikeType metaClass;
        if (pyClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(10);
        }
        if ((metaClass = pyClass.getMetaClassType(true, context)) instanceof PyClassType && ((PyClassType)metaClass).getPyClass() == SQLAlchemyTypeProvider.getDeclarativeMetaClass((PsiElement)pyClass)) {
            return true;
        }
        List<PyClass> ancestors = pyClass.getAncestorClasses(context);
        return ContainerUtil.exists(ancestors, cls -> SQLAlchemyTypeProvider.isDecoratedWithAsDeclarative(cls, context));
    }

    private static boolean isDecoratedWithAsDeclarative(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(12);
        }
        PyDecoratorList decoratorList = pyClass.getDecoratorList();
        PsiFile file2 = pyClass.getContainingFile();
        if (decoratorList != null && file2 instanceof PyFile) {
            return StreamEx.of((Object[])decoratorList.getDecorators()).map(PyDecorator::getQualifiedName).anyMatch(qn -> SQLAlchemyTypeProvider.resolvesToQualifiedNameOwner(qn, (PyFile)file2, context, PyFunction.class, "sqlalchemy.ext.declarative.api.as_declarative"));
        }
        return false;
    }

    @Override
    @Nullable
    public Ref<PyType> getReturnType(@NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        PyClassType type;
        PyFunction function;
        if (callable == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(13);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(14);
        }
        if ((function = PyUtil.as(callable, PyFunction.class)) == null) {
            return null;
        }
        if ("sqlalchemy.ext.declarative.api.declarative_base".equals(function.getQualifiedName()) && (type = SQLAlchemyTypeProvider.getDeclarativeMetaInstanceType((PsiElement)callable)) != null) {
            return Ref.create((Object)type);
        }
        return null;
    }

    private static boolean resolvesToQualifiedNameOwner(@NotNull QualifiedName actual, @NotNull PyFile anchor, @NotNull TypeEvalContext context, @NotNull Class<? extends PyQualifiedNameOwner> expectedClass, String ... expected) {
        if (actual == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(15);
        }
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(16);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(17);
        }
        if (expectedClass == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(18);
        }
        if (expected == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(19);
        }
        List expectedQualified = ContainerUtil.map((Object[])expected, QualifiedName::fromDottedString);
        HashSet expectedUnique = Sets.newHashSet((Object[])expected);
        if (ContainerUtil.exists((Iterable)expectedQualified, qn -> actual.endsWith(qn.getLastComponent()))) {
            return StreamEx.of(PyResolveUtil.resolveQualifiedNameInScope(actual, anchor, context)).select(expectedClass).map(PyQualifiedNameOwner::getQualifiedName).anyMatch(expectedUnique::contains);
        }
        return false;
    }

    @Nullable
    private static PyClassType getDeclarativeMetaInstanceType(@NotNull PsiElement anchor) {
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(20);
        }
        return SQLAlchemyTypeProvider.getClassType(anchor, "sqlalchemy.ext.declarative.api.DeclarativeMeta", false);
    }

    @Nullable
    private static PyClass getDeclarativeMetaClass(@NotNull PsiElement anchor) {
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(21);
        }
        return PyPsiFacade.getInstance(anchor.getProject()).createClassByQName("sqlalchemy.ext.declarative.api.DeclarativeMeta", anchor);
    }

    @Nullable
    private static PyClassType getClassType(@NotNull PsiElement anchor, @NotNull String qualifiedName, boolean isDefinition) {
        PyPsiFacade facade;
        PyClass pyClass;
        if (anchor == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(22);
        }
        if (qualifiedName == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(23);
        }
        return (pyClass = (facade = PyPsiFacade.getInstance(anchor.getProject())).createClassByQName(qualifiedName, anchor)) != null ? facade.createClassType(pyClass, isDefinition) : null;
    }

    @Nullable
    private static PyType getHybridPropertyType(@NotNull PyFunction target, @NotNull PyResolveContext resolveContext) {
        PyDecoratorList decoratorList;
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(24);
        }
        if (resolveContext == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(25);
        }
        if ((decoratorList = target.getDecoratorList()) != null) {
            PyClass hybridPropertyClass = PyClassNameIndex.findClass("sqlalchemy.ext.hybrid.hybrid_property", target.getProject());
            if (hybridPropertyClass == null) {
                return null;
            }
            if (decoratorList.findDecorator("hybrid_property") != null) {
                return new PyClassTypeImpl(hybridPropertyClass, false);
            }
            boolean resolvesToHybridProperty = Arrays.stream(decoratorList.getDecorators()).filter(decorator -> {
                QualifiedName qualifiedName = decorator.getQualifiedName();
                return qualifiedName != null && ArrayUtil.contains((String)qualifiedName.getLastComponent(), (String[])new String[]{"setter", "deleter", "getter", "expression", "comparator"});
            }).flatMap(decorator -> decorator.multiResolveCalleeFunction(resolveContext).stream()).map(PyQualifiedNameOwner::getQualifiedName).anyMatch(callableQName -> callableQName != null && callableQName.startsWith("sqlalchemy.ext.hybrid.hybrid_property"));
            if (resolvesToHybridProperty) {
                return new PyClassTypeImpl(hybridPropertyClass, false);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getSessionType(@NotNull PyTargetExpression target, @NotNull PyResolveContext resolveContext) {
        PyExpression value2;
        if (target == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(26);
        }
        if (resolveContext == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(27);
        }
        if ((value2 = target.findAssignedValue()) instanceof PyCallExpression) {
            PyCallExpression sessionMakerCall;
            boolean resolvesToSessionMakerInit;
            PyExpression valueAssignedToInitialTarget;
            PyTargetExpression initialTarget;
            QualifiedName calleeName;
            PyExpression callee = ((PyCallExpression)value2).getCallee();
            if (callee == null) {
                return null;
            }
            PsiReference reference = callee.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PyTargetExpression && (calleeName = (initialTarget = (PyTargetExpression)resolved).getCalleeName()) != null && "sessionmaker".equals(calleeName.toString()) && (valueAssignedToInitialTarget = initialTarget.findAssignedValue()) instanceof PyCallExpression && (resolvesToSessionMakerInit = ContainerUtil.exists((sessionMakerCall = (PyCallExpression)valueAssignedToInitialTarget).multiResolveCalleeFunction(resolveContext), callable -> "sqlalchemy.orm.session.sessionmaker.__init__".equals(callable.getQualifiedName())))) {
                PsiElement sessionClass;
                PyExpression clazz = sessionMakerCall.getKeywordArgument("class_");
                PsiElement psiElement = sessionClass = clazz instanceof PyReferenceExpression ? ((PyReferenceExpression)clazz).getReference().resolve() : null;
                if (sessionClass instanceof PyClass) {
                    return new PyClassTypeImpl((PyClass)sessionClass, false);
                }
                PyClass defaultClass = PyClassNameIndex.findClass("sqlalchemy.orm.session.Session", value2.getProject());
                if (defaultClass != null) {
                    return new PyClassTypeImpl(defaultClass, false);
                }
            }
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getEngineType(@NotNull PyCallExpression callExpr) {
        PyExpression argument;
        if (callExpr == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(28);
        }
        String strategy = (argument = callExpr.getKeywordArgument("strategy")) instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)argument).getStringValue() : "plain";
        return Optional.ofNullable(ourEngineToClass.get(strategy)).map(className -> PyClassTypeImpl.createTypeByQName((PsiElement)callExpr, className, false)).map(Ref::create).orElse(null);
    }

    @Override
    @Nullable
    public Ref<PyType> getCallType(@NotNull PyFunction function, @NotNull PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyDecoratorList decoratorList;
        if (function == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(29);
        }
        if (callSite == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(30);
        }
        if (context == null) {
            SQLAlchemyTypeProvider.$$$reportNull$$$0(31);
        }
        if ((decoratorList = function.getDecoratorList()) != null) {
            PyClass containingClass = function.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                PyResolveContext resolveContext;
                boolean resolvesToGenerative;
                if (!"_generative".equals(decorator.getName()) || !(resolvesToGenerative = decorator.multiResolveCalleeFunction(resolveContext = PyResolveContext.defaultContext().withTypeEvalContext(context)).stream().map(PyQualifiedNameOwner::getQualifiedName).anyMatch(qName -> "sqlalchemy.sql.expression._generative".equals(qName) || "sqlalchemy.orm.query._generative".equals(qName)))) continue;
                return Ref.create((Object)new PyClassTypeImpl(containingClass, false));
            }
        }
        if (callSite instanceof PyCallExpression && "sqlalchemy.engine.create_engine".equals(function.getQualifiedName())) {
            return SQLAlchemyTypeProvider.getEngineType((PyCallExpression)callSite);
        }
        if ("sqlalchemy.orm.session.Session.query".equals(function.getQualifiedName())) {
            return Ref.create((Object)PyClassTypeImpl.createTypeByQName(function, "sqlalchemy.orm.query.Query", false));
        }
        return null;
    }

    @Nullable
    private static PyType getColumnType(PyExpression expression) {
        if (expression instanceof PyCallExpression) {
            expression = ((PyCallExpression)expression).getCallee();
        }
        if (!(expression instanceof PyReferenceExpression)) {
            return null;
        }
        Object result = ((PyReferenceExpression)expression).getReference(PyResolveContext.defaultContext()).resolve();
        if (result instanceof PyFunction) {
            result = ((PyFunction)result).getContainingClass();
        }
        if (!(result instanceof PyClass)) {
            return null;
        }
        Property pythonType = ((PyClass)result).findProperty("python_type", true, null);
        if (pythonType != null && pythonType.getGetter().isDefined()) {
            PyCallable value2 = pythonType.getGetter().value();
            if (!(value2 instanceof PyFunction)) {
                return null;
            }
            PyClass containingClass = ((PyFunction)value2).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return SQLAlchemyTypeProvider.getColumnType(containingClass);
        }
        return null;
    }

    @Nullable
    private static PyType getColumnType(PyClass columnClass) {
        PyClass aClass;
        PyBuiltinCache cache2 = PyBuiltinCache.getInstance((PsiElement)columnClass);
        String text2 = columnClass.getName();
        assert (text2 != null);
        if (text2.equals("String")) {
            return cache2.getStringType(LanguageLevel.forElement((PsiElement)columnClass));
        }
        if (text2.equals("_Binary")) {
            return cache2.getBytesType(LanguageLevel.forElement((PsiElement)columnClass));
        }
        String className = ourQNameToClass.get(text2);
        if (className != null && (aClass = PyClassNameIndex.findClass(className, columnClass.getProject())) != null) {
            return new PyClassTypeImpl(aClass, false);
        }
        String builtinName = ourQNameToBuiltin.get(text2);
        if (builtinName != null) {
            return cache2.getObjectType(builtinName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceTarget";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/sqlalchemy/SQLAlchemyTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isColumnDefinition";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isRelationshipDefinition";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceExpressionType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findDeclarativeModelClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeclarativeModelClass";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isDecoratedWithAsDeclarative";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getReturnType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvesToQualifiedNameOwner";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclarativeMetaInstanceType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclarativeMetaClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "getHybridPropertyType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "getSessionType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "getEngineType";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

