/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.testing.PyTestFrameworkService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VFSTestFrameworkListener {
    private static final Logger LOG = Logger.getInstance(VFSTestFrameworkListener.class);
    private final AtomicBoolean myIsUpdating = new AtomicBoolean(false);
    private final PyTestFrameworkService myService = PyTestFrameworkService.getInstance();
    private final MergingUpdateQueue myQueue;

    public static VFSTestFrameworkListener getInstance() {
        return (VFSTestFrameworkListener)ApplicationManager.getApplication().getComponent(VFSTestFrameworkListener.class);
    }

    public VFSTestFrameworkListener() {
        Application application = ApplicationManager.getApplication();
        MessageBus messageBus = application.getMessageBus();
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileContentChangeEvent) continue;
                    String path = vFileEvent.getPath();
                    HashSet<String> existingFrameworks = new HashSet<String>();
                    for (String framework : PyTestFrameworkService.getFrameworkNamesSet()) {
                        if (path.contains(framework)) {
                            existingFrameworks.add(framework);
                        }
                        if (!path.contains("py-1")) continue;
                        existingFrameworks.add("pytest");
                    }
                    if (existingFrameworks.isEmpty()) continue;
                    for (Sdk sdk : PythonSdkUtil.getAllSdks()) {
                        if (PythonSdkUtil.isRemote(sdk)) continue;
                        for (VirtualFile virtualFile2 : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                            String root = virtualFile2.getCanonicalPath();
                            if (root == null || !path.contains(root)) continue;
                            String framework = (String)existingFrameworks.iterator().next();
                            VFSTestFrameworkListener.this.scheduleTestFrameworkCheck(sdk, framework);
                            return;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/testing/VFSTestFrameworkListener$1", "after"));
            }
        });
        this.myQueue = new MergingUpdateQueue("TestFrameworkChecker", 5000, true, null, (Disposable)application, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public void updateAllTestFrameworks(@NotNull Sdk sdk) {
        if (sdk == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(0);
        }
        Map<String, Boolean> whichInstalled = this.checkTestFrameworksInstalled(sdk, PyTestFrameworkService.getFrameworkNamesArray());
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Map.Entry entry : whichInstalled.entrySet()) {
                Boolean installed = (Boolean)entry.getValue();
                if (installed == null) continue;
                this.setTestFrameworkInstalled(installed, sdk.getHomePath(), (String)entry.getKey());
            }
        });
    }

    private void scheduleTestFrameworkCheck(final @NotNull Sdk sdk, final @NotNull String testPackageName) {
        if (sdk == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(1);
        }
        if (testPackageName == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(2);
        }
        this.myQueue.queue(new Update(Pair.create((Object)sdk, (Object)testPackageName)){

            public void run() {
                VFSTestFrameworkListener.this.checkFrameworkInstalledAndUpdateSettings(sdk, testPackageName);
            }
        });
    }

    private void checkFrameworkInstalledAndUpdateSettings(@Nullable Sdk sdk, @NotNull String testPackageName) {
        Boolean installed;
        if (testPackageName == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(3);
        }
        if ((installed = this.checkTestFrameworkInstalled(sdk, testPackageName)) != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.setTestFrameworkInstalled(installed, sdk.getHomePath(), testPackageName));
        }
    }

    @Contract(value="null, _ -> null")
    private Boolean checkTestFrameworkInstalled(@Nullable Sdk sdk, @NotNull String testFrameworkName) {
        if (testFrameworkName == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(4);
        }
        return this.checkTestFrameworksInstalled(sdk, testFrameworkName).get(testFrameworkName);
    }

    @NotNull
    private Map<String, Boolean> checkTestFrameworksInstalled(@Nullable Sdk sdk, String ... testFrameworkNames) {
        List<PyPackage> packages;
        if (testFrameworkNames == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(5);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (sdk == null || StringUtil.isEmptyOrSpaces((String)sdk.getHomePath())) {
            LOG.info("Searching test runner in empty sdk");
            HashMap<String, Boolean> hashMap = result;
            if (hashMap == null) {
                VFSTestFrameworkListener.$$$reportNull$$$0(6);
            }
            return hashMap;
        }
        PyPackageManager manager = PyPackageManager.getInstance(sdk);
        boolean refreshed = PyPackageUtil.updatePackagesSynchronouslyWithGuard(manager, this.myIsUpdating);
        if (refreshed && (packages = manager.getPackages()) != null) {
            for (String frameworkName : testFrameworkNames) {
                result.put(frameworkName, PyPsiPackageUtil.findPackage(packages, frameworkName) != null);
            }
        }
        HashMap<String, Boolean> hashMap = result;
        if (hashMap == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    public boolean isTestFrameworkInstalled(@Nullable Sdk sdk, @NotNull String name) {
        if (name == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(8);
        }
        if (sdk == null) {
            return false;
        }
        Boolean isInstalled = this.myService.getSdkToTestRunnerByName(name).get(sdk.getHomePath());
        if (isInstalled == null) {
            this.scheduleTestFrameworkCheck(sdk, name);
            return true;
        }
        return isInstalled;
    }

    public final void setTestFrameworkInstalled(boolean installed, @NotNull String sdkHome, @NotNull String name) {
        if (sdkHome == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(9);
        }
        if (name == null) {
            VFSTestFrameworkListener.$$$reportNull$$$0(10);
        }
        this.myService.getSdkToTestRunnerByName(name).put(sdkHome, installed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testPackageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/VFSTestFrameworkListener";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/VFSTestFrameworkListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkTestFrameworksInstalled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAllTestFrameworks";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleTestFrameworkCheck";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFrameworkInstalledAndUpdateSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkTestFrameworkInstalled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkTestFrameworksInstalled";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTestFrameworkInstalled";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTestFrameworkInstalled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

