/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.testing.PyTestFrameworkService;
import com.jetbrains.python.testing.TestRunnerService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class TestRunnerDetector
implements Function<Pair<Module, Collection<VirtualFile>>, TestRunnerService.ServiceState> {
    private static final Logger LOG = Logger.getInstance(TestRunnerDetector.class);

    TestRunnerDetector() {
    }

    public TestRunnerService.ServiceState fun(@NotNull Pair<Module, Collection<VirtualFile>> pair) {
        Module module;
        if (pair == null) {
            TestRunnerDetector.$$$reportNull$$$0(0);
        }
        if ((module = (Module)pair.first).isDisposed()) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        assert (!application.isDispatchThread()) : "This method should not be called on AWT";
        String testRunner = (String)ReadAction.compute(() -> TestRunnerDetector.detectTestRunnerFromSetupPy(module));
        assert (testRunner != null) : "detectTestRunnerFromSetupPy can't return null";
        if (!testRunner.isEmpty()) {
            LOG.debug("Test runner '" + testRunner + "' was discovered from setup.py in the module '" + module.getModuleFilePath() + "'");
            return new TestRunnerService.ServiceState(testRunner);
        }
        Collection pyFiles = (Collection)pair.second;
        for (VirtualFile file2 : pyFiles) {
            if (!file2.getName().startsWith("test") || (testRunner = (String)ReadAction.compute(() -> TestRunnerDetector.checkImports(file2, module))).isEmpty()) continue;
            LOG.debug("Test runner '" + testRunner + "' was detected from imports in the file '" + file2.getPath() + "'");
            return new TestRunnerService.ServiceState(testRunner);
        }
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk != null && sdk.getSdkType() instanceof PythonSdkType) {
            List<PyPackage> packages = PyPackageUtil.refreshAndGetPackagesModally(sdk);
            for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                if (PyPsiPackageUtil.findPackage(packages, framework) == null) continue;
                testRunner = PyTestFrameworkService.getSdkReadableNameByFramework(framework);
                break;
            }
        }
        if (!testRunner.isEmpty()) {
            LOG.debug("Test runner '" + testRunner + "' was detected from SDK " + sdk);
            return new TestRunnerService.ServiceState(testRunner);
        }
        return null;
    }

    @NotNull
    private static String checkImports(@NotNull VirtualFile file2, @NotNull Module module) {
        if (file2 == null) {
            TestRunnerDetector.$$$reportNull$$$0(1);
        }
        if (module == null) {
            TestRunnerDetector.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file2);
        if (psiFile instanceof PyFile) {
            List<PyImportElement> importTargets = ((PyFile)psiFile).getImportTargets();
            for (PyImportElement importElement : importTargets) {
                for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                    if (!framework.equals(importElement.getVisibleName())) continue;
                    String string = PyTestFrameworkService.getSdkReadableNameByFramework(framework);
                    if (string == null) {
                        TestRunnerDetector.$$$reportNull$$$0(3);
                    }
                    return string;
                }
            }
        }
        return "";
    }

    @NotNull
    private static String detectTestRunnerFromSetupPy(@NotNull Module module) {
        PyCallExpression setupCall;
        if (module == null) {
            TestRunnerDetector.$$$reportNull$$$0(4);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module)) == null) {
            return "";
        }
        for (String argumentName : Arrays.asList("test_loader", "test_suite")) {
            PyExpression argumentValue = setupCall.getKeywordArgument(argumentName);
            if (!(argumentValue instanceof PyStringLiteralExpression)) continue;
            String stringValue = ((PyStringLiteralExpression)argumentValue).getStringValue();
            for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                if (!stringValue.contains(framework)) continue;
                String string = PyTestFrameworkService.getSdkReadableNameByFramework(framework);
                if (string == null) {
                    TestRunnerDetector.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/TestRunnerDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/TestRunnerDetector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImports";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectTestRunnerFromSetupPy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fun";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectTestRunnerFromSetupPy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

