/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.python.resourceRoots.ResourceRootProvider;
import com.jetbrains.python.templateLanguages.PyTemplatesServiceImpl;
import com.jetbrains.python.templateLanguages.TemplatesService;
import org.jetbrains.annotations.NotNull;

public class PyTemplateLanguageSubstitutor
extends LanguageSubstitutor {
    public Language getLanguage(@NotNull VirtualFile vFile, @NotNull Project project) {
        if (vFile == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PyTemplateLanguageSubstitutor.$$$reportNull$$$0(1);
        }
        return (Language)ApplicationManager.getApplication().runReadAction((Computable)((NullableComputable)() -> {
            Module module;
            VirtualFile original;
            VirtualFile virtualFile2 = vFile;
            if (virtualFile2 instanceof VirtualFileWindow) {
                virtualFile2 = ((VirtualFileWindow)virtualFile2).getDelegate();
            }
            if (virtualFile2 instanceof LightVirtualFile && (original = ((LightVirtualFile)virtualFile2).getOriginalFile()) != null) {
                virtualFile2 = original;
            }
            if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile2, (Project)project)) == null || module.isDisposed()) {
                return null;
            }
            Language language = TemplatesService.getInstance(module).getSelectedTemplateLanguage();
            if (language == null) {
                return null;
            }
            VirtualFileSystem fileSystem = vFile.getFileSystem();
            boolean resource = ResourceRootProvider.getAllResourceRoots(module).stream().map(arg_0 -> ((VirtualFileSystem)fileSystem).findFileByPath(arg_0)).filter(o -> o != null).anyMatch(o -> VfsUtilCore.isAncestor((VirtualFile)o, (VirtualFile)vFile, (boolean)false));
            if (resource) {
                return null;
            }
            String fileName = vFile.getName();
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            for (FileType possibleType : PyTemplatesServiceImpl.getTemplateFileTypes(module)) {
                for (FileNameMatcher matcher : fileTypeManager.getAssociations(possibleType)) {
                    if (!matcher.acceptsCharSequence((CharSequence)fileName)) continue;
                    return language;
                }
            }
            return null;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "vFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/templateLanguages/PyTemplateLanguageSubstitutor";
        objectArray[2] = "getLanguage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

