/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.cells;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.scientific.PySciProjectComponent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class PyEditorCellManager
implements StartupActivity,
CaretListener {
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create((String)"PyEditorCellManager.LINE_MARKER_IN_EDITOR_KEY");
    private MyListener myListener;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            PyEditorCellManager.$$$reportNull$$$0(0);
        }
        PySciProjectComponent.getInstance(project).addSciViewListener(new PySciProjectComponent.SciViewListener(){

            @Override
            public void sciViewStatusChanged(boolean enabled) {
                if (enabled) {
                    PyEditorCellManager.this.register(project);
                } else {
                    PyEditorCellManager.this.unregister();
                }
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        });
        if (PySciProjectComponent.getInstance(project).shouldUseSciView()) {
            this.register(project);
        }
    }

    private synchronized void unregister() {
        if (this.myListener != null) {
            Editor[] editors;
            EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            eventMulticaster.removeDocumentListener((DocumentListener)this.myListener);
            eventMulticaster.removeCaretListener((CaretListener)this.myListener);
            for (Editor editor2 : editors = EditorFactory.getInstance().getAllEditors()) {
                PyEditorCellManager.removeLineMarkers(editor2);
            }
            this.myListener = null;
        }
    }

    private synchronized void register(@NotNull Project project) {
        Editor[] editors;
        if (project == null) {
            PyEditorCellManager.$$$reportNull$$$0(1);
        }
        if (this.myListener != null) {
            return;
        }
        this.myListener = new MyListener(project);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener((CaretListener)this.myListener, (Disposable)project);
        eventMulticaster.addDocumentListener((DocumentListener)this.myListener, (Disposable)project);
        for (Editor editor2 : editors = EditorFactory.getInstance().getAllEditors()) {
            PyEditorCellManager.update(project, editor2);
        }
    }

    private static void update(@NotNull Project project, Editor editor2) {
        if (project == null) {
            PyEditorCellManager.$$$reportNull$$$0(2);
        }
        if (!PySciProjectComponent.getInstance(project).shouldUseSciView()) {
            return;
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (editor2.getProject() != project || selectionModel.hasSelection()) {
            return;
        }
        Document document = editor2.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        int line2 = editor2.getCaretModel().getLogicalPosition().line;
        if (line2 < 0 || line2 > document.getLineCount()) {
            return;
        }
        PyEditorCellManager.updateHighlighting(project, editor2);
    }

    private static void updateHighlighting(Project project, @NotNull Editor editor2) {
        if (editor2 == null) {
            PyEditorCellManager.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> {
            PyEditorCellManager.removeLineMarkers(editor2);
            Pair<PsiElement, PsiElement> startEndBlock = PyEditorCellManager.findBlock(project, editor2);
            if (startEndBlock.first != null && PyCellUtil.hasCells(((PsiElement)startEndBlock.first).getContainingFile())) {
                int startLine = editor2.getDocument().getLineNumber(((PsiElement)startEndBlock.first).getTextOffset());
                int endLine = startEndBlock.second != null ? editor2.getDocument().getLineNumber(((PsiElement)startEndBlock.second).getTextOffset()) : editor2.getDocument().getLineCount();
                PyEditorCellManager.highlightCell(editor2, startLine, endLine - 1);
            }
        });
    }

    private static Pair<PsiElement, PsiElement> findBlock(Project project, Editor editor2) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        PsiElement startElement = null;
        PsiElement endElement = null;
        if (file2 != null) {
            PsiElement elementAtCaret = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)editor2.getCaretModel().getOffset(), PsiElement.class, (boolean)false);
            if (elementAtCaret == null) {
                elementAtCaret = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)(editor2.getCaretModel().getOffset() - 2), PsiElement.class, (boolean)false);
            }
            if (elementAtCaret != null && (startElement = PyCellUtil.getCellStart(elementAtCaret)) != null) {
                endElement = PyCellUtil.findNextCell(startElement);
            }
        }
        return Pair.create(startElement, endElement);
    }

    private static void highlightCell(@NotNull Editor editor2, int startLine, int endLine) {
        EditorColorsScheme scheme;
        TextAttributes attributes;
        Color color;
        if (editor2 == null) {
            PyEditorCellManager.$$$reportNull$$$0(4);
        }
        if ((color = (attributes = (scheme = editor2.getColorsScheme()).getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES)).getBackgroundColor()) == null) {
            return;
        }
        color = ColorUtil.isDark((Color)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker();
        PyEditorCellManager.lineMarkFragment(startLine, endLine, color, editor2.getDocument(), editor2);
    }

    private static void lineMarkFragment(int startLine, int endLine, @NotNull Color color, Document document, Editor editor2) {
        if (color == null) {
            PyEditorCellManager.$$$reportNull$$$0(5);
        }
        if (startLine >= endLine || endLine >= document.getLineCount()) {
            return;
        }
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        RangeHighlighter highlighter = editor2.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyLineMarkerRenderer(color));
        editor2.putUserData(LINE_MARKER_IN_EDITOR_KEY, (Object)highlighter);
    }

    private static void removeLineMarkers(Editor editor2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = (RangeHighlighter)editor2.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && ((MarkupModelEx)editor2.getMarkupModel()).containsHighlighter(marker)) {
            marker.dispose();
        }
        editor2.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/scientific/cells/PyEditorCellManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateHighlighting";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightCell";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lineMarkFragment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLineMarkerRenderer
    implements LineMarkerRenderer {
        private static final int DEEPNESS = 0;
        private static final int THICKNESS = 1;
        private final Color myColor;

        private MyLineMarkerRenderer(@NotNull Color color) {
            if (color == null) {
                MyLineMarkerRenderer.$$$reportNull$$$0(0);
            }
            this.myColor = color;
        }

        public void paint(Editor editor2, Graphics g, Rectangle r) {
            g.setColor(this.myColor);
            g.fillRect(r.x, r.y, 1, r.height);
            g.fillRect(r.x + 1, r.y, 0, 1);
            g.fillRect(r.x + 1, r.y + r.height - 1, 0, 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/jetbrains/python/scientific/cells/PyEditorCellManager$MyLineMarkerRenderer", "<init>"));
        }
    }

    private static class MyListener
    implements CaretListener,
    DocumentListener {
        private final Project myProject;

        private MyListener(Project project) {
            this.myProject = project;
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            PyEditorCellManager.update(this.myProject, e.getEditor());
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Editor[] editors;
            if (e == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            for (Editor editor2 : editors = EditorFactory.getInstance().getEditors(e.getDocument(), this.myProject)) {
                PyEditorCellManager.update(this.myProject, editor2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/scientific/cells/PyEditorCellManager$MyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

