/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.cells;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.TimeoutUtil;
import com.jetbrains.python.console.PythonConsoleExecuteActionHandler;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import org.jetbrains.annotations.NotNull;

public class PyCellExecutionHandler {
    private final PythonConsoleView myConsoleView;
    private volatile ConsoleCommunication myConsoleCommunication;
    private volatile boolean myReady;

    public PyCellExecutionHandler(@NotNull PythonConsoleView consoleView) {
        if (consoleView == null) {
            PyCellExecutionHandler.$$$reportNull$$$0(0);
        }
        this.myReady = true;
        this.myConsoleView = consoleView;
        this.myConsoleView.whenInitialized(() -> {
            PythonConsoleExecuteActionHandler executeActionHandler = consoleView.getExecuteActionHandler();
            this.myConsoleCommunication = executeActionHandler.getConsoleCommunication();
            this.myConsoleCommunication.addCommunicationListener(new ExecutionConsoleCommunicationListener());
        });
    }

    public void execute(String text2, ProgressIndicator progressIndicator) {
        if (!text2.isEmpty()) {
            this.myReady = false;
            this.executeInConsole(text2, progressIndicator);
        }
    }

    private void executeInConsole(String text2, ProgressIndicator progressIndicator) {
        while (this.myConsoleCommunication == null) {
            TimeoutUtil.sleep((long)300L);
        }
        this.myConsoleView.executeInConsole(text2);
        this.sleepTillReadyOrCanceled(progressIndicator);
    }

    private void sleepTillReadyOrCanceled(ProgressIndicator progressIndicator) {
        while (!this.myReady) {
            if (progressIndicator.isCanceled()) {
                this.myConsoleCommunication.interrupt();
                break;
            }
            TimeoutUtil.sleep((long)300L);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/jetbrains/python/scientific/cells/PyCellExecutionHandler", "<init>"));
    }

    private class ExecutionConsoleCommunicationListener
    implements ConsoleCommunicationListener {
        private ExecutionConsoleCommunicationListener() {
        }

        @Override
        public void commandExecuted(boolean more) {
            if (!more) {
                PyCellExecutionHandler.this.myReady = true;
            }
        }

        @Override
        public void inputRequested() {
        }
    }
}

