/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.run.PythonConfigurationType;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a \u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\b\u0010\u0012\u001a\u00020\bH\u0002\u001a\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000e\u001a\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f\"\u0015\u0010\u0000\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"myDocumentationBackgroundColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/Nullable;", "getDataViewer", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "hideConsoleToolwindow", "", "hideDataViewer", "renderExternalDocumentation", "element", "Lcom/intellij/psi/PsiElement;", "render", "", "restoreDocumentationPopup", "scientificLayout", "state", "setDocFontSize", "showCommandLineInRunConfiguration", "show", "showConsoleToolwindow", "showDataViewAsToolwindow", "showDocumentationToolwindow", "intellij.python.scientific"})
public final class PyScientificViewKt {
    private static Color myDocumentationBackgroundColor;

    public static final void renderExternalDocumentation(@Nullable PsiElement element, boolean render) {
        Module module;
        Module module2 = module = element != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)element) : null;
        if (module != null) {
            PyDocumentationSettings pyDocumentationSettings = PyDocumentationSettings.getInstance(module);
            Intrinsics.checkExpressionValueIsNotNull((Object)pyDocumentationSettings, (String)"PyDocumentationSettings.getInstance(module)");
            pyDocumentationSettings.setRenderExternalDocumentation(render);
        }
    }

    public static final void showCommandLineInRunConfiguration(@NotNull Project project, boolean show) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            RunManager runManager = RunManager.Companion.getInstance(project);
            PythonConfigurationType pythonConfigurationType = PythonConfigurationType.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)pythonConfigurationType, (String)"PythonConfigurationType.getInstance()");
            PythonConfigurationType.PythonConfigurationFactory pythonConfigurationFactory = pythonConfigurationType.getFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pythonConfigurationFactory), (String)"PythonConfigurationType.getInstance().factory");
            RunnerAndConfigurationSettings template = runManager.getConfigurationTemplate((ConfigurationFactory)pythonConfigurationFactory);
            RunConfiguration runConfiguration = template.getConfiguration();
            if (!(runConfiguration instanceof PythonRunConfiguration)) {
                runConfiguration = null;
            }
            PythonRunConfiguration pythonRunConfiguration = (PythonRunConfiguration)runConfiguration;
            if (pythonRunConfiguration == null) break block1;
            pythonRunConfiguration.setShowCommandLineAfterwards(show);
        }
    }

    public static final void showConsoleToolwindow(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().assertIsDispatchThread();
        PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
        if (pythonConsoleToolWindow == null) {
            return;
        }
        PythonConsoleToolWindow pythonConsoleToolWindow2 = pythonConsoleToolWindow;
        ToolWindow toolWindow = pythonConsoleToolWindow2.getToolWindow();
        if (toolWindow == null) {
            return;
        }
        ToolWindow consoleToolWindow = toolWindow;
        consoleToolWindow.isVisible();
        consoleToolWindow.show(null);
    }

    public static final void hideConsoleToolwindow(@NotNull Project project) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
            if (pythonConsoleToolWindow == null || (pythonConsoleToolWindow = pythonConsoleToolWindow.getToolWindow()) == null) break block0;
            pythonConsoleToolWindow.hide(null);
        }
    }

    public static final void showDocumentationToolwindow(@NotNull Project project, @Nullable PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DocumentationManager documentationManager = DocumentationManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)documentationManager, (String)"DocumentationManager.getInstance(project)");
        String showInToolWindowProperty = documentationManager.getShowInToolWindowProperty();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme scheme = editorColorsScheme;
        myDocumentationBackgroundColor = scheme.getColor(DocumentationComponent.COLOR_KEY);
        scheme.setColor(DocumentationComponent.COLOR_KEY, UIUtil.getEditorPaneBackground());
        PropertiesComponent properties = PropertiesComponent.getInstance();
        properties.setValue(showInToolWindowProperty, true);
        DocumentationManager documentationManager2 = DocumentationManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)documentationManager2, (String)"DocumentationManager.getInstance(project)");
        properties.setValue(documentationManager2.getAutoUpdateEnabledProperty(), true);
        if (element != null) {
            DocumentationManager.getInstance((Project)project).showJavaDocInfo(element, element);
        }
        PyScientificViewKt.setDocFontSize();
    }

    private static final void setDocFontSize() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        EditorColorsScheme scheme = editorColorsScheme;
        int editorFontSize = scheme.getEditorFontSize();
        FontSize[] values = FontSize.values();
        FontSize fontSize = FontSize.MEDIUM;
        for (FontSize value2 : values) {
            if (value2.getSize() > editorFontSize) break;
            fontSize = value2;
        }
        DocumentationComponent.setQuickDocFontSize((FontSize)fontSize);
    }

    public static final void restoreDocumentationPopup(@NotNull Project project) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            DocumentationManager documentationManager = DocumentationManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)documentationManager, (String)"DocumentationManager.getInstance(project)");
            propertiesComponent.setValue(documentationManager.getAutoUpdateEnabledProperty(), false);
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
            EditorColorsScheme scheme = editorColorsScheme;
            scheme.setColor(DocumentationComponent.COLOR_KEY, myDocumentationBackgroundColor);
            ToolWindow window = ToolWindowManager.Companion.getInstance(project).getToolWindow("Documentation");
            if (window == null) break block1;
            DocumentationManager documentationManager2 = DocumentationManager.getInstance((Project)project);
            boolean bl = false;
            boolean bl2 = false;
            DocumentationManager $this$apply = documentationManager2;
            boolean bl3 = false;
            $this$apply.restorePopupBehavior();
            JBPopup jBPopup = $this$apply.getDocInfoHint();
            if (jBPopup != null) {
                jBPopup.cancel();
            }
        }
    }

    private static final ToolWindow getDataViewer(Project project) {
        return ToolWindowManager.Companion.getInstance(project).getToolWindow("SciView");
    }

    public static final void showDataViewAsToolwindow(@NotNull Project project) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ToolWindow toolWindow = PyScientificViewKt.getDataViewer(project);
            if (toolWindow == null) break block0;
            ToolWindow toolWindow2 = toolWindow;
            boolean bl = false;
            boolean bl2 = false;
            ToolWindow $this$apply = toolWindow2;
            boolean bl3 = false;
            $this$apply.setType(ToolWindowType.DOCKED, null);
            $this$apply.setAutoHide(false);
        }
    }

    public static final void hideDataViewer(@NotNull Project project) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ToolWindow toolWindow = PyScientificViewKt.getDataViewer(project);
            if (toolWindow == null) break block0;
            toolWindow.hide(null);
        }
    }

    public static final void scientificLayout(boolean state2, @NotNull Project project, @Nullable PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (state2) {
            PyScientificViewKt.showConsoleToolwindow(project);
            PyScientificViewKt.showDocumentationToolwindow(project, element);
            PyScientificViewKt.showDataViewAsToolwindow(project);
            PyScientificViewKt.showCommandLineInRunConfiguration(project, true);
            PyScientificViewKt.renderExternalDocumentation(element, true);
        } else {
            PyScientificViewKt.hideConsoleToolwindow(project);
            PyScientificViewKt.restoreDocumentationPopup(project);
            PyScientificViewKt.hideDataViewer(project);
            PyScientificViewKt.showCommandLineInRunConfiguration(project, false);
            PyScientificViewKt.renderExternalDocumentation(element, false);
        }
    }

    static {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        myDocumentationBackgroundColor = editorColorsManager.getGlobalScheme().getColor(DocumentationComponent.COLOR_KEY);
    }
}

